/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow.service.support;

import com.huawei.fit.plugin.gateway.workflow.entity.FluentDownloadCacheData;
import com.huawei.fit.plugin.gateway.workflow.exception.NoSuchDataException;
import com.huawei.fit.plugin.gateway.workflow.service.FluentDownloadCache;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;

@Fitable
public class DefaultFluentDownloadCache
implements FluentDownloadCache {
    private final Map<String, FluentDownloadCacheData> requestIdCacheDataMappings = new ConcurrentHashMap<String, FluentDownloadCacheData>();

    @Override
    public void init(String requestId, HttpServletResponse response) {
        this.requestIdCacheDataMappings.put(requestId, new FluentDownloadCacheData(response));
    }

    @Override
    public HttpServletResponse getResponse(String requestId) {
        return this.requireCacheData(requestId).getResponse();
    }

    @Override
    public AtomicInteger getSequence(String requestId) {
        return this.requireCacheData(requestId).getSequence();
    }

    @Override
    public void finishDownloading(String requestId) {
        this.requireCacheData(requestId).setDownloadFinished(true);
    }

    @Override
    public boolean isFinished(String requestId) {
        return this.requireCacheData(requestId).isDownloadFinished();
    }

    @Override
    public void clear(String requestId) {
        this.requestIdCacheDataMappings.remove(requestId);
    }

    private FluentDownloadCacheData requireCacheData(String requestId) {
        return (FluentDownloadCacheData)Validation.notNull((Object)this.requestIdCacheDataMappings.get(requestId), () -> new NoSuchDataException(StringUtils.format((String)"No cache data. [requestId={0}]", (Object[])new Object[]{requestId})));
    }
}

