/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow.service.support;

import com.huawei.fit.broker.server.entity.FileDescriptor;
import com.huawei.fit.broker.server.entity.Multipart;
import com.huawei.fit.broker.server.entity.Multiparts;
import com.huawei.fit.plugin.gateway.config.HttpConfig;
import com.huawei.fit.plugin.gateway.entity.HttpContext;
import com.huawei.fit.plugin.gateway.entity.ParamMapping;
import com.huawei.fit.plugin.gateway.enums.HttpParamType;
import com.huawei.fit.plugin.gateway.exception.InvalidFileNameException;
import com.huawei.fit.plugin.gateway.utils.JsonParamUtils;
import com.huawei.fit.plugin.gateway.workflow.service.HttpRequestExtractor;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.MapBuilder;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultHttpRequestExtractor
implements HttpRequestExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpRequestExtractor.class);
    private static final String EXTENSION_SEPARATOR = ".";
    private static final String EXTENSION_ALL = "*";
    private final List<String> extensionList;
    private final Map<HttpParamType, BiFunction<ParamMapping, HttpContext, Object>> functions = MapBuilder.get().put((Object)HttpParamType.QUERY, this::fromParameter).put((Object)HttpParamType.FORM_BODY, this::fromParameter).put((Object)HttpParamType.QUERY_ARRAY, this::fromParameterValues).put((Object)HttpParamType.FORM_BODY_ARRAY, this::fromParameterValues).put((Object)HttpParamType.JSON_BODY, this::fromJsonBody).put((Object)HttpParamType.HEADER, this::fromHeader).put((Object)HttpParamType.PATH_PARAM, this::fromPath).put((Object)HttpParamType.BINARY, this::fromBinary).put((Object)HttpParamType.MULTIPART, this::fromMultipart).put((Object)HttpParamType.MULTIPART_ARRAY, this::fromMultipartArray).put((Object)HttpParamType.COOKIE, this::fromCookie).build();

    public DefaultHttpRequestExtractor(HttpConfig httpConfig) {
        this.extensionList = httpConfig.getAllowedPostExtensionList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] extractRawBody(HttpServletRequest request) {
        try (ServletInputStream inputStream = request.getInputStream();){
            Validation.greaterThanOrEquals((int)request.getContentLength(), (int)0, (String)"Content-length is less than 0. [contentLength={0}]", (Object[])new Object[]{request.getContentLength()});
            byte[] byArray = IoUtils.read((InputStream)inputStream, (int)request.getContentLength());
            return byArray;
        }
        catch (IOException e) {
            log.warn("Fail to extract body. [message={}]", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Part> extractMultiPartBody(HttpServletRequest request) {
        try {
            if (CollectionUtils.isEmpty((Collection)request.getParts())) {
                log.warn("Need http servlet part, but no part.");
                return Collections.emptyList();
            }
            return new ArrayList<Part>(request.getParts());
        }
        catch (IOException | ServletException e) {
            log.warn("Fail to get http servlet part. [message={}]", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object extractParam(ParamMapping paramMapping, HttpContext context) {
        BiFunction<ParamMapping, HttpContext, Object> function = this.functions.get((Object)paramMapping.getFrom());
        Validation.notNull(function, () -> new IllegalStateException(StringUtils.format((String)"Unsupported HttpParamType. [from={0}]", (Object[])new Object[]{paramMapping.getFrom().name()})));
        return ObjectUtils.nullIf((Object)function.apply(paramMapping, context), (Object)paramMapping.getDefaultValue());
    }

    private Object fromParameter(ParamMapping paramMapping, HttpContext context) {
        HttpServletRequest request = context.getRequest();
        return request.getParameter(paramMapping.getFromKey());
    }

    private Object fromParameterValues(ParamMapping paramMapping, HttpContext context) {
        HttpServletRequest request = context.getRequest();
        return request.getParameterValues(paramMapping.getFromKey());
    }

    private Object fromJsonBody(ParamMapping paramMapping, HttpContext context) {
        String body = context.getRawBody();
        Validation.notNull((Object)body, () -> new IllegalStateException("Expected request body, but no request body."));
        String key = JsonParamUtils.decorateJsonKey(paramMapping.getFromKey());
        try {
            return JsonPath.read((String)body, (String)key, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private Object fromHeader(ParamMapping paramMapping, HttpContext context) {
        HttpServletRequest request = context.getRequest();
        return request.getHeader(paramMapping.getFromKey());
    }

    private Object fromPath(ParamMapping paramMapping, HttpContext context) {
        Map<String, String> pathVariables = context.getPathVariables();
        return pathVariables.get(paramMapping.getFromKey());
    }

    private Object fromBinary(ParamMapping paramMapping, HttpContext context) {
        HttpServletRequest request = context.getRequest();
        return this.extractRawBody(request);
    }

    private Object fromMultipart(ParamMapping paramMapping, HttpContext context) {
        return context.getParts().stream().filter(part -> Objects.equals(part.getName(), paramMapping.getFromKey())).findFirst().map(this::convert).orElse(null);
    }

    private Object fromCookie(ParamMapping paramMapping, HttpContext context) {
        return ObjectUtils.mapIfNotNull((Object)context.getRequest().getCookies(), cookies -> this.getSpecifiedCookieValue((Cookie[])cookies, paramMapping.getFromKey()));
    }

    private Object getSpecifiedCookieValue(Cookie[] cookies, String specifiedKey) {
        return Arrays.stream(cookies).filter(cookie -> StringUtils.equals((String)cookie.getName(), (String)specifiedKey)).map(Cookie::getValue).findFirst().orElse(null);
    }

    private Object fromMultipartArray(ParamMapping paramMapping, HttpContext context) {
        return Multiparts.builder().parts(this.convertParts(context.getParts())).build();
    }

    private List<Multipart> convertParts(List<Part> parts) {
        return parts.stream().map(part -> Multipart.builder().name(part.getName()).fileName(part.getSubmittedFileName()).content(this.convert2Bytes((Part)part)).build()).collect(Collectors.toList());
    }

    private Object convert(Part part) {
        String fileName = part.getSubmittedFileName();
        if (StringUtils.isBlank((String)fileName)) {
            return new String(this.convert2Bytes(part), StandardCharsets.UTF_8);
        }
        return this.convert2File(part);
    }

    private FileDescriptor convert2File(Part part) {
        this.validateFileName(part.getSubmittedFileName());
        return FileDescriptor.builder().fileName(part.getSubmittedFileName()).fileContent(this.convert2Bytes(part)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] convert2Bytes(Part part) {
        long actualSize = Validation.lessThanOrEquals((long)part.getSize(), (long)Integer.toUnsignedLong(Integer.MAX_VALUE), (String)"Too much part content. [partSize={0}]", (Object[])new Object[]{part.getSize()});
        try (InputStream input = part.getInputStream();){
            byte[] byArray = IoUtils.read((InputStream)input, (int)((int)actualSize));
            return byArray;
        }
        catch (IOException e) {
            log.warn("Fail to read part content. [message={}]", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    private void validateFileName(String fileName) {
        if (this.extensionList.contains(EXTENSION_ALL)) {
            return;
        }
        String extension = fileName.contains(EXTENSION_SEPARATOR) ? fileName.substring(fileName.indexOf(EXTENSION_SEPARATOR)) : "";
        Validation.isTrue((boolean)this.extensionList.contains(extension), () -> new InvalidFileNameException(StringUtils.format((String)"File is not allowed to upload. [fileName={0}, allowedList={1}]", (Object[])new Object[]{fileName, this.extensionList})));
    }
}

