/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow.service.support;

import com.huawei.fit.broker.server.ConvertFailedResponse;
import com.huawei.fit.broker.server.ConvertSuccessfulResponse;
import com.huawei.fit.hakuna.system.shared.entity.StringResponse;
import com.huawei.fit.plugin.gateway.entity.RestMapping;
import com.huawei.fit.plugin.gateway.workflow.service.HttpResponseHandler;
import com.huawei.fitLab.matata.ruleEngine.rule.json.Execute;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.serialization.SerializationException;
import java.util.Arrays;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultHttpResponseHandler
implements HttpResponseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpResponseHandler.class);
    private static final String ENVIRONMENT_DELIMITER = ",";
    private static final String RESPONSE_TEMPLATE = "/{\"$\":{0},\"$metadata\":/{\"code\":{1},\"message\":\"{2}\"/}/}";
    private static final int RESPONSE_CODE_OK = 0;
    private static final String RESPONSE_MSG_OK = "OK";
    private static final String RESPONSE_MSG_UNKNOWN = "Unknown";
    private final BrokerClient brokerClient;
    private final ConvertSuccessfulResponse convertSuccessfulResponse;
    private final ConvertFailedResponse convertFailedResponse;
    private final JsonSerializer serializer;
    private final String ruleCenterEnvironment;
    private final long ruleExecutorTimeout;

    public DefaultHttpResponseHandler(BrokerClient brokerClient, @Fit ConvertSuccessfulResponse convertSuccessfulResponse, @Fit ConvertFailedResponse convertFailedResponse, @Fit JsonSerializer serializer, @Value(value="${worker.environment}") String environment, @Value(value="${worker.built-in-environments}") String builtInEnvironments, @Value(value="${matata.rule-center.default-environment}") String defaultRuleCenterEnvironment, @Value(value="${fitable.rule-executor.timeout}") Integer timeout) {
        this.brokerClient = brokerClient;
        this.convertSuccessfulResponse = convertSuccessfulResponse;
        this.convertFailedResponse = convertFailedResponse;
        this.serializer = serializer;
        log.info("Config worker.environment is {}.", (Object)environment);
        log.info("Config worker.built-in-environments is {}.", (Object)builtInEnvironments);
        log.info("Config matata.rule-center.default-environment is {}.", (Object)defaultRuleCenterEnvironment);
        Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
        Validation.notBlank((String)builtInEnvironments, (String)"No built-in environments. [config=worker.built-in-environments]", (Object[])new Object[0]);
        Validation.notBlank((String)defaultRuleCenterEnvironment, (String)"No default Rule-Center environment. [config=matata.rule-center.default-environment]", (Object[])new Object[0]);
        this.ruleCenterEnvironment = this.isContains(builtInEnvironments, environment) ? environment : defaultRuleCenterEnvironment;
        log.info("Worker environment of Rule-Center is {}.", (Object)this.ruleCenterEnvironment);
        this.ruleExecutorTimeout = ((Integer)ObjectUtils.nullIf((Object)timeout, (Object)3000)).intValue();
        log.info("Rule executor timeout is {}.", (Object)this.ruleExecutorTimeout);
    }

    @Override
    public String handleError(String genericableId, Throwable throwable, RestMapping restMapping) {
        if (throwable instanceof MethodInvocationException) {
            Throwable cause = throwable.getCause();
            return throwable == cause ? this.handleUnknownException(genericableId, throwable) : this.handleError(genericableId, cause, restMapping);
        }
        if (throwable instanceof FitException) {
            return this.handleFitException(genericableId, (FitException)throwable, restMapping);
        }
        return this.handleUnknownException(genericableId, throwable);
    }

    private String handleFitException(String genericId, FitException ex, RestMapping restMapping) {
        log.warn("Handle fit exception step1: {}.", (Object)ex.getMessage());
        log.debug("Handle fit exception stack trace:", (Throwable)ex);
        log.warn("Handle fit exception step2: error code is {}, error message is {}.", (Object)ex.getCode(), (Object)ex.getMessage());
        String response = null;
        if (restMapping != null && StringUtils.isNotBlank((String)restMapping.getRuleId())) {
            response = this.applyTemplateIfPresent(null, restMapping.getRuleId(), ex);
        }
        if (StringUtils.isNotBlank(response)) {
            return response;
        }
        return this.handleIncorrectResponse(genericId, ex.getCode(), ex.getMessage());
    }

    private String handleUnknownException(String genericId, Throwable throwable) {
        log.warn("Handle non-fit exception: {}.", (Object)(throwable != null ? throwable.getClass().getName() + ":" + throwable.getMessage() : "throwable is null"));
        log.debug("Handle non-fit exception stack trace:", throwable);
        return this.handleIncorrectResponse(genericId, 0x7F000000, "unknown error");
    }

    private String applyTemplateIfPresent(String originalResponse, String templateRuleId, FitException exception) {
        try {
            return ((Execute)this.brokerClient.getProxy(Execute.class, InvokeContext.builder().timeout(Long.valueOf(this.ruleExecutorTimeout)).build())).process(this.ruleCenterEnvironment, templateRuleId, this.buildTemplateDataSource(originalResponse, exception));
        }
        catch (Exception e) {
            log.warn("apply template rule failed. failed reason is: {}", (Object)ExceptionUtils.getReason((Throwable)e));
            throw e;
        }
    }

    private String buildTemplateDataSource(String originalResponse, FitException exception) {
        if (StringUtils.isNotBlank((String)originalResponse)) {
            return StringUtils.format((String)RESPONSE_TEMPLATE, (Object[])new Object[]{originalResponse, 0, RESPONSE_MSG_OK});
        }
        if (exception != null) {
            return this.serializeDataSource(exception.getCode(), exception.getMessage());
        }
        return StringUtils.format((String)RESPONSE_TEMPLATE, (Object[])new Object[]{null, 0x7F000000, RESPONSE_MSG_UNKNOWN});
    }

    private String serializeDataSource(int code, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$", null);
        map.put("$metadata", this.buildMetadata(code, message));
        return this.serializer.serialize(map);
    }

    private Object buildMetadata(int code, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("message", message);
        return map;
    }

    @Override
    public String handleCorrectResponse(String genericableId, String response) {
        try {
            return this.convertSuccessfulResponse.process(genericableId, response);
        }
        catch (Exception e) {
            return response;
        }
    }

    private String handleIncorrectResponse(String genericId, Integer errorCode, String errorMessage) {
        try {
            return this.convertFailedResponse.process(genericId, errorCode, errorMessage);
        }
        catch (Exception e) {
            return errorCode + ":" + errorMessage;
        }
    }

    @Override
    public String convertResponse(StringResponse response, RestMapping restMapping) {
        if (this.hasResponseRule(restMapping)) {
            String data = this.isRawString(response) ? this.serializer.serialize((Object)response.getData()) : response.getData();
            return this.applyTemplateIfPresent(data, restMapping.getRuleId(), null);
        }
        if (this.isRawString(response)) {
            return response.getData();
        }
        try {
            return (String)this.serializer.deserialize(response.getData(), String.class);
        }
        catch (SerializationException e) {
            return response.getData();
        }
    }

    private boolean isRawString(StringResponse response) {
        if (response.getIsRawString() == null) {
            return false;
        }
        return response.getIsRawString();
    }

    private boolean hasResponseRule(RestMapping restMapping) {
        return restMapping != null && StringUtils.isNotBlank((String)restMapping.getRuleId());
    }

    private boolean isContains(String builtInEnvironments, String environment) {
        return Arrays.asList(builtInEnvironments.split(ENVIRONMENT_DELIMITER)).contains(environment);
    }
}

