/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow.service.support;

import com.huawei.fit.hakuna.system.exception.HandleWebException;
import com.huawei.fit.hakuna.system.exception.entity.WebExceptionInfo;
import com.huawei.fit.hakuna.system.exception.entity.WebResponse;
import com.huawei.fit.plugin.gateway.workflow.service.WebExceptionHandler;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.workflow.Input;
import java.util.HashMap;
import java.util.Map;

@Fitable
public class DefaultWebExceptionHandler
implements WebExceptionHandler {
    private final ProxyFactory proxyFactory;

    public DefaultWebExceptionHandler(@Fit ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public boolean isWebException(Exception ex) {
        return ex instanceof FitException && ((FitException)((Object)ex)).getProperties().containsKey("fitExceptionHandleId");
    }

    @Override
    public WebResponse handle(Input input, FitException ex) {
        return ((HandleWebException)this.proxyFactory.getBrokerClient().getProxyByFitableId(HandleWebException.class, this.getExceptionHandleId(ex))).process(this.buildWebExceptionInfo(ex));
    }

    private String getExceptionHandleId(FitException ex) {
        return Validation.notBlank((String)((String)ex.getProperties().get("fitExceptionHandleId")), (String)"Handle id of custom exception cannot be blank.", (Object[])new Object[0]);
    }

    private WebExceptionInfo buildWebExceptionInfo(FitException ex) {
        return WebExceptionInfo.builder().fitableId(ex.getFitableId()).code(Integer.valueOf(ex.getCode())).genericableId(ex.getGenericableId()).properties(this.getExceptionInfoProperties(ex)).detailMessage(ex.getMessage()).build();
    }

    private Map<String, String> getExceptionInfoProperties(FitException ex) {
        HashMap<String, String> map = new HashMap<String, String>(ex.getProperties());
        map.remove("fitExceptionHandleId");
        return map;
    }
}

