/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fit.plugin.gateway.workflow.service.support;

import com.huawei.fit.plugin.gateway.workflow.service.FluentDownloadCache;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.UuidUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.runtime.DownloadedDataObserver;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;

@Fitable
public class FluentDownloadedDataObserver
implements DownloadedDataObserver {
    private final FluentDownloadCache cache;

    public FluentDownloadedDataObserver(FluentDownloadCache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDownloadedPropertiesReceived(String requestId, String fileName, long length, Map<String, String> properties) {
        HttpServletResponse response;
        HttpServletResponse httpServletResponse = response = (HttpServletResponse)Validation.notNull((Object)this.cache.getResponse(requestId), (String)"No http response. [requestId={0}]", (Object[])new Object[]{requestId});
        synchronized (httpServletResponse) {
            String actualFilename = StringUtils.isNotBlank((String)fileName) ? fileName : UuidUtils.randomUuidString();
            response.setHeader("Content-Disposition", "attachment;filename=" + actualFilename);
            response.setHeader("Content-Length", String.valueOf(length));
            properties.entrySet().stream().filter(entry -> StringUtils.isNotBlank((String)((String)entry.getKey()))).filter(entry -> StringUtils.isNotBlank((String)((String)entry.getValue()))).forEach(entry -> response.setHeader((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDownloadedDataReceived(String requestId, int sequence, byte[] content) {
        HttpServletResponse response;
        AtomicInteger curSeq = (AtomicInteger)Validation.notNull((Object)this.cache.getSequence(requestId), (String)"No sequence of downloaded data. [requestId={0}]", (Object[])new Object[]{requestId});
        if (curSeq.incrementAndGet() != sequence) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to download files: sequence mismatch when writing. [requestId={0}, curSequence={1}, receivedSequence={2}]", (Object[])new Object[]{requestId, curSeq.get(), sequence}));
        }
        HttpServletResponse httpServletResponse = response = (HttpServletResponse)Validation.notNull((Object)this.cache.getResponse(requestId), (String)"No http response. [requestId={0}]", (Object[])new Object[]{requestId});
        synchronized (httpServletResponse) {
            try {
                response.getOutputStream().write(content);
            }
            catch (IOException e) {
                String message = StringUtils.format((String)"Fail to download: {0}. [requestId={1}, scenario=write]", (Object[])new Object[]{e.getMessage(), requestId});
                throw new FitException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDownloadedDataFinished(String requestId, int sequence) {
        HttpServletResponse response;
        AtomicInteger curSeq = (AtomicInteger)Validation.notNull((Object)this.cache.getSequence(requestId), (String)"No sequence of downloaded data. [requestId={0}]", (Object[])new Object[]{requestId});
        if (curSeq.incrementAndGet() != sequence) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to download files: sequence mismatch after writing. [requestId={0}, curSequence={1}, receivedSequence={2}]", (Object[])new Object[]{requestId, curSeq.get(), sequence}));
        }
        HttpServletResponse httpServletResponse = response = (HttpServletResponse)Validation.notNull((Object)this.cache.getResponse(requestId), (String)"No http response. [requestId={0}]", (Object[])new Object[]{requestId});
        synchronized (httpServletResponse) {
            try {
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                String message = StringUtils.format((String)"Fail to download: {0}. [requestId={1}, scenario=write]", (Object[])new Object[]{e.getMessage(), requestId});
                throw new FitException(message);
            }
            this.cache.finishDownloading(requestId);
        }
    }
}

