/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.config.validate;

import com.huawei.ism.tool.obase.config.resource.PromptResource;
import com.huawei.ism.tool.obase.config.validate.AbstractValidator;
import com.huawei.ism.tool.obase.utils.ClassUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;

public final class CommonValidators {

    public static class LargeThan
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (null == object || params.length == 0) {
                return true;
            }
            Double val = null;
            Double givenVal = null;
            try {
                val = Double.valueOf(object.toString());
                givenVal = Double.valueOf(params[0].toString());
            }
            catch (NumberFormatException e) {
                return true;
            }
            if (val.compareTo(givenVal) <= 0) {
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.largethan", objectDesc, params[0]));
                return false;
            }
            return true;
        }
    }

    public static class Max
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (null == object || params.length == 0) {
                return true;
            }
            Double val = null;
            Double max = null;
            try {
                val = Double.valueOf(object.toString());
                max = Double.valueOf(params[0].toString());
            }
            catch (NumberFormatException e) {
                return true;
            }
            if (val.compareTo(max) > 0) {
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.max", objectDesc, params[0]));
                return false;
            }
            return true;
        }
    }

    public static class MaxLength
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean flag = true;
            if (null != object && object.toString().length() > Integer.parseInt((String)params[0])) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.maxlength", objectDesc, params[0]));
            }
            return flag;
        }
    }

    public static class Int
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean flag = true;
            if (null != object && !object.toString().matches("[0-9]+")) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.int", objectDesc));
            }
            return flag;
        }
    }

    public static class NoChinese
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean flag = true;
            if (null != object && !object.toString().matches("[0-9a-zA-Z_-]*")) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.contain.chinese", objectDesc));
            }
            return flag;
        }
    }

    public static class Mask
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean a = true;
            if (null != object && !StringUtils.ipMaskBinaryCheck(object.toString())) {
                a = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.mask", objectDesc));
            }
            return a;
        }
    }

    public static class Macs
    extends AbstractValidator {
        @Override
        public boolean validate(Object obj, String objectDesc, Object ... params) {
            if (null == obj || "".equals(obj)) {
                return true;
            }
            boolean a = true;
            for (String mac : obj.toString().split(";")) {
                if (StringUtils.isCorrectMac(mac)) continue;
                a = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.macs", objectDesc));
                break;
            }
            return a;
        }
    }

    public static class Mac
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean flag = true;
            if (null != object && !"".equals(object) && !StringUtils.isCorrectMac(object.toString())) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.mac", objectDesc));
            }
            return flag;
        }
    }

    public static class Ipv4v6
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean flag = true;
            String str = ClassUtils.objectToString(object);
            if (!StringUtils.allIsVaildIpv6(str) && !StringUtils.allIsVaildIpv4(str)) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.ipv4", objectDesc));
            }
            return flag;
        }
    }

    public static class Ipv4
    extends AbstractValidator {
        @Override
        public boolean validate(Object obj, String objectDesc, Object ... params) {
            boolean flag = true;
            if (null != obj && !"".equals(obj) && !StringUtils.allIsVaildIpv4(ClassUtils.objectToString(obj))) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.ipv4", objectDesc));
            }
            return flag;
        }
    }

    public static class Integrality
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (params.length == 0) {
                return true;
            }
            Object p = params[0];
            boolean flag = null == p || "".equals(p);
            for (int i = 1; i < params.length; ++i) {
                boolean b2;
                p = params[i];
                boolean bl = b2 = null == p || "".equals(p);
                if (b2 == flag) continue;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.integrality", objectDesc));
                return false;
            }
            return true;
        }
    }

    public static class NotNull
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean flag = true;
            if (null == object || "".equals(object)) {
                flag = false;
                super.setErrMsg(PromptResource.getStringWithParams("validate.error.notnull", objectDesc));
            }
            return flag;
        }
    }
}

