/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.IniReader;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Locale;

public class PlusPackageDesc {
    private FuncType packageFuncType;
    private String releaseTime = "";
    private String packageVersion = "";
    private String productName = "";
    private String packageDescZh = "";
    private String packageDescEn = "";
    private String nodeTypedescEn = "";
    private String nodeTypedescZh = "";

    public String getNodeTypedescEn() {
        return this.nodeTypedescEn;
    }

    public void setNodeTypedescEn(String nodeTypedescEn) {
        this.nodeTypedescEn = nodeTypedescEn;
    }

    public String getNodeTypedescZh() {
        return this.nodeTypedescZh;
    }

    public void setNodeTypedescZh(String nodeTypedescZh) {
        this.nodeTypedescZh = nodeTypedescZh;
    }

    public boolean isValid() {
        boolean notHhasNull = !StringUtils.hasNULLStr(this.productName, this.releaseTime, this.packageVersion);
        return notHhasNull && null != this.packageFuncType;
    }

    public void loadProperties(IniReader version) {
        String funcType = version.getString("package.type");
        this.productName = version.getString("package.name");
        this.releaseTime = version.getString("date");
        this.packageVersion = version.getString("package.version");
        this.packageDescEn = version.getString("package.desc.zh");
        this.packageDescZh = version.getString("package.desc.en");
        this.nodeTypedescEn = version.getString("nodeType.desc.en");
        this.nodeTypedescZh = version.getString("nodeType.desc.zh");
        try {
            this.packageFuncType = FuncType.valueOf(funcType.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", e);
        }
    }

    public FuncType getPackageFuncType() {
        return this.packageFuncType;
    }

    public String getReleaseTime() {
        return this.releaseTime;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPackageDescZh() {
        return this.packageDescZh;
    }

    public String getPackageDescEn() {
        return this.packageDescEn;
    }

    public static enum FuncType {
        INSPECTOR,
        COLLECT,
        ARRAYUPGRADE,
        FWUPGRADE,
        CROSSVERSIONUPGRADE;

    }
}

