/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.processor.parser;

import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.entity.TSonData;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.processor.parser.AbstractReturnParser;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlReturnParser
extends AbstractReturnParser {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";

    @Override
    protected List<TSonData> parseReturnData(String cmdResult) throws ToolException {
        ArrayList<TSonData> results = new ArrayList<TSonData>();
        Element commandNode = this.createElementBy(cmdResult);
        Collection<Element> children = XmlUtils.getChildren(commandNode);
        for (Element nodeNode : children) {
            String tagName = nodeNode.getTagName();
            String nodeName = "";
            if ("Node".equalsIgnoreCase(tagName)) {
                nodeName = nodeNode.getAttribute("name").trim();
                Collection<Element> recordNodes = XmlUtils.getChildren(nodeNode);
                for (Element recordNode : recordNodes) {
                    TSonData data = this.parseJSonData(nodeName, recordNode);
                    results.add(data);
                }
                continue;
            }
            if ("Record".equalsIgnoreCase(tagName)) {
                TSonData data = this.parseJSonData("", nodeNode);
                results.add(data);
                continue;
            }
            throw new ToolException("The reponse error:" + cmdResult);
        }
        return results;
    }

    private TSonData parseJSonData(String nodeName, Element recordNode) throws ToolException {
        String recordname = "";
        if ("Record".equalsIgnoreCase(recordNode.getTagName().trim())) {
            recordname = recordNode.getAttribute("name").trim();
        }
        Collection<Element> filedNodes = XmlUtils.getChildren(recordNode);
        List<KeyValue<String, String>> keyValues = this.parseFiledNode(filedNodes);
        TSonData data = new TSonData();
        if (!"".equals(nodeName)) {
            data.addData(new KeyValue<String, String>("Node", nodeName));
        }
        if (!"".equals(recordname)) {
            data.addData(new KeyValue<String, String>("Record", recordname));
        }
        data.addDatas(keyValues);
        return data;
    }

    private List<KeyValue<String, String>> parseFiledNode(Collection<Element> filedNodes) throws ToolException {
        ArrayList<KeyValue<String, String>> keyValues = new ArrayList<KeyValue<String, String>>();
        for (Element element : filedNodes) {
            if ("Field".equalsIgnoreCase(element.getTagName())) {
                String nameAttr = element.getAttribute("name");
                String valueAttr = element.getAttribute("value");
                KeyValue<String, String> keyValue = new KeyValue<String, String>(nameAttr, valueAttr);
                keyValues.add(keyValue);
                continue;
            }
            throw new ToolException("The record node can only have field node:" + element.toString());
        }
        return keyValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element createElementBy(String cmdReturn) throws ToolException {
        int beginIndex = cmdReturn.indexOf("<command");
        int endIndex = cmdReturn.indexOf("</command>");
        if (-1 == beginIndex) throw new ToolException("The result xml \"" + cmdReturn + "\" parse error:");
        if (-1 == endIndex) {
            throw new ToolException("The result xml \"" + cmdReturn + "\" parse error:");
        }
        String returnXml = cmdReturn.substring(beginIndex, endIndex + "</command>".length());
        if (!cmdReturn.contains("<?xml")) {
            returnXml = XML_HEADER + ToolConstants.ENTER + returnXml;
        }
        try (InputStream is = this.encodeXML(returnXml);){
            Document doc = XmlUtils.parseDocument(is);
            Element element = doc.getDocumentElement();
            return element;
        }
        catch (Exception e) {
            throw new ToolException("The result xml \"" + cmdReturn + "\" parse error:", e);
        }
    }

    private InputStream encodeXML(String xml) throws UnsupportedEncodingException {
        byte[] bs = xml.getBytes("utf-8");
        ByteArrayInputStream result = new ByteArrayInputStream(bs);
        return result;
    }
}

