/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.rest.bean;

import java.util.Locale;

public enum ParamType {
    BOOLEAN_TYPE(10),
    U32INT_TYPE(11),
    U64LONG_TYPE(12),
    STRING_TYPE(13),
    BIG_STRING_TYPE(14),
    INVALIDATE(0),
    MEMORY(1),
    STRING(2, "e_string"),
    UNSIGN_INT(3, "e_uint"),
    SIGN_INT(4),
    BOOL(5, "e_bool"),
    ENUM(6, "e_enum"),
    ARRAY(7, "e_array"),
    JSON(8, "e_json"),
    TIME(9, "e_time");

    private int intValue = 0;
    private String name = "";

    private ParamType(int value) {
        this.intValue = value;
    }

    private ParamType(int value, String name) {
        this.intValue = value;
        this.name = name;
    }

    public int value() {
        return this.intValue;
    }

    public String getName() {
        return this.name;
    }

    public static ParamType getParamType(int value) {
        for (ParamType type : ParamType.values()) {
            if (type.intValue != value) continue;
            return type;
        }
        return null;
    }

    public static ParamType getParamType(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        for (ParamType type : ParamType.values()) {
            if (!name.toLowerCase(Locale.getDefault()).equals(type.name)) continue;
            return type;
        }
        return null;
    }
}

