/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.AutomateUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;

public class FirewallHandlePanel
extends JPanel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FirewallHandlePanel.class);
    private static final long serialVersionUID = 8290469842184578383L;
    private ToolHyperLinkLabel downloadScript = new ToolHyperLinkLabel(ResourceUtil.getString("firewall.text.download"));
    private ToolHyperLinkLabel seeHelp = new ToolHyperLinkLabel(ResourceUtil.getString("firewall.text.seehelp"));
    private Window parent = null;
    private JCheckBox confirmCheckBox = new JCheckBox(ResourceUtil.getString("firewall.text.comfirm"));
    private boolean showCheckComfirm;

    public FirewallHandlePanel(Window parent) {
        this(parent, true);
    }

    public FirewallHandlePanel(Window parent, boolean showCheckComfirm) {
        this.showCheckComfirm = showCheckComfirm;
        this.parent = parent;
        this.initLayout();
        this.bondListner();
    }

    private void bondListner() {
        this.downloadScript.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FirewallHandlePanel.this.savePackage(e);
            }
        });
        this.seeHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String helpFileName = "ToolBox" + File.separator + "firewallhandle";
                com.huawei.ism.tool.obase.utils.FileUtils.openHelpFile(helpFileName, FirewallHandlePanel.this.parent);
            }
        });
    }

    private void savePackage(MouseEvent e) {
        if (1 != e.getButton()) {
            return;
        }
        String title = ResourceUtil.getString("firewall.text.save.package");
        String filePath = ToolFileChooser.getSaveFilePath(title, "zip", this.parent, "FirewallScript.zip", "FirewallHandlePanel_save_id");
        if (null == filePath) {
            return;
        }
        long requiredFreeDisk = 0x200000L;
        if (!FileUtils.isDiskFull((String)filePath, (long)requiredFreeDisk)) {
            ToolLoggerFactory.getLogger(ToolFileChooser.class).error("The selected disk space in not enough.");
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString("firewall.text.save.package.failed"));
            return;
        }
        if (this.writeSriptFile2Local(filePath)) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString("firewall.text.save.package.succ"));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[download firewall script >> " + filePath + "][Success]");
            }
        } else {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString("firewall.text.save.package.error"));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[download firewall script >> " + filePath + "][Failed]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeSriptFile2Local(String filePath) {
        InputStream ins;
        block11: {
            FileOutputStream outs;
            block9: {
                boolean bl;
                block10: {
                    ins = FirewallHandlePanel.class.getResourceAsStream("/config/FirewallScript.zip");
                    outs = null;
                    if (null != ins) break block9;
                    bl = false;
                    if (null == outs) break block10;
                    StreamUtils.closeStream(outs, null);
                }
                StreamUtils.closeStream(null, ins);
                return bl;
            }
            try {
                outs = new FileOutputStream(new File(filePath));
                byte[] b = new byte[1024];
                int size = 0;
                while ((size = ins.read(b, 0, 1024)) != -1) {
                    ((OutputStream)outs).write(b, 0, size);
                }
                if (null == outs) break block11;
            }
            catch (IOException e) {
                boolean bl;
                block12: {
                    ToolLoggerFactory.getLogger(FirewallHandlePanel.class).error("Save FirewallScript.zip file error.", e);
                    bl = false;
                    if (null == outs) break block12;
                    {
                        catch (Throwable throwable) {
                            if (null != outs) {
                                StreamUtils.closeStream(outs, null);
                            }
                            StreamUtils.closeStream(null, ins);
                            throw throwable;
                        }
                    }
                    StreamUtils.closeStream(outs, null);
                }
                StreamUtils.closeStream(null, ins);
                return bl;
                catch (Exception e1) {
                    boolean bl2;
                    block13: {
                        ToolLoggerFactory.getLogger(FirewallHandlePanel.class).error("Save FirewallScript.zip file error.", e1);
                        bl2 = false;
                        if (null == outs) break block13;
                        StreamUtils.closeStream(outs, null);
                    }
                    StreamUtils.closeStream(null, ins);
                    return bl2;
                }
            }
            StreamUtils.closeStream(outs, null);
        }
        StreamUtils.closeStream(null, ins);
        return true;
    }

    private void initLayout() {
        JLabel imgLabel = new JLabel(ResourceUtil.getImage("important.png"));
        IsmTextArea descLabel = UCD.createTextArea((String)ResourceUtil.getString("firewall.text.overall"));
        AutomateUtils.setNameAttribute((Component)descLabel, "descLabel");
        JPanel promtPanel = new JPanel();
        promtPanel.setLayout(new BoxLayout(promtPanel, 0));
        promtPanel.add(imgLabel);
        promtPanel.add(Box.createHorizontalStrut(12));
        promtPanel.add((Component)descLabel);
        IsmTextArea method1Label = UCD.createTextArea((String)ResourceUtil.getString("firewall.text.method1"));
        JLabel method2Label = new JLabel(ResourceUtil.getString("firewall.text.method2"));
        AutomateUtils.setNameAttribute((Component)method1Label, "methodLabel1");
        AutomateUtils.setNameAttribute(method2Label, "methodLabel2");
        this.setLayout(new BoxLayout(this, 1));
        this.add(UCD.buildHBoxLeft((Component[])new Component[]{promtPanel}));
        this.add(Box.createVerticalStrut(12));
        this.add(UCD.buildHBoxLeft((Component[])new Component[]{method1Label}));
        this.add(Box.createVerticalStrut(12));
        this.add(UCD.buildHBoxLeft((Component[])new Component[]{this.downloadScript}));
        this.add(Box.createVerticalStrut(12));
        this.add(UCD.buildHBoxLeft((Component[])new Component[]{method2Label}));
        this.add(Box.createVerticalStrut(12));
        this.add(UCD.buildHBoxLeft((Component[])new Component[]{this.seeHelp}));
        this.add(Box.createVerticalStrut(12));
        if (this.showCheckComfirm) {
            this.add(UCD.buildHBoxLeft((Component[])new Component[]{this.confirmCheckBox}));
        }
        AutomateUtils.setNameAttribute(this.downloadScript, "downLoadScript");
        AutomateUtils.setNameAttribute(this.seeHelp, "seeHelp");
    }

    public boolean isConfirmFirewall() {
        return this.confirmCheckBox.isSelected();
    }
}

