/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.runtime.SystemProperties;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IToolBoxUI;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class FuncItem
extends JPanel {
    private static final long serialVersionUID = 4411480045910260075L;
    private static final int FONT_BORD = 20;
    private static final int GRID_HEIGHT = 2;
    private static final int NUM_6 = 6;
    private static final int NUM_17 = 17;
    private static final int NUM_31 = 31;
    private ToolAction action = null;
    private boolean highLight = false;
    private JLabel nameLabel = new JLabel("");
    private JTextArea descLabel = UCD.createTextArea((String)"");
    private ImageIcon icon = new ImageIcon();
    private String toolId;

    public FuncItem(ImageIcon icon, String funcName, String desc) {
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(icon);
        this.icon = icon;
        this.nameLabel.setText(funcName);
        this.descLabel.setText(desc);
        this.nameLabel.setName(funcName);
        this.descLabel.setName(funcName);
        UiMethod.setFont(this.nameLabel, new Font("Arail", 1, 20), new Font("\u5b8b\u4f53", 1, 20));
        ToolUCD.setStandardFont(this.descLabel);
        this.addListsners();
        this.initLayout(iconLabel, this.nameLabel, this.descLabel);
        this.setOpaque(false);
    }

    public FuncItem(ImageIcon icon, String funcName, String desc, ToolAction action) {
        this(icon, funcName, desc);
        this.action = action;
    }

    protected void addListsners() {
        FuncItemMouseAdapter mouseAdter = new FuncItemMouseAdapter(this);
        this.addMouseListener(mouseAdter);
        this.descLabel.addMouseListener(mouseAdter);
        this.nameLabel.addMouseListener(mouseAdter);
    }

    @Override
    public String getUIClassID() {
        return "FuncItemUI";
    }

    private void initLayout(JLabel iconLabel, JLabel nLabel, JTextArea dLabel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gContents = new GridBagConstraints();
        gContents.anchor = 17;
        gContents.insets = new Insets(0, 6, 0, 0);
        gContents.gridx = 0;
        gContents.gridy = 0;
        gContents.weightx = 0.0;
        gContents.gridheight = 2;
        this.add((Component)iconLabel, gContents);
        gContents.gridx = 1;
        gContents.weightx = 1.0;
        gContents.gridheight = 1;
        gContents.fill = 1;
        this.add((Component)nLabel, gContents);
        gContents.gridy = 1;
        this.add((Component)dLabel, gContents);
    }

    public boolean isHighLight() {
        return this.highLight;
    }

    public void setHighLight(boolean highLight) {
        this.highLight = highLight;
    }

    public String getFuncName() {
        return this.nameLabel.getText();
    }

    public ToolAction getAction() {
        return this.action;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JTextArea getDescLabel() {
        return this.descLabel;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getToolId() {
        return this.toolId;
    }

    public void setToolId(String toolId) {
        this.toolId = toolId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FuncItem)) {
            return false;
        }
        FuncItem target = (FuncItem)obj;
        return this.nameLabel.getText().equals(target.getNameLabel().getText());
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.nameLabel.getText().hashCode();
        return result;
    }

    private static class FuncItemMouseAdapter
    extends MouseAdapter {
        private static final String TOOLINI = "tool.ini";
        private FuncItem item = null;

        public FuncItemMouseAdapter(FuncItem item) {
            this.item = item;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            boolean toolEdition = this.isToolsEdition();
            if (!toolEdition) {
                return;
            }
            if (null != this.item.action) {
                this.item.action.actionPerformed(null);
            }
        }

        private boolean isToolsEdition() {
            boolean valueB = false;
            String iniDate = "";
            try {
                String path = ApplicationContext.getInstance().getWorkPath() + File.separator + "tools" + File.separator + this.item.getToolId();
                SystemProperties appConfigs = new SystemProperties(path);
                String value = appConfigs.getValue("app.ui.prompt");
                String iniPath = path + File.separator + TOOLINI;
                IniReader iniFile = new IniReader(new File(iniPath));
                iniDate = iniFile.getString("date");
                valueB = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("this tool Unsupported Cue function:" + e);
                return true;
            }
            if (valueB) {
                return this.isDownAndAnalyzeFile(iniDate);
            }
            return true;
        }

        /*
         * Exception decompiling
         */
        private boolean isDownAndAnalyzeFile(String iniDate) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isJudgeVersionNumber(String iniDate, List<Element> ts) throws ParseException {
            for (Element toolEl : ts) {
                String id = XmlUtils.getAttribute((Element)toolEl, (String)"id");
                if (!id.equals(this.item.getToolId())) continue;
                String releaseDate = XmlUtils.getAttribute((Element)toolEl, (String)"releaseDate");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMdd");
                Date onlineDate = df.parse(releaseDate);
                long onlineD = Integer.parseInt(df1.format(onlineDate));
                Date localDate = df.parse(iniDate);
                long localD = Integer.parseInt(df1.format(localDate));
                ToolLoggerFactory.getLogger(this.getClass()).info("tools onlineTime:" + onlineD + "   localTime:" + localD);
                return this.isShowDialog(onlineD, localD);
            }
            return true;
        }

        private boolean isShowDialog(long onlineD, long localD) {
            WarningDialog warning;
            if (localD < onlineD && 0 == (warning = DialogUtils.showYesNoDialog((Window)ApplicationContext.getInstance().getToolUiManager().getMainframe(), (String)ResourceUtil.getString("toolbox.old.new.version.edition"))).getValue()) {
                IToolBoxUI toolBox = (IToolBoxUI)PublicUiManage.getInstance().getUi(IToolBoxUI.class);
                String tabName = ResourceUtil.getString("toolstore.tab.title.name");
                toolBox.showToolStore(tabName);
                return false;
            }
            return true;
        }

        private boolean isShowExceptionDialog(Object e) {
            ToolLoggerFactory.getLogger(this.getClass()).info("download file error!" + e);
            WarningDialog warning = DialogUtils.showYesNoDialog((Window)ApplicationContext.getInstance().getToolUiManager().getMainframe(), (String)ResourceUtil.getString("toolbox.download.error.version.edition"));
            return 0 == warning.getValue();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.item.setCursor(new Cursor(12));
            this.item.setHighLight(true);
            this.item.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.item.setHighLight(false);
            this.item.repaint();
        }
    }
}

