/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SettingItem
extends JPanel {
    private static final int NUMBER_243 = 243;
    private static final long serialVersionUID = 4411480045910260075L;
    private static final int FONT_BORD = 20;
    private static final int GRID_HEIGHT = 2;
    private static final int NUM_6 = 6;
    private static final int NUM_17 = 17;
    private static final int NUM_31 = 31;
    private static final Dimension ITEM_SIZE = new Dimension(380, 100);
    private ToolAction action = null;
    private boolean highLight = false;
    private JLabel nameLabel = new JLabel("");
    private JTextArea descLabel = UCD.createTextArea((String)"");
    private ImageIcon icon = new ImageIcon();
    private String toolId;
    private boolean assistFunc;

    public SettingItem(ImageIcon icon, String funcName, String desc) {
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(icon);
        this.icon = icon;
        this.nameLabel.setText(funcName);
        this.descLabel.setText(desc);
        UiMethod.setFont(this.nameLabel, new Font("Arail", 1, 20), new Font("\u5b8b\u4f53", 1, 20));
        ToolUCD.setStandardFont(this.descLabel);
        this.addListsners();
        this.initLayout(iconLabel, this.nameLabel, this.descLabel);
    }

    public SettingItem(ImageIcon icon, String funcName, String desc, ToolAction action) {
        this(icon, funcName, desc);
        this.action = action;
    }

    public SettingItem(ImageIcon icon, String funcName, String desc, ToolAction action, boolean assistFunc) {
        this(icon, funcName, desc, action);
        this.assistFunc = assistFunc;
    }

    protected void addListsners() {
        FuncItemMouseAdapter mouseAdter = new FuncItemMouseAdapter(this);
        this.addMouseListener(mouseAdter);
        this.descLabel.addMouseListener(mouseAdter);
        this.nameLabel.addMouseListener(mouseAdter);
    }

    private void initLayout(JLabel iconLabel, JLabel nLabel, JTextArea dLabel) {
        this.setPreferredSize(ITEM_SIZE);
        this.setMaximumSize(ITEM_SIZE);
        this.setLayout(new GridBagLayout());
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.anchor = 17;
        bagConstraints.insets = new Insets(0, 6, 0, 0);
        bagConstraints.gridx = 0;
        bagConstraints.gridy = 0;
        bagConstraints.weightx = 0.0;
        bagConstraints.gridheight = 2;
        this.add((Component)iconLabel, bagConstraints);
        bagConstraints.gridx = 1;
        bagConstraints.weightx = 1.0;
        bagConstraints.gridheight = 1;
        bagConstraints.fill = 1;
        this.add((Component)nLabel, bagConstraints);
        bagConstraints.gridy = 1;
        this.add((Component)dLabel, bagConstraints);
        this.setBorder(BorderFactory.createLineBorder(new Color(228, 228, 228)));
        this.setBackground(Color.white);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SettingItem)) {
            return false;
        }
        SettingItem target = (SettingItem)obj;
        return this.nameLabel.getText().equals(target.getNameLabel().getText());
    }

    public boolean isHighLight() {
        return this.highLight;
    }

    public void setHighLight(boolean highLight) {
        this.highLight = highLight;
    }

    public boolean isAssistFunc() {
        return this.assistFunc;
    }

    public void setAssistFunc(boolean assistFunc) {
        this.assistFunc = assistFunc;
    }

    public String getFuncName() {
        return this.nameLabel.getText();
    }

    public ToolAction getAction() {
        return this.action;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getToolId() {
        return this.toolId;
    }

    public void setToolId(String toolId) {
        this.toolId = toolId;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.nameLabel.getText().hashCode();
        return result;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JTextArea getDescLabel() {
        return this.descLabel;
    }

    private static class FuncItemMouseAdapter
    extends MouseAdapter {
        private SettingItem item = null;

        public FuncItemMouseAdapter(SettingItem item) {
            this.item = item;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (null != this.item.action && !ApplicationContext.getInstance().checkOtherToolRunning()) {
                this.item.action.actionPerformed(null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.item.setCursor(new Cursor(12));
            this.item.setBorder(BorderFactory.createLineBorder(new Color(89, 192, 243)));
            this.item.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.item.setBorder(BorderFactory.createLineBorder(new Color(228, 228, 228)));
            this.item.repaint();
        }
    }
}

