/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.dialogs;

import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisclaimerDialog
extends PublicDialog {
    private static final Logger log = LoggerFactory.getLogger(DisclaimerDialog.class);
    private static final int MAIN_WIDTH = 734;
    private static final int MAIN_HEIGHT_EN = 440;
    private static final int MAIN_HEIGHT_ZH = 400;
    private JTextArea precautionInfoArea = UiMethod.createJTextArea("");
    private boolean isAccepted = false;
    private DisclaimerScene disclaimerScene;

    public DisclaimerDialog(Window parent, DisclaimerScene disclaimerScene) {
        super(parent);
        this.disclaimerScene = disclaimerScene;
        this.init();
    }

    public DisclaimerDialog(Window parent) {
        this(parent, DisclaimerScene.NORMAL);
    }

    private void init() {
        this.getOkBtn().setText(ResourceUtil.getString("disclaimer.dialog.okbutton.text"));
        UCD.formatMnemonicDisplay((AbstractButton)this.getOkBtn());
        this.adaptDialogSizeByLanguage();
        this.setTitle(ResourceUtil.getString("disclaimer.dialog.title"));
        this.setModal(true);
        this.precautionInfoArea.setText(this.getDisclaimerText());
        this.getContentPane().add((Component)UiMethod.buildFrameSpace(this.precautionInfoArea, 9), "Center");
        this.addListener();
        SwingUtil.putScreenCenter((Window)this);
    }

    private String getDisclaimerText() {
        String text = ResourceUtil.getString("disclaimer.dialog.main.text");
        if (DisclaimerScene.DEVICE_ADD.equals((Object)this.disclaimerScene)) {
            text = ResourceUtil.getString("disclaimer.dialog.deviceadd.text") + text;
        }
        return text;
    }

    private void adaptDialogSizeByLanguage() {
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            this.setSize(734, 440);
        } else {
            this.setSize(734, 400);
        }
    }

    private void addBtnListener() {
        this.getOkBtn().addActionListener(event -> this.clickOkButton());
        this.getCancelBtn().addActionListener(event -> this.clickCancelButton());
    }

    private void clickOkButton() {
        this.dispose();
        this.isAccepted = true;
    }

    private void clickCancelButton() {
        this.dispose();
        this.isAccepted = false;
    }

    private void addListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DisclaimerDialog.this.isAccepted = false;
            }
        });
        this.addBtnListener();
    }

    public boolean isAccepted() {
        return this.isAccepted;
    }

    public static enum DisclaimerScene {
        DEVICE_ADD,
        NORMAL;

    }
}

