/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolsUtils {
    private static final Logger log = LoggerFactory.getLogger(ToolsUtils.class);

    public static void writeParentPidToBackFlagFileOnLinux(FileChannel backFlagChannel) throws IOException {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return;
        }
        String pid = ApplicationContext.getInstance().getCurrentProcessPid();
        String parentPid = ToolsUtils.getParentPid(pid);
        log.info("pid: {}, parent pid: {}", (Object)pid, (Object)parentPid);
        byte[] bytes = parentPid.getBytes(StandardCharsets.UTF_8);
        backFlagChannel.write(ByteBuffer.wrap(bytes));
    }

    private static String getParentPid(String pid) throws IOException {
        Process proc = Runtime.getRuntime().exec("ps -o pid,ppid -p " + pid);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                log.info(line);
                if (!line.contains(pid)) continue;
                String string = line.trim().split("\\s+")[1];
                return string;
            }
        }
        return "";
    }

    private ToolsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

