/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.server;

import com.huawei.fit.broker.server.StartServer;
import com.huawei.fit.registry.entity.Address;
import com.huawei.fit.sdk.system.SetLocalAddresses;
import com.huawei.fit.sdk.system.SetRegistryMatchedAddress;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Order;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.serialization.SerializationService;
import com.huawei.fitframework.broker.server.BrokerServer;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Order(value=-500)
public class DefaultBrokerServer
implements BrokerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultBrokerServer.class);
    private final ProxyFactory proxyFactory;
    private final SerializationService serializationService;
    private final SetRegistryMatchedAddress setRegistryMatchedAddress;
    private final SetLocalAddresses setLocalAddresses;
    private final Map<Integer, Address> protocolAddressMapping = new ConcurrentHashMap<Integer, Address>();
    private final String defaultLocalAddr;
    private final String defaultWorkerId;
    private final String environment;
    private final int registryProtocol;
    private final List<Integer> registryFormats;

    public DefaultBrokerServer(ProxyFactory proxyFactory, SerializationService serializationService, SetRegistryMatchedAddress setRegistryMatchedAddress, SetLocalAddresses setLocalAddresses, @Value(value="${server.host}") String host, @Value(value="${server.id}") String workerId, @Value(value="${worker.environment}") String environment, @Value(value="${matata.registry.protocol}") Integer registryProtocol, @Value(value="${matata.registry.formats}") List<Integer> registryFormats) {
        this.proxyFactory = proxyFactory;
        this.serializationService = serializationService;
        this.setRegistryMatchedAddress = setRegistryMatchedAddress;
        this.setLocalAddresses = setLocalAddresses;
        this.defaultLocalAddr = Validation.notBlank((String)host, (String)"No local host.", (Object[])new Object[0]);
        log.info("Default local host is {}.", (Object)this.defaultLocalAddr);
        this.defaultWorkerId = Validation.notBlank((String)workerId, (String)"No worker id.", (Object[])new Object[0]);
        log.info("Worker id is {}.", (Object)this.defaultWorkerId);
        this.environment = Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
        log.info("Config worker.environment is {}.", (Object)this.environment);
        this.registryProtocol = (Integer)Validation.notNull((Object)registryProtocol, (String)"No registry protocol.", (Object[])new Object[0]);
        log.info("Registry protocol is {}.", (Object)this.registryProtocol);
        Validation.isTrue((boolean)CollectionUtils.isNotEmpty(registryFormats), (String)"No registry formats.", (Object[])new Object[0]);
        this.registryFormats = registryFormats;
        log.info("Registry formats are: {}.", this.registryFormats);
        log.info("Add broker server shutdown handler.");
    }

    public void startServers() {
        this.proxyFactory.listLocalFitableIds("9289a2a4322d47d38f33fc32c47f04d2").stream().filter(StringUtils::isNotBlank).forEach(this::startServer);
        this.setSystemAddresses();
    }

    private void setSystemAddresses() {
        Collection<Address> addresses = this.protocolAddressMapping.values();
        Boolean ret = this.setLocalAddresses.process(new ArrayList<Address>(addresses));
        if (ret.booleanValue()) {
            log.info("Set local addresses: {}.", addresses);
        } else {
            log.warn("Fail to set local addresses: {}.", addresses);
        }
    }

    private void startServer(String fitableId) {
        Object result = this.proxyFactory.getLocalProxy(StartServer.class, fitableId).execute(new Object[0]);
        if (result == null) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to start server: no address returned. [fitableId={0}]", (Object[])new Object[]{fitableId}));
        }
        Validation.isTrue((boolean)Address.class.isAssignableFrom(result.getClass()), () -> new IllegalStateException(StringUtils.format((String)"Fail to start server: class of returned address is incorrect. [fitableId={0}, class={1}]", (Object[])new Object[]{fitableId, result.getClass().getName()})));
        Address address = (Address)ObjectUtils.cast((Object)result);
        address.setHost(this.defaultLocalAddr);
        address.setId(this.defaultWorkerId);
        address.setFormats(new ArrayList(this.serializationService.listSupportedFormats()));
        address.setEnvironment(this.environment);
        this.protocolAddressMapping.put(address.getProtocol(), address);
        log.info("Worker[{}] start server[fitableId: {}] at {}:{} successfully.", new Object[]{this.defaultWorkerId, fitableId, this.defaultLocalAddr, address.getPort()});
        if (this.isMatchRegistry(address)) {
            this.setRegistryMatchedAddress(address);
        }
    }

    private boolean isMatchRegistry(Address address) {
        if (!Objects.equals(address.getProtocol(), this.registryProtocol)) {
            return false;
        }
        Set supportedFormats = CollectionUtils.intersect((Collection)address.getFormats(), this.registryFormats);
        return !CollectionUtils.isEmpty((Collection)supportedFormats);
    }

    private void setRegistryMatchedAddress(Address address) {
        Boolean setRet = this.setRegistryMatchedAddress.process(address);
        if (setRet.booleanValue()) {
            log.info("Set registry matched address: {}.", (Object)address);
        } else {
            log.warn("Fail to set registry matched address: {}.", (Object)address);
        }
    }
}

