/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.server;

import com.huawei.fit.sdk.context.ClearGlobalContext;
import com.huawei.fit.sdk.context.GetGlobalContext;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.Receiver;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.decorator.MeshInDecorator;
import com.huawei.fitframework.broker.client.proxy.support.decorator.TrustDecorator;
import com.huawei.fitframework.broker.serialization.MessageSerializer;
import com.huawei.fitframework.broker.serialization.RequestMetadata;
import com.huawei.fitframework.broker.serialization.ResponseMetadata;
import com.huawei.fitframework.broker.serialization.SerializationService;
import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.broker.serialization.support.DefaultTagLengthValues;
import com.huawei.fitframework.broker.server.entity.RawResponse;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.LazyLoader;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.DegradableException;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.SystemError;
import com.huawei.fitframework.tlv.TlvSerializer;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class FitReceiver
implements Receiver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitReceiver.class);
    private static final int CURRENT_METADATA_VERSION = 2;
    private static final int UNKNOWN_FORMAT = -1;
    private static final String FIT_MESH_SOURCE_WORKER_ID = "fit.mesh.sourceWorkerId";
    private final ProxyFactory factory;
    private final SerializationService serializationService;
    private final LazyLoader<List<TlvSerializer>> tlvSerializersLoader;
    private final GetGlobalContext getGlobalContext;
    private final ClearGlobalContext clearGlobalContext;
    private final TlvSerializer<Map<String, String>> tlvSerializer;
    private final String workerHost;

    public FitReceiver(@Fit ProxyFactory factory, @Fit SerializationService serializationService, @Fit GetGlobalContext getGlobalContext, @Fit ClearGlobalContext clearGlobalContext, @Fit(alias="fitExceptionTlvSerializer") TlvSerializer<Map<String, String>> tlvSerializer, @Value(value="${server.host}") String workerHost) {
        this.factory = (ProxyFactory)Validation.notNull((Object)factory, (String)"No proxy factory.", (Object[])new Object[0]);
        this.serializationService = (SerializationService)Validation.notNull((Object)serializationService, (String)"No serialization service.", (Object[])new Object[0]);
        this.tlvSerializersLoader = new LazyLoader(() -> factory.getBrokerClient().list(TlvSerializer.class).values().stream().map(TlvSerializer.class::cast).collect(Collectors.toList()));
        this.getGlobalContext = (GetGlobalContext)Validation.notNull((Object)getGlobalContext, (String)"No genericable: GetGlobalContext.", (Object[])new Object[0]);
        this.clearGlobalContext = (ClearGlobalContext)Validation.notNull((Object)clearGlobalContext, (String)"No genericable: ClearGlobalContext.", (Object[])new Object[0]);
        this.workerHost = Validation.notBlank((String)workerHost, (String)"No worker host.", (Object[])new Object[0]);
        this.tlvSerializer = tlvSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawResponse receive(byte[] requestMetadataBytes, byte[] requestBytes) {
        if (requestMetadataBytes == null || requestMetadataBytes.length <= 0) {
            log.error("Received request bytes, but no metadata bytes.");
            return new RawResponse(this.getResponseMetadata((Throwable)new FitException(SystemError.INVALID_REQUEST_METADATA_ERROR.getCode(), SystemError.INVALID_REQUEST_METADATA_ERROR.getMessage()), -1), new byte[0]);
        }
        RequestMetadata reqMetadata = RequestMetadata.deserialize((byte[])requestMetadataBytes);
        int format = Byte.toUnsignedInt(reqMetadata.getDataFormat());
        if (reqMetadata.getVersion() > 2) {
            log.error("Received request with higher version. [currentVersion=2, receivedVersion={}]", (Object)reqMetadata.getVersion());
            return new RawResponse(this.getResponseMetadata((Throwable)new FitException(SystemError.INVALID_REQUEST_VERSION_ERROR.getCode(), SystemError.INVALID_REQUEST_VERSION_ERROR.getMessage()), format), new byte[0]);
        }
        MessageSerializer serializer = this.serializationService.require(format);
        try {
            this.deserializeTlv(reqMetadata.getTagValues());
            Proxy proxy = this.getProxy(reqMetadata);
            Type[] argumentClasses = (Type[])proxy.getParameters().stream().map(Parameter::getParameterizedType).toArray(Type[]::new);
            Object[] arguments = serializer.deserializeRequest(argumentClasses, requestBytes);
            Object response = proxy.execute(arguments);
            byte[] dateBytes = serializer.serializeResponse(proxy.getReturnType(), response);
            log.debug("Execute fitable successfully. [genericableId={}, fitableId={}]", (Object)reqMetadata.getGenericId(), (Object)reqMetadata.getFitId());
            RawResponse rawResponse = new RawResponse(this.successfulResponseMetadataBytes(format), dateBytes);
            return rawResponse;
        }
        catch (Throwable t) {
            log.error("Fail to execute fitable. [genericableId={}, fitableId={}]", (Object)reqMetadata.getGenericId(), (Object)reqMetadata.getFitId());
            log.debug("Fail to execute fitable.", t);
            byte[] responseMetadata = this.getResponseMetadata(t, format);
            RawResponse rawResponse = new RawResponse(responseMetadata, new byte[0]);
            return rawResponse;
        }
        finally {
            log.debug("Prepare to clear global context.");
            Boolean isCleared = this.clearGlobalContext.process();
            log.debug("Clear global context: {}.", (Object)isCleared);
        }
    }

    private Proxy getProxy(RequestMetadata reqMetadata) {
        String sourceWorkerId = this.getGlobalContext.process(FIT_MESH_SOURCE_WORKER_ID);
        Proxy proxy = this.factory.getLocalProxy(reqMetadata.getGenericId(), reqMetadata.getFitId());
        return MeshInDecorator.decorate((Proxy)proxy, (String)sourceWorkerId, (String)this.workerHost).decoratedBy(TrustDecorator::decorate);
    }

    private void deserializeTlv(TagLengthValues tagLengthValues) {
        ((List)this.tlvSerializersLoader.get()).forEach(serializer -> serializer.deserialize(tagLengthValues));
    }

    private byte[] getResponseMetadata(Throwable throwable, int format) {
        byte[] responseMetadata;
        if (throwable instanceof MethodInvocationException) {
            Throwable cause = ExceptionUtils.getActualCause((MethodInvocationException)((MethodInvocationException)throwable));
            responseMetadata = this.handleException(cause, format);
        } else {
            responseMetadata = this.handleException(throwable, format);
        }
        return responseMetadata;
    }

    private byte[] handleException(Throwable cause, int format) {
        if (cause instanceof DegradableException) {
            DegradableException actualCause = (DegradableException)cause;
            return this.responseMetadataBytes(format, actualCause.getCode(), actualCause.getMessage(), true, null);
        }
        if (cause instanceof FitException) {
            FitException actualCause = (FitException)cause;
            TagLengthValues tagLengthValues = this.buildTagLengthValues(actualCause.getProperties());
            return this.responseMetadataBytes(format, actualCause.getCode(), actualCause.getMessage(), false, tagLengthValues);
        }
        return this.responseMetadataBytes(format, -1, cause.getMessage(), false, null);
    }

    private TagLengthValues buildTagLengthValues(Map<String, String> properties) {
        DefaultTagLengthValues tagLengthValues = new DefaultTagLengthValues();
        tagLengthValues.putTags(this.tlvSerializer.serialize(properties));
        return tagLengthValues;
    }

    private byte[] successfulResponseMetadataBytes(int format) {
        return this.responseMetadataBytes(format, 0, "", false, null);
    }

    private byte[] responseMetadataBytes(int format, int code, String message, boolean isDegradationException, TagLengthValues tagLengthValues) {
        return ResponseMetadata.builder().setVersion((short)2).setDataFormat(FitReceiver.valueFormat(format)).setCode(code).setMessage(message).setDegradationException(isDegradationException).setTagValues(tagLengthValues).build().serialize();
    }

    private static byte valueFormat(int format) {
        return (byte)(format & 0xFF);
    }
}

