/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.huawei.smartkit.drop.util.sensitive.SensitiveExclusionStrategy;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonUtils {
    private static final Gson GSON = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new SensitiveExclusionStrategy()).enableComplexMapKeySerialization().create();

    @Nullable
    public static <T> T toObject(String json, @NotNull Class<T> type) {
        return (T)GSON.fromJson(json, type);
    }

    @NotNull
    public static String toJson(Object object) {
        return GSON.toJson(object);
    }

    @Nullable
    public static <T> List<T> toList(String json, @NotNull Class<T> type) {
        return (List)GSON.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{type}).getType());
    }

    @Nullable
    public static <K, V> Map<K, V> toMap(String json, @NotNull Class<K> key, @NotNull Class<V> value) {
        return (Map)GSON.fromJson(json, TypeToken.getParameterized(Map.class, (Type[])new Type[]{key, value}).getType());
    }

    @Nullable
    public static <T> T toObject(String json, @NotNull Type type) {
        return (T)GSON.fromJson(json, type);
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

