/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.SystemEnvUtil;
import com.huawei.smartkit.drop.util.ThreadUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsCmdUtils {
    private static final Logger log = LoggerFactory.getLogger(OsCmdUtils.class);

    @NotNull
    public static String executeCmd(@NotNull String cmd) {
        return OsCmdUtils.executeCmd(cmd, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static String executeCmd(@NotNull String cmd, @Nullable Map<String, String> envs, @Nullable File dir) {
        Process proc;
        log.info("executeCmd: {}", (Object)cmd);
        try {
            ProcessBuilder processBuilder;
            ProcessBuilder processBuilder2 = processBuilder = SystemEnvUtil.isWindowsOs() ? new ProcessBuilder("cmd.exe", "/c", cmd) : new ProcessBuilder("sh", cmd);
            if (Objects.nonNull(envs)) {
                processBuilder.environment().putAll(envs);
            }
            proc = processBuilder.directory(dir).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            log.error("create cmd process failed", (Throwable)e);
            return "";
        }
        try {
            String string;
            Object object;
            InputStream ins;
            block20: {
                block21: {
                    ins = proc.getInputStream();
                    object = null;
                    Future<String> normalStr = ThreadUtils.submit(() -> OsCmdUtils.readProcessStream(ins));
                    int code = proc.waitFor();
                    log.info("executeCmd result code: {}", (Object)code);
                    String result = normalStr.get();
                    log.info("executeCmd result: {}", (Object)result);
                    string = result;
                    if (ins == null) break block20;
                    if (object == null) break block21;
                    try {
                        ins.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block20;
                }
                ins.close();
            }
            return string;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (ins != null) {
                            if (object != null) {
                                try {
                                    ins.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                ins.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    log.error("executeCmd error", (Throwable)e);
                    object = "";
                    return object;
                }
            }
        }
        finally {
            proc.destroy();
        }
    }

    private static String readProcessStream(InputStream is) {
        StringBuilder result = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            log.error("readline error", (Throwable)e);
        }
        return result.toString();
    }

    public static void exeCmdAsync(@NotNull String cmd, @Nullable Map<String, String> envs, @Nullable File dir) {
        ThreadUtils.submit(() -> OsCmdUtils.executeCmd(cmd, envs, dir));
    }

    private OsCmdUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

