/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public final class StringUtils {
    public static boolean isNotEmpty(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cs);
    }

    public static boolean isNoneEmpty(CharSequence ... css) {
        return org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])css);
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        return org.apache.commons.lang3.StringUtils.isAnyEmpty((CharSequence[])css);
    }

    public static String defaultString(String str) {
        return org.apache.commons.lang3.StringUtils.defaultString((String)str);
    }

    public static String defaultString(String str, String defaultStr) {
        return org.apache.commons.lang3.StringUtils.defaultString((String)str, (String)defaultStr);
    }

    public static String getCleanMessage(String message) {
        if (message == null) {
            return "";
        }
        String normalizeMessage = Normalizer.normalize(message, Normalizer.Form.NFKC);
        return normalizeMessage.replaceAll("[\r\n\f\b\u007f\u000b]", "");
    }

    public static String format(String text, Object ... params) {
        return String.format(Locale.ROOT, text, params);
    }

    public static String formatTime(String timeFormat) {
        return new SimpleDateFormat(timeFormat).format(new Date());
    }

    public static String formatCurrentTime() {
        return new SimpleDateFormat("yyyyMMddHHmmssSS").format(new Date());
    }

    public static boolean containIgnoreCase(String text, String ... childText) {
        String lowerText = text.toLowerCase(Locale.ROOT);
        return Arrays.stream(childText).map(String::toLowerCase).anyMatch(lowerText::contains);
    }

    public static String replaceNotEnChar(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return str.replaceAll("[^a-zA-Z]+", "");
    }

    public static String replacePwd(String cmd) {
        if (StringUtils.isEmpty(cmd)) {
            return cmd;
        }
        int index = cmd.indexOf("-pwd");
        if (index == -1) {
            return cmd;
        }
        String[] words = cmd.split(" ");
        return StringUtils.replacePwd(words);
    }

    private static String replacePwd(String[] words) {
        StringBuilder newCmd = new StringBuilder();
        boolean isPwd = false;
        int length = words.length;
        for (int i = 0; i < length; ++i) {
            String word = words[i];
            if (!isPwd) {
                newCmd.append(word);
            } else {
                newCmd.append("********");
                isPwd = false;
            }
            if (i < length - 1) {
                newCmd.append(' ');
            }
            if (!"-pwd".equals(word)) continue;
            isPwd = true;
        }
        return newCmd.toString();
    }

    public static String safetyGetStr(String[] arr, int index) {
        if (arr.length > index) {
            return arr[index].trim();
        }
        return "";
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

