/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ScheduledExecutorService THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("smartkit-drop-util-%d").uncaughtExceptionHandler((thread, exception) -> log.error("thread {} uncaught exception", (Object)thread.getName(), (Object)exception)).daemon(true).build(), new ThreadPoolExecutor.AbortPolicy());
    private static final int POOL_SIZE_CORE_NUM = 10;

    public static <T> Future<T> submit(Callable<T> task) {
        return THREAD_POOL_EXECUTOR.submit(task);
    }

    public static void threadSafeSleep(int sleepTime, TimeUnit timeUnit) {
        long millis = timeUnit.toMillis(sleepTime);
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException exception) {
            log.error("thread {} sleep error", (Object)Thread.currentThread().getName(), (Object)exception);
        }
    }

    private ThreadUtils() {
    }
}

