/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util;

import com.huawei.smartkit.drop.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    public static String encode(String str) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException exception) {
            log.error("encode url:{} error", (Object)str);
            return str;
        }
    }

    public static String decode(String str) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error("decode url:{} error", (Object)str);
            return str;
        }
    }

    private UrlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

