/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util.file;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;

public final class FileUtils {
    private static final double SIZE_UNIT = 1024.0;
    private static final int SIZE_UNIT_COUNT = 3;
    private static final String GB = "GB";
    private static final String MB = "MB";
    private static final String KB = "KB";
    private static final String BYTE = "Byte";

    public static String getManFriendlySize(long fileSize) {
        double tmpSize;
        int count = 0;
        for (tmpSize = (double)fileSize; tmpSize >= 1024.0 && count < 3; tmpSize /= 1024.0, ++count) {
        }
        return FileUtils.formatUnit(count, tmpSize, FileUtils.selectUnit(count));
    }

    @NotNull
    private static String formatUnit(int count, double tmpSize, String unit) {
        DecimalFormat df = new DecimalFormat("#");
        if (count == 3) {
            df = new DecimalFormat("#.#");
        }
        return df.format(tmpSize) + unit;
    }

    private static String selectUnit(int count) {
        String toolUnit;
        if (count >= 3) {
            return GB;
        }
        switch (count) {
            case 1: {
                toolUnit = KB;
                break;
            }
            case 2: {
                toolUnit = MB;
                break;
            }
            default: {
                toolUnit = BYTE;
            }
        }
        return toolUnit;
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

