/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.license.License;
import com.huawei.ism.util.NetUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DeviceContext
implements Serializable {
    private static final long serialVersionUID = -4379936217361480924L;
    private String deviceAddress = "--";
    private String status = "--";
    private transient List<String> ips = new ArrayList<String>(0);
    private String preferedIP;
    private String useSSL = String.valueOf(1);
    private User currentUser = null;
    private String deviceID;
    private String currentConnIP = null;
    private ProtocalType socketType = ProtocalType.HTTP;
    private String deviceName;
    private DeviceType deviceType = null;
    private String productVersion = null;
    private ProductModelType productModelType = ProductModelType.UNKNOW;
    private License license = null;
    private DeviceContext parentDeviceContext = null;
    private String deviceRunningState;

    public DeviceContext(String user, String password, String[] ips) {
        this.currentUser = new User(user, password);
        this.initIPAdress(ips);
    }

    public DeviceContext(String user, String password, String[] ips, User.USER_SCOPE userScope) {
        this.currentUser = new User(user, password, userScope);
        this.initIPAdress(ips);
    }

    public DeviceContext(User user, String[] ips) {
        this.currentUser = user;
        this.initIPAdress(ips);
    }

    private void initIPAdress(String[] ipValues) {
        if (ipValues.length > 0) {
            this.preferedIP = ipValues[0];
        }
        this.ips.addAll(Arrays.asList(ipValues));
    }

    public ProductModelType getDeviceModelType() {
        return this.productModelType;
    }

    public void setDeviceModelType(ProductModelType productModelTypeValue) {
        this.productModelType = productModelTypeValue;
    }

    public ProtocalType getProtocalType() {
        return this.socketType;
    }

    public void setProtocalType(ProtocalType type) {
        this.socketType = type;
    }

    public void setConnectionIP(String ip) {
        this.currentConnIP = ip;
    }

    public String getConnectionIP() {
        return NetUtil.isCommandIPV6Addr(this.currentConnIP) ? NetUtil.getNormalIPV6Addr(this.currentConnIP) : this.currentConnIP;
    }

    public String getOtherIP() {
        if (null == this.ips) {
            return null;
        }
        for (String ip : this.ips) {
            if (this.preferedIP.equals(ip)) continue;
            return ip;
        }
        return null;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String[] getIPList() {
        ArrayList<String> ipValues = new ArrayList<String>(this.ips);
        if (!ipValues.contains(this.preferedIP)) {
            ipValues.add(this.preferedIP);
        }
        return ipValues.toArray(new String[ipValues.size()]);
    }

    public String getPreferedIP() {
        return NetUtil.isCommandIPV6Addr(this.preferedIP) ? NetUtil.getNormalIPV6Addr(this.preferedIP) : this.preferedIP;
    }

    public void setDeviceID(String arrayId) {
        this.deviceID = arrayId;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    public String getDeviceAddress() {
        if (null == this.deviceAddress) {
            return "--";
        }
        return this.deviceAddress;
    }

    public void setDeviceAddress(String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public String getDeviceStatus() {
        return this.status;
    }

    public void setDeviceStatus(String statusValue) {
        this.status = statusValue;
    }

    public void setPreferedIP(String preferedIP) {
        this.preferedIP = preferedIP;
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public String getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(String useSSL) {
        this.useSSL = useSSL;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public License getLicense() {
        return this.license;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceContext)) {
            return false;
        }
        DeviceContext da = (DeviceContext)obj;
        return da.deviceID.equals(this.deviceID);
    }

    public int hashCode() {
        int result = 29;
        result = this.deviceID == null ? result * 37 + 0 : result * 37 + this.deviceID.hashCode();
        return result;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("preferedIP", (Object)this.preferedIP).append("deviceID", (Object)this.deviceID).append("_ips", this.ips).append("_socketType", (Object)this.socketType).toString();
    }

    public void setParentDeviceContext(DeviceContext deviceContext) {
        this.parentDeviceContext = deviceContext;
    }

    public DeviceContext getParentDeviceContext() {
        return this.parentDeviceContext;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public String getDeviceRunningState() {
        return this.deviceRunningState;
    }

    public void setDeviceRunningState(String deviceRunningState) {
        this.deviceRunningState = deviceRunningState;
    }

    public static enum ProtocalType {
        HTTPS(0),
        HTTP(1);

        private int value;

        private ProtocalType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ProtocalType valueOf(int value) {
            for (ProtocalType type : ProtocalType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }
}

