/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.connection.IConnection;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.service.CommonWorkTaker;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;

public class ConnectionMonitor
implements IConnection.StateChangeListener {
    private IConnection conn;
    private IConnection.ConnectionState lastState = null;

    public ConnectionMonitor(IConnection conn) {
        this.conn = conn;
    }

    @Override
    public synchronized void stateChanged(IConnection.ConnectionState state) {
        MO mo;
        String deviceID = this.conn.getDeviceID();
        if (null == deviceID) {
            return;
        }
        if (this.lastState == state) {
            return;
        }
        this.lastState = state;
        if (IConnection.ConnectionState.Disconnected == state && (mo = CommonWorkTaker.getInstance().getDeviceMO(deviceID)) != null) {
            mo.setProperty(TLV.SYSTEM.RUNNINGSTATUS, EnumDefine.RUNNING_STATUS_E.OFFLINE.getValue());
        }
        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_COMPONENT_CHANGE");
        msg.setProperty("DEVICE_ID", deviceID);
        msg.setProperty("ConnectionState", (Object)state);
        IsmMsgManager.getInstance().postSyncMsg(msg);
    }
}

