/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.message;

import com.huawei.ism.message.IMsgCallback;
import com.huawei.ism.message.IMsgHandler;
import com.huawei.ism.message.IsmMsg;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsmMsgManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmMsgManager.class);
    private static IsmMsgManager instance = null;
    private static Map<String, List<IMsgHandler>> msgHandlers = new Hashtable<String, List<IMsgHandler>>(0);
    private static Map<String, ExecutorService> msgExecutors = new Hashtable<String, ExecutorService>(0);
    private long msgIDSeed = 0L;
    private ExecutorService defaultExecutor = Executors.newCachedThreadPool();
    private final Object LOCK = new Object();

    private IsmMsgManager() {
    }

    public static synchronized IsmMsgManager getInstance() {
        if (null == instance) {
            instance = new IsmMsgManager();
        }
        return instance;
    }

    public synchronized IsmMsg buildMsg(String msgType) {
        this.commonParamCheck(msgType);
        return new IsmMsg(this.generateID(), msgType);
    }

    public static Map<String, List<IMsgHandler>> getMsgHandlers() {
        return msgHandlers;
    }

    public synchronized void registerAsyncMsgExecutor(String msgType, ExecutorService executor) {
        this.commonParamCheck(msgType);
        if (executor != null) {
            msgExecutors.put(msgType, executor);
        }
    }

    public synchronized void registerIsmMsgHandle(String msgType, IMsgHandler handler) {
        this.commonParamCheck(msgType);
        List<IMsgHandler> handlers = msgHandlers.get(msgType);
        if (null == handlers) {
            handlers = new ArrayList<IMsgHandler>(0);
            msgHandlers.put(msgType, handlers);
        }
        handlers.add(handler);
    }

    public synchronized void removeIsmMsgHandle(String msgType, IMsgHandler handler) {
        this.commonParamCheck(msgType);
        List<IMsgHandler> handlers = msgHandlers.get(msgType);
        if (null != handlers) {
            handlers.remove(handler);
        }
    }

    public void postSyncMsg(IsmMsg msg) {
        this.commonParamCheck(msg);
        List<IMsgHandler> handlers = msgHandlers.get(msg.getMsgType());
        if (null != handlers) {
            for (IMsgHandler msgHandler : handlers) {
                try {
                    msgHandler.handleMsg(msg);
                }
                catch (Exception e) {
                    LOGGER.error("An exception occured when excuteing message handle", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAsyncMsg(final IsmMsg msg, final IMsgCallback msgCallback) {
        this.commonParamCheck(msg);
        final String msgType = msg.getMsgType();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String threadName = Thread.currentThread().getName();
                List handlers = (List)msgHandlers.get(msgType);
                try {
                    Thread.currentThread().setName("AsyncMsg=" + msg.getMsgType());
                    if (null == handlers) {
                        return;
                    }
                    msg.setHandleStatus("handling");
                    for (IMsgHandler msgHandler : handlers) {
                        IsmMsgManager.this.handleMsgWithoutException(msgHandler, msg);
                    }
                    msgCallback.processMsgEnd(msg);
                }
                catch (Exception e) {
                    LOGGER.error("An exception occured when excuteing message handle", (Throwable)e);
                }
                finally {
                    Thread.currentThread().setName(threadName);
                    msg.setHandleStatus("end handle");
                }
            }
        };
        ExecutorService es = null;
        Object object = this.LOCK;
        synchronized (object) {
            es = msgExecutors.get(msgType);
        }
        if (es == null) {
            es = this.defaultExecutor;
        }
        LOGGER.error("task submitted: " + es.submit(task));
    }

    private void handleMsgWithoutException(IMsgHandler msgHandler, IsmMsg msg) {
        try {
            msgHandler.handleMsg(msg);
        }
        catch (Exception e) {
            LOGGER.error("An exception occured when excuteing message handle", (Throwable)e);
            msg.setProperty("PROPERTY_EXCEPTION", e);
        }
    }

    public void postAsyncMsg(IsmMsg msg) {
        this.commonParamCheck(msg);
        this.postAsyncMsg(msg, new IsmMesageCallback());
    }

    private void commonParamCheck(IsmMsg msg) {
        if (null == msg) {
            throw new NullPointerException("msg can not be null");
        }
        if (null == msg.getMsgType()) {
            throw new NullPointerException("message type can not be null");
        }
        if (msg.getMsgType().trim().equals("")) {
            throw new IllegalArgumentException("message type can not be empty string");
        }
    }

    private void commonParamCheck(String msgType) {
        if (null == msgType) {
            throw new NullPointerException("message type can not be null");
        }
        if (msgType.trim().equals("")) {
            throw new IllegalArgumentException("message type can not be empty string");
        }
    }

    private synchronized long generateID() {
        this.msgIDSeed = this.msgIDSeed == Long.MAX_VALUE ? 0L : ++this.msgIDSeed;
        return this.msgIDSeed;
    }

    private static final class IsmMesageCallback
    implements IMsgCallback {
        private IsmMesageCallback() {
        }

        @Override
        public void processMsgEnd(IsmMsg msg) {
        }
    }
}

