/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.model;

import com.huawei.ism.model.Associator;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.util.SerialSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MOFilter {
    private SerialSet<MO> mos = null;

    public MOFilter(List<MO> mos) {
        this.mos = new SerialSet<MO>(mos);
    }

    public MOFilter(Set<MO> mos) {
        this.mos = new SerialSet<MO>(mos);
    }

    public MO parentOf(MO child) {
        for (MO mo : this.mos) {
            if (!mo.getUUID().equals(child.getParentUUID())) continue;
            return mo;
        }
        return null;
    }

    public MO withUUID(UUID uuid) {
        for (MO mo : this.mos) {
            if (!mo.getUUID().equals(uuid)) continue;
            return mo;
        }
        return null;
    }

    public MOFilter type(MOType ... moTypes) {
        MO mo = null;
        Iterator<MO> iterator = this.mos.iterator();
        while (iterator.hasNext()) {
            mo = iterator.next();
            boolean needRemove = true;
            for (MOType moType : moTypes) {
                if (mo.getMOTypeValue() != moType.getValue()) continue;
                needRemove = false;
            }
            if (!needRemove) continue;
            iterator.remove();
        }
        return this;
    }

    public MOFilter type(int ... moTypes) {
        Iterator<MO> iterator = this.mos.iterator();
        while (iterator.hasNext()) {
            MO mo = iterator.next();
            boolean needRemove = true;
            for (int moType : moTypes) {
                if (mo.getMOTypeValue() != moType) continue;
                needRemove = false;
            }
            if (!needRemove) continue;
            iterator.remove();
        }
        return this;
    }

    public MOFilter childrenOf(UUID parentUUID) {
        MO mo = null;
        MOType parentType = null;
        UUID myParentUUID = null;
        Iterator<MO> iterator = this.mos.iterator();
        while (iterator.hasNext()) {
            try {
                mo = iterator.next();
                parentType = MOType.getType(Integer.valueOf(mo.getProperty(TLVMOMsg.PARENTTYPE).toString()));
                myParentUUID = new UUID(mo.getDeviceID(), parentType, mo.getProperty(TLVMOMsg.PARENTID).toString());
                if (null == parentUUID) {
                    iterator.remove();
                    continue;
                }
                if (parentUUID.equals(myParentUUID)) continue;
                iterator.remove();
            }
            catch (RuntimeException e) {
                iterator.remove();
            }
            catch (Exception e) {
                iterator.remove();
            }
        }
        return this;
    }

    public MOFilter referTo(UUID ... uuids) {
        MO mo = null;
        Associator associator = null;
        boolean needRemove = false;
        Iterator<MO> iterator = this.mos.iterator();
        while (iterator.hasNext()) {
            mo = iterator.next();
            if (!(mo instanceof Associator)) {
                iterator.remove();
                continue;
            }
            associator = (Associator)mo;
            needRemove = true;
            for (UUID uuid2 : uuids) {
                if (!associator.isAssociateTo(uuid2)) continue;
                needRemove = false;
            }
            if (!needRemove) continue;
            iterator.remove();
        }
        return this;
    }

    public MOFilter associateTo(UUID uuid, MOType associatorType) {
        return this.associateTo(uuid, associatorType.getValue());
    }

    public MOFilter associateTo(UUID uuid, int associatorType) {
        LinkedList<UUID> resultUUIDList = new LinkedList<UUID>();
        Associator associator = null;
        MO mo = null;
        for (MO element : this.mos) {
            mo = element;
            if (!(mo instanceof Associator) || (associator = (Associator)mo).getAssociateType() != associatorType || !associator.isAssociateTo(uuid)) continue;
            resultUUIDList.add(associator.getAnotherUUID(uuid));
        }
        Iterator<MO> iterator = this.mos.iterator();
        while (iterator.hasNext()) {
            mo = iterator.next();
            if (resultUUIDList.contains(mo.getUUID())) continue;
            iterator.remove();
        }
        return this;
    }

    public List<MO> result() {
        return new ArrayList<MO>(this.mos);
    }
}

