/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.notification;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.notification.ChangeInfo;
import com.huawei.ism.notification.INotificationHandler;
import com.huawei.ism.service.Datacache;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLVChangeHandler
implements INotificationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLVChangeHandler.class);
    private static final long NOTI_REFRESH_ALARM = 123456789L;
    private String deviceID = null;

    public TLVChangeHandler(String deviceID) {
        this.deviceID = deviceID;
    }

    @Override
    public void notificationOccured(Object obj) {
        if (!(obj instanceof DataPackage)) {
            return;
        }
        DataPackage dataPackage = (DataPackage)obj;
        List<Record> records = dataPackage.getRecordset();
        long opCode = 0L;
        for (Record record : records) {
            opCode = record.getMsgCode();
            if (opCode == 55847747647L) {
                this.processAlarm(record);
                continue;
            }
            if (opCode == 55847747637L) {
                this.processComponentChanged(record);
                continue;
            }
            if (opCode == 55847747636L) {
                this.processComponentCreated(record);
                continue;
            }
            if (opCode == 55847747638L) {
                this.processComponentDeleted(record);
                continue;
            }
            if (opCode != 123456789L) continue;
            this.processRefreshAlarm();
        }
    }

    private void processRefreshAlarm() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The detail of the received notification is [123456789].");
        }
        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_COMPONENT_CHANGE");
        msg.setProperty("ConnectionState", (Object)IConnection.ConnectionState.Connected);
        IsmMsgManager.getInstance().postSyncMsg(msg);
    }

    private void processAlarm(Record record) {
        Event event = TLVUtils.record2Event(this.deviceID, record);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The detail of the received notification is [type: alarm, event: " + event + ']');
        }
        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_EVENT_RECEIVE");
        msg.setProperty("PROPERTY_EVENT", event);
        IsmMsgManager.getInstance().postSyncMsg(msg);
    }

    private void processComponentChanged(Record record) {
        IsmInteger typeValue = record.getParamIntValue(0);
        if (MOType.SYSTEMLICENSE.getValue() == typeValue.intValue()) {
            this.processLicenseChanged();
            return;
        }
        String idValue = record.getParamStrValue(1);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The detail of the received notification is [operation: change, objectType: " + typeValue.intValue() + ']');
        }
        UUID uuid = new UUID(this.deviceID, typeValue.intValue(), idValue);
        this.sendMsg(new ChangeInfo(this.deviceID, uuid));
    }

    private void processLicenseChanged() {
        LOGGER.info("The detail of the received notification is [type: License]");
        Datacache.getInstance().setLicenseDirtyTag(this.deviceID);
    }

    private void processComponentCreated(Record record) {
        String idValue = record.getParamStrValue(1);
        IsmInteger typeValue = record.getParamIntValue(0);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The detail of the received notification is [operation: create, objectType: " + typeValue.intValue() + ']');
        }
        if (typeValue.intValue() == MOType.LUN.getValue() || typeValue.intValue() == MOType.SNAPSHOT.getValue()) {
            UUID uuid = new UUID(this.deviceID, typeValue.intValue(), idValue);
            this.sendMsg(new ChangeInfo(this.deviceID, uuid));
        } else {
            this.sendMsg(new ChangeInfo(this.deviceID, typeValue.intValue()));
        }
    }

    private void processComponentDeleted(Record record) {
        IsmInteger typeValue = record.getParamIntValue(0);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The detail of the received notification is [operation: delete, objectType: " + typeValue.intValue() + ']');
        }
        this.sendMsg(new ChangeInfo(this.deviceID, typeValue.intValue()));
    }

    private void sendMsg(ChangeInfo info) {
        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_COMPONENT_CHANGE");
        msg.setProperty("PROPERTY_CHANGEINFO", info);
        IsmMsgManager.getInstance().postSyncMsg(msg);
    }
}

