/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.notification;

import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.SocketPool;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.notification.HandshakeThread;
import com.huawei.ism.notification.INotificationHandler;
import com.huawei.ism.notification.IRefreshHandler;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.util.ByteUtil;
import com.huawei.ism.util.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TLVNotificationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLVNotificationManager.class);
    private static final int MSG_HEAD_LENGTH = 28;
    private static final int MSG_STATE_LENGTH = 4;
    private static final int CONN_TM = 3000;
    private static TLVNotificationManager instance;
    private Map<String, ProcessorThread> processorThreadMap = new HashMap<String, ProcessorThread>(0);
    private HandshakeThread handshakeThread = new HandshakeThread();

    private TLVNotificationManager() {
        this.handshakeThread.setName("Notification connection handshake thread");
        this.handshakeThread.start();
    }

    public static synchronized TLVNotificationManager getInstance() {
        if (null == instance) {
            instance = new TLVNotificationManager();
        }
        return instance;
    }

    public void setHandshakeMsg(DataPackage dataPackage) {
        this.handshakeThread.setHandshakeMsg(dataPackage);
    }

    public void registerNotificationHandler(String connectionID, INotificationHandler handler) {
        ProcessorThread processorThread = this.processorThreadMap.get(connectionID);
        if (null == processorThread) {
            processorThread = new ProcessorThread(connectionID, handler);
            this.processorThreadMap.put(connectionID, processorThread);
            processorThread.start();
        } else {
            processorThread.setHandler(handler);
        }
    }

    public void registerRefreshHandler(String connectionID, IRefreshHandler handler) {
        ProcessorThread processorThread = this.processorThreadMap.get(connectionID);
        if (null == processorThread) {
            processorThread = new ProcessorThread(connectionID, null);
            this.processorThreadMap.put(connectionID, processorThread);
            processorThread.start();
        } else {
            processorThread.setRefreshHandler(handler);
        }
    }

    public void stopNotificationProcessing(String connectionID) {
        if (!this.processorThreadMap.containsKey(connectionID)) {
            return;
        }
        ProcessorThread processorThread = this.processorThreadMap.get(connectionID);
        processorThread.setRunning(false);
        processorThread.interrupt();
        LOGGER.info("stop to receive notification.");
        this.processorThreadMap.remove(connectionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket buildNotificationSocket(String deviceID) throws IOException {
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceID);
        if (connection == null) {
            return null;
        }
        int connectType = connection.getProtocalType();
        ArrayList<String> ips = new ArrayList<String>(0);
        Socket tmps = null;
        try {
            tmps = connection.getSocket();
            ips.add(((InetSocketAddress)tmps.getRemoteSocketAddress()).getAddress().getHostAddress());
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
        finally {
            this.closeSocketCon(connection, tmps);
        }
        ips.add(connection.getURL());
        SocketPool pool = ConnectionManager.getInstance().getSocketPoolByDeviceID(deviceID);
        if (pool != null) {
            ips.addAll(pool.getAllIP());
        }
        Socket socket = null;
        for (String ip : ips) {
            try {
                int port = connection.getPort();
                socket = NetUtil.connect(ip, port, connectType, null, 3000);
                if (null == socket) {
                    LOGGER.error("socket connect failed." + ip + ":" + port);
                    continue;
                }
                socket.setReceiveBufferSize(0x100000);
                socket.setKeepAlive(true);
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("create notification conn success:" + ip + ":" + port);
                break;
            }
            catch (RuntimeException e) {
                LOGGER.error("", (Throwable)e);
                this.closeSocketCon(connection, socket);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                this.closeSocketCon(connection, socket);
            }
        }
        return socket;
    }

    private void closeSocketCon(TLVConnection connection, Socket tmps) {
        try {
            connection.releaseSocket(tmps);
        }
        catch (Exception e2) {
            LOGGER.error("", (Throwable)e2);
        }
    }

    private void sendStartNofifyCommand(Socket socket, String sessionKey) {
        try {
            DataPackage dp = TLVUtils.param2DP(55847747634L, sessionKey, TLVUtils.paramList(new Param[0]));
            socket.getOutputStream().write(dp.toByteArray());
            socket.getOutputStream().flush();
            this.readDataPackage(socket);
        }
        catch (IOException e) {
            LOGGER.error("executing start_notify command fail.", (Throwable)e);
            throw new IsmException(1073949185L, (Throwable)e);
        }
    }

    private DataPackage readDataPackage(Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        byte[] receiveMessageHead = new byte[28];
        this.fillBuffer(receiveMessageHead, inputStream);
        byte[] tmp4Byte = new byte[4];
        System.arraycopy(receiveMessageHead, 8, tmp4Byte, 0, 4);
        System.arraycopy(receiveMessageHead, 24, tmp4Byte, 0, 4);
        int messagesBodyLength = ByteUtil.bytes2int(tmp4Byte, false);
        byte[] receiveMessageBody = new byte[messagesBodyLength];
        this.fillBuffer(receiveMessageBody, inputStream);
        byte[] message = new byte[28 + messagesBodyLength];
        System.arraycopy(receiveMessageHead, 0, message, 0, 28);
        System.arraycopy(receiveMessageBody, 0, message, 28, receiveMessageBody.length);
        DataPackage receivedData = TLVUtils.decode(message);
        return receivedData;
    }

    private void fillBuffer(byte[] dataBuffer, InputStream inputStream) throws IOException {
        int totalReadBytes = 0;
        int onceReadBytes = 0;
        while (totalReadBytes < dataBuffer.length) {
            onceReadBytes = inputStream.read(dataBuffer, totalReadBytes, dataBuffer.length - totalReadBytes);
            if (onceReadBytes > -1) {
                totalReadBytes += onceReadBytes;
            }
            if (onceReadBytes != -1) continue;
            throw new IOException("socket closed");
        }
    }

    private class ProcessorThread
    extends Thread {
        private static final int RECOVER_DURATION = 30000;
        private boolean isRunning = true;
        private String connectionID;
        private INotificationHandler handler;
        private IRefreshHandler refreshhandler = null;

        public ProcessorThread(String connectionID, INotificationHandler handler) {
            this.connectionID = connectionID;
            this.handler = handler;
            this.refreshhandler = null;
        }

        public void setRefreshHandler(IRefreshHandler refHandler) {
            this.refreshhandler = refHandler;
        }

        public void setHandler(INotificationHandler handle) {
            this.handler = handle;
        }

        public void setRunning(boolean isRunningValue) {
            this.isRunning = isRunningValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            Socket socket = null;
            TLVConnection connection = null;
            boolean reConnected = false;
            while (this.isRunning && !Thread.interrupted()) {
                try {
                    connection = (TLVConnection)ConnectionManager.getInstance().getConnection(this.connectionID);
                    socket = TLVNotificationManager.this.buildNotificationSocket(this.connectionID);
                    if (socket == null) {
                        Thread.sleep(30000L);
                        this.closeSocket(socket);
                        continue;
                    }
                    TLVNotificationManager.this.sendStartNofifyCommand(socket, connection.getSessionKey());
                    LOGGER.info("start to receive notification.");
                    TLVNotificationManager.this.handshakeThread.addTask(socket, connection.getSessionKey());
                    if (reConnected) {
                        this.processRefresh();
                    }
                    this.processReceivingDataPackage(socket);
                    reConnected = true;
                    this.closeSocket(socket);
                }
                catch (RuntimeException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (Exception e2) {
                    LOGGER.error("", (Throwable)e2);
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.closeSocket(socket);
                }
            }
        }

        private void closeSocket(Socket socket) {
            if (socket == null || socket.isClosed()) {
                return;
            }
            try {
                LOGGER.error("close noti socket " + socket.getLocalSocketAddress() + "/" + socket.getRemoteSocketAddress());
                socket.close();
            }
            catch (IOException e) {
                LOGGER.error("close socket for notification fail.", (Throwable)e);
            }
        }

        private void processRefresh() {
            if (null != this.refreshhandler) {
                this.refreshhandler.notificationRefresh(this.connectionID);
            }
        }

        private void processReceivingDataPackage(Socket socket) {
            DataPackage receivedData = null;
            while (this.isRunning && !Thread.interrupted()) {
                try {
                    receivedData = TLVNotificationManager.this.readDataPackage(socket);
                }
                catch (IsmException e) {
                    LOGGER.warn("processReceivingDataPackage exception,maybe handshake return errorcode" + e.getErrorId());
                    continue;
                }
                catch (Exception e) {
                    TLVNotificationManager.this.handshakeThread.removeTask(socket);
                    LOGGER.error("processReceivingDataPackage", (Throwable)e);
                    break;
                }
                if ((receivedData.getHead().getSerial() & 0x8000) == 0 || this.handler == null) continue;
                try {
                    this.handler.notificationOccured(receivedData);
                }
                catch (Exception e) {
                    LOGGER.error("process notification exception", (Throwable)e);
                }
            }
        }
    }
}

