/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.service;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.UUID;
import com.huawei.ism.service.Datacache;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.SerialSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MOsCache {
    public static final String MO_NEW_CREATE = "MO_NEW_CREATE";
    private static final String MO_DIRTY_TAG = "MO_DIRTY_TAG";
    private static final String LAST_MODIFY_TIME = "LAST_MODIFY_TIME";
    private Map<Integer, SerialSet<MO>> componentMap = new ConcurrentHashMap<Integer, SerialSet<MO>>();
    private int dirtyMOThreshold = 10;
    private Map<Integer, Long> mosModifyTimeMap = new ConcurrentHashMap<Integer, Long>();

    public MOsCache(String deviceID) {
        Assert.notNull(deviceID);
    }

    synchronized void setDirtyTag(UUID uuid) {
        SerialSet<MO> mos = this.componentMap.get(uuid.getMOTypeValue());
        if (null != mos) {
            MO tmpMO = new MO(uuid);
            int index = mos.indexOf(tmpMO);
            MO mo = null;
            if (index > -1) {
                mo = mos.get(index);
                mo.setProperty(MO_DIRTY_TAG, true);
            } else {
                tmpMO.setProperty(MO_NEW_CREATE, true);
                tmpMO.setProperty(MO_DIRTY_TAG, true);
                mos.add(tmpMO);
            }
        }
    }

    synchronized void setDirtyTag(int moType) {
        this.mosModifyTimeMap.put(moType, System.currentTimeMillis() - Datacache.REFRESH_INTERVAL);
    }

    synchronized void setDirtyTag() {
        for (Integer moType : this.mosModifyTimeMap.keySet()) {
            this.mosModifyTimeMap.put(moType, System.currentTimeMillis() - Datacache.REFRESH_INTERVAL);
        }
    }

    synchronized Datacache.OperationResult getMO(UUID uuid) {
        SerialSet<MO> mos = this.componentMap.get(uuid.getMOTypeValue());
        if (mos == null) {
            return null;
        }
        MO tmpMO = new MO(uuid);
        int index = mos.indexOf(tmpMO);
        MO mo = null;
        if (index <= -1) {
            return new Datacache.OperationResult(Datacache.ResultDescription.NEED_SYNC, Collections.EMPTY_LIST, null);
        }
        mo = mos.get(index);
        long moModifyTime = System.currentTimeMillis();
        if (mo.getProperty(LAST_MODIFY_TIME) != null) {
            moModifyTime = mo.getLongProperty(LAST_MODIFY_TIME);
        } else {
            Long typeModifyTime = this.mosModifyTimeMap.get(uuid.getMOTypeValue());
            if (typeModifyTime != null) {
                moModifyTime = typeModifyTime;
            }
        }
        if (mo.getBoolProperty(MO_DIRTY_TAG).booleanValue() || System.currentTimeMillis() - moModifyTime > Datacache.REFRESH_INTERVAL) {
            return new Datacache.OperationResult(Datacache.ResultDescription.NEED_SYNC, Collections.EMPTY_LIST, mo);
        }
        return new Datacache.OperationResult(Datacache.ResultDescription.DATA_NULL, Collections.EMPTY_LIST, mo);
    }

    public synchronized MO getAMO(UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException();
        }
        SerialSet<MO> mos = this.componentMap.get(uuid.getMOTypeValue());
        MO tmpMO = new MO(uuid);
        int index = mos.indexOf(tmpMO);
        MO mo = null;
        if (index > -1) {
            mo = mos.get(index);
        }
        return mo;
    }

    public synchronized MO getParent(UUID uuid) {
        MO mo = this.getAMO(uuid);
        if (null == mo) {
            throw new NullPointerException();
        }
        UUID parentUUID = mo.getParentUUID();
        return this.getAMO(parentUUID);
    }

    public synchronized List<MO> getChildren(UUID uuid, int moType) {
        ArrayList<MO> result = new ArrayList<MO>(0);
        List<MO> mos = this.getMOs(moType);
        for (MO mo : mos) {
            if (!Optional.ofNullable(mo).map(MO::getParentUUID).map(moUuid -> moUuid.equals(uuid)).orElse(false).booleanValue()) continue;
            result.add(mo);
        }
        return result;
    }

    public synchronized List<MO> getMOs(int moType) {
        SerialSet<MO> serialSet = this.componentMap.get(moType);
        if (serialSet == null) {
            return new ArrayList<MO>(0);
        }
        return serialSet.toList(new MO[serialSet.size()]);
    }

    public synchronized Map<UUID, MO> getMOsInMap(int moType) {
        Set mos = this.componentMap.get(moType);
        HashMap<UUID, MO> mosMap = new HashMap<UUID, MO>(0);
        for (MO mo : mos) {
            mosMap.put(mo.getUUID(), mo);
        }
        return mosMap;
    }

    synchronized Datacache.OperationResult try2GetMOs(int moType) {
        if (this.isExpired(moType)) {
            return new Datacache.OperationResult(Datacache.ResultDescription.NEED_SYNC, Collections.EMPTY_LIST, null);
        }
        SerialSet<MO> mos = this.componentMap.get(moType);
        if (mos.isEmpty()) {
            return new Datacache.OperationResult(Datacache.ResultDescription.DATA_NULL, Collections.EMPTY_LIST, null);
        }
        List<MO> dirtyMOs = this.findDirtyMOs(moType);
        if (dirtyMOs.isEmpty()) {
            return new Datacache.OperationResult(Datacache.ResultDescription.NONEED_SYNC, mos.toList(new MO[mos.size()]), null);
        }
        if (this.needSyncPartly(mos, dirtyMOs)) {
            Datacache.OperationResult result = new Datacache.OperationResult(Datacache.ResultDescription.NEED_PART_SYNC, mos.toList(new MO[mos.size()]), null);
            result.setDirtyMOs(dirtyMOs);
            return result;
        }
        return new Datacache.OperationResult(Datacache.ResultDescription.NEED_SYNC, mos.toList(new MO[mos.size()]), null);
    }

    public synchronized MO saveMO(MO mo) {
        if (Datacache.REFRESH_INTERVAL <= 0L) {
            return mo;
        }
        mo.setProperty(LAST_MODIFY_TIME, System.currentTimeMillis());
        mo.setProperty(MO_DIRTY_TAG, false);
        SerialSet<MO> mos = this.componentMap.get(mo.getMOTypeValue());
        if (mos == null) {
            mos = new SerialSet();
            this.componentMap.put(mo.getMOTypeValue(), mos);
            this.mosModifyTimeMap.put(mo.getMOTypeValue(), System.currentTimeMillis());
        }
        mos.add(mo);
        return mo;
    }

    public synchronized void saveMOList(int moType, List<MO> mos) {
        if (Datacache.REFRESH_INTERVAL <= 0L) {
            return;
        }
        this.mosModifyTimeMap.put(moType, System.currentTimeMillis());
        this.componentMap.remove(moType);
        this.componentMap.put(moType, new SerialSet<MO>(mos));
    }

    protected synchronized boolean deleteMO(UUID uuid) {
        SerialSet<MO> mos = this.componentMap.get(uuid.getMOTypeValue());
        if (mos == null) {
            return false;
        }
        MO newMo = new MO(uuid);
        return mos.remove(newMo);
    }

    public synchronized long size() {
        return this.componentMap.size();
    }

    public synchronized boolean isEmpty() {
        return this.componentMap.isEmpty();
    }

    public synchronized void clear() {
        this.componentMap.clear();
    }

    private boolean isExpired(int moType) {
        Long modifyTime = this.mosModifyTimeMap.get(moType);
        if (null == modifyTime) {
            return true;
        }
        long duration = System.currentTimeMillis() - modifyTime;
        return duration >= Datacache.REFRESH_INTERVAL;
    }

    private boolean needSyncPartly(SerialSet<MO> mos, List<MO> dirtyMOs) {
        return dirtyMOs.size() < this.dirtyMOThreshold * 2 && mos.size() > this.dirtyMOThreshold * 4;
    }

    private List<MO> findDirtyMOs(int moType) {
        SerialSet<MO> mos = this.componentMap.get(moType);
        LinkedList<MO> dirtyMOs = new LinkedList<MO>();
        for (MO mo : mos) {
            if (!mo.getBoolProperty(MO_DIRTY_TAG).booleanValue()) continue;
            dirtyMOs.add(mo);
        }
        return dirtyMOs;
    }
}

