/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.bean;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.docoder.BitUtils;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.IsmIntegerFactory;
import com.huawei.ism.tlv.lang.IsmSignedInteger;
import com.huawei.ism.tlv.lang.IsmUnsignedInteger;
import com.huawei.ism.tlv.lang.UnsignedInt16;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Param
implements Serializable,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Param.class);
    private static final long serialVersionUID = -6269984525818228271L;
    @Deprecated
    private String name;
    private ParamType type;
    private int index;
    private Object value;

    public Param() {
    }

    public Param(int index, ParamType paramType, byte[] tlvBytes) {
        this.index = index;
        this.type = paramType;
        if (ParamType.STRING == paramType || ParamType.ARRAY == paramType || ParamType.JSON == paramType) {
            this.value = BitUtils.utf8ByteArrayToString(tlvBytes, tlvBytes.length, 0);
        } else if (ParamType.UNSIGN_INT == paramType || ParamType.SIGN_INT == paramType || ParamType.BOOL == paramType || ParamType.ENUM == paramType || ParamType.TIME == paramType) {
            IsmIntegerFactory factory = IsmIntegerFactory.getInstance();
            this.value = factory.newIsmInteger(paramType, tlvBytes, tlvBytes.length);
        } else if (ParamType.MEMORY == paramType) {
            this.value = tlvBytes;
        }
    }

    public Param(int index, ParamType type, Object value) {
        this.index = index;
        this.type = type;
        if (type == ParamType.STRING && !(value instanceof String)) {
            LOGGER.error(value + " is a " + value.getClass() + " not a String type");
        }
        if (type == ParamType.UNSIGN_INT && !(value instanceof IsmUnsignedInteger)) {
            LOGGER.error(value + " is a " + value.getClass() + " not a IsmUnsignedInteger type");
        }
        if (type == ParamType.SIGN_INT && !(value instanceof IsmSignedInteger)) {
            LOGGER.error(value + " is a " + value.getClass() + " not a IsmSignedInteger type");
        }
        this.value = value;
    }

    public Param(int index, ParamType type, String value) {
        this.index = index;
        this.type = type;
        if (ParamType.UNSIGN_INT == type || ParamType.BOOL == type || ParamType.ENUM == type || ParamType.TIME == type || type == ParamType.SIGN_INT) {
            throw new IsmException("ParamType must be a String Data");
        }
        this.value = value;
    }

    public Param(int index, ParamType type, IsmInteger value) {
        this.index = index;
        this.type = type;
        if (ParamType.STRING == type || ParamType.ARRAY == type || ParamType.JSON == type) {
            throw new IsmException("ParamType must be a IsmInteger Data");
        }
        if (!(ParamType.UNSIGN_INT != type && ParamType.BOOL != type && ParamType.ENUM != type || value instanceof IsmUnsignedInteger)) {
            throw new IsmException(value + " is a " + value.getClass() + " not a IsmUnsignedInteger type");
        }
        if (!(type != ParamType.SIGN_INT && ParamType.TIME != type || value instanceof IsmSignedInteger)) {
            throw new IsmException(value + " is a " + value.getClass() + " not a IsmSignedInteger type");
        }
        this.value = value;
    }

    public Param(int index, String value) {
        this(index, ParamType.STRING, value);
    }

    public Param(int index, IsmInteger value) {
        this(index, value.getType(), value);
    }

    @Deprecated
    public Param(String name, int index, String value) {
        this(name, index, ParamType.STRING, value);
    }

    @Deprecated
    public Param(String name, int index, IsmInteger value) {
        this(name, index, value.getType(), value);
    }

    @Deprecated
    public Param(String name, int index, ParamType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ParamType getType() {
        return this.type;
    }

    public void setType(ParamType type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int cmo) {
        this.index = cmo;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public short getLength() {
        int length = 0;
        boolean isStrType = this.isStringType();
        if (ParamType.U32INT_TYPE == this.type && this.value instanceof Number) {
            length = 4;
        } else if (ParamType.U64LONG_TYPE == this.type && this.value instanceof Number) {
            length = 8;
        } else if (isStrType) {
            length = this.value != null ? (int)((short)BitUtils.stringToUtf8ByteArray(this.value.toString()).length) : 1;
        } else if (this.isIntType()) {
            length = (short)((IsmInteger)this.value).toByteArray().length;
        } else if (this.value instanceof byte[]) {
            length = (short)((byte[])this.value).length;
        }
        return (short)length;
    }

    public boolean isIntType() {
        boolean middleValue = this.type == ParamType.UNSIGN_INT || this.type == ParamType.SIGN_INT || this.type == ParamType.ENUM || this.type == ParamType.BOOL || this.type == ParamType.TIME;
        return middleValue && this.value instanceof IsmInteger;
    }

    private boolean isStringType() {
        return ParamType.STRING == this.type || ParamType.STRING_TYPE == this.type || ParamType.BIG_STRING_TYPE == this.type || ParamType.JSON == this.type || ParamType.ARRAY == this.type;
    }

    public int intValue() {
        int result = 0;
        if (this.value instanceof Number) {
            result = ((Number)this.value).intValue();
        }
        return result;
    }

    public long longValue() {
        long result = 0L;
        if (this.value instanceof Number) {
            result = ((Number)this.value).longValue();
        }
        return result;
    }

    public long shortValue() {
        int result = 0;
        if (this.value instanceof Number) {
            result = ((Number)this.value).shortValue();
        }
        return result;
    }

    public String stringValue() {
        String result = "";
        if (this.value instanceof String) {
            result = (String)this.value;
            result = result.trim();
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Param param = null;
        param = (Param)super.clone();
        param.name = this.name;
        param.type = this.type;
        param.index = this.index;
        param.value = this.value;
        return param;
    }

    public String toString() {
        return this.index + "(" + (Object)((Object)this.type) + ")=" + this.value;
    }

    List<byte[]> toByteArray() {
        ArrayList<byte[]> tlvList = new ArrayList<byte[]>(0);
        ParamType paramType = this.getType();
        if (ParamType.U32INT_TYPE == paramType || ParamType.U64LONG_TYPE == paramType) {
            paramType = ParamType.UNSIGN_INT;
        } else if (ParamType.STRING_TYPE == paramType || ParamType.BIG_STRING_TYPE == paramType) {
            paramType = ParamType.STRING;
        }
        short indexTemp = (short)this.getIndex();
        short typeCmo = (short)((indexTemp << 4) + paramType.value());
        short paramLen = this.getLength();
        Object valueTemp = this.getValue();
        tlvList.add(new UnsignedInt16(typeCmo).toByteArray());
        tlvList.add(new UnsignedInt16(paramLen).toByteArray());
        if (valueTemp instanceof String) {
            tlvList.add(BitUtils.stringToUtf8ByteArray(valueTemp.toString()));
        } else if (valueTemp instanceof IsmInteger) {
            IsmInteger ismIntegerValue = (IsmInteger)valueTemp;
            tlvList.add(ismIntegerValue.toByteArray());
        } else if (valueTemp instanceof byte[]) {
            tlvList.add((byte[])valueTemp);
        }
        return tlvList;
    }
}

