/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.docoder;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.MessageDecodeException;
import com.huawei.ism.tlv.bean.MessageHead;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.BitUtils;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmIntegerFactory;
import com.huawei.ism.tlv.lang.UnsignedInt16;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt64;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageDecoder.class);
    private static MessageDecoder instance;
    private static final int ERROR_TAG = 4095;
    private int offset;

    private MessageDecoder() {
    }

    public static synchronized MessageDecoder getInstance() {
        if (null == instance) {
            instance = new MessageDecoder();
        }
        return instance;
    }

    public DataPackage decode(byte[] msgData, List<Param> params) throws MessageDecodeException {
        if (null == msgData) {
            throw new MessageDecodeException("message data is null");
        }
        DataPackage returnDataPackage = new DataPackage();
        int version = new UnsignedInt32(msgData, 4).intValue();
        if (1 == version || 2 == version) {
            returnDataPackage = this.decodeOldVersion(msgData, params);
        } else if (3 == version) {
            returnDataPackage = this.decodeNewVersion(msgData, params);
        }
        return returnDataPackage;
    }

    private DataPackage decodeOldVersion(byte[] msgData, List<Param> params) throws MessageDecodeException {
        DataPackage returnDataPackage = new DataPackage();
        int msgDataLength = new UnsignedInt32(msgData, 24).intValue();
        if (0 == msgDataLength) {
            returnDataPackage.setHead(new MessageHead(msgData));
            Record record = new Record();
            returnDataPackage.addRecord(record);
            return returnDataPackage;
        }
        this.checkMessageLength(msgDataLength, params);
        int pos = 28;
        boolean startDataPoint = false;
        int readedDataLength = 0;
        Object record = null;
        boolean i = false;
        Object cloneParams = null;
        boolean strLength = false;
        boolean bigStrLength = false;
        boolean length = false;
        this.readAllData(msgData, params, returnDataPackage, msgDataLength, pos, readedDataLength);
        returnDataPackage.setHead(new MessageHead(msgData));
        return returnDataPackage;
    }

    private void readAllData(byte[] msgData, List<Param> params, DataPackage returnDataPackage, int msgDataLength, int pos, int readedDataLength) {
        int iterReadDataLength = readedDataLength;
        int iterPos = pos;
        while (iterReadDataLength < msgDataLength) {
            Record record = new Record();
            int startDataPoint = iterPos;
            iterPos += params.size() * 4;
            int i = 0;
            ArrayList<Param> cloneParams = new ArrayList<Param>(params.size());
            for (Param param : params) {
                try {
                    cloneParams.add((Param)param.clone());
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            for (Param param : cloneParams) {
                UnsignedInt32 value = new UnsignedInt32(msgData, startDataPoint + 4 * i);
                iterReadDataLength += 4;
                int loopOffset = this.setParamValue(msgData, iterPos, param, value);
                iterPos += loopOffset;
                iterReadDataLength += loopOffset;
                record.add(param);
                ++i;
            }
            returnDataPackage.addRecord(record);
        }
    }

    private int setParamValue(byte[] msgData, int pos, Param param, UnsignedInt32 value) {
        int loopOffset;
        if (value.intValue() == -2 || value.intValue() == -3) {
            int strLength = 256;
            int bigStrLength = 1024;
            int length = value.intValue() == -2 ? strLength : bigStrLength;
            String strValue = BitUtils.byteArrayToString(msgData, length, pos);
            param.setValue(strValue);
            loopOffset = length;
        } else if (value.intValue() == -4) {
            UnsignedInt64 unsignedValue = new UnsignedInt64(msgData, pos);
            param.setValue(unsignedValue);
            loopOffset = 8;
        } else {
            param.setValue(value);
            loopOffset = 0;
        }
        return loopOffset;
    }

    private synchronized DataPackage decodeNewVersion(byte[] msgData, List<Param> params) throws MessageDecodeException {
        MessageHead head = new MessageHead(msgData);
        DataPackage returnDataPackage = new DataPackage();
        Record record = null;
        int msgDataLength = head.getDataLength();
        int nullMsgBodyLength = 10;
        int readDataLength = 0;
        this.offset = 28;
        int recordLength = 0;
        while (msgDataLength > nullMsgBodyLength && this.offset <= msgData.length - 1) {
            record = this.getRecord(msgData, params);
            returnDataPackage.addRecord(record);
            recordLength = record.getLength();
            readDataLength += recordLength;
            if (msgDataLength != (readDataLength += 10)) continue;
        }
        returnDataPackage.setHead(head);
        return returnDataPackage;
    }

    private Record getRecord(byte[] buf, List<Param> params) throws MessageDecodeException {
        Record record = new Record();
        long msgCode = new UnsignedInt64(buf, this.offset).longValue();
        this.offset += 8;
        int recordLength = new UnsignedInt16(buf, this.offset).shortValue();
        this.offset += 2;
        int readBytes = 0;
        if (recordLength > 0) {
            ArrayList<Param> cloneParams = new ArrayList<Param>(params.size());
            for (Param param : params) {
                try {
                    cloneParams.add((Param)param.clone());
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            record.setParams(cloneParams);
        }
        while (readBytes < recordLength) {
            readBytes = this.readBufferedData(buf, record, readBytes);
        }
        record.setMsgCode(msgCode);
        record.setLength(recordLength);
        return record;
    }

    private int readBufferedData(byte[] buf, Record record, int readBytes) throws MessageDecodeException {
        Object value = null;
        short typeCmo = new UnsignedInt16(buf, this.offset).shortValue();
        this.offset += 2;
        short paramTypeValue = (short)(typeCmo & 0xF);
        ParamType paramType = ParamType.getParamType(paramTypeValue);
        short index = (short)(typeCmo >> 4 & 0xFFF);
        short paramLength = new UnsignedInt16(buf, this.offset).shortValue();
        this.offset += 2;
        if (ParamType.STRING == paramType) {
            value = BitUtils.utf8ByteArrayToString(buf, paramLength, this.offset);
        } else if (ParamType.UNSIGN_INT == paramType || ParamType.SIGN_INT == paramType) {
            byte[] tmpBytes = new byte[paramLength];
            System.arraycopy(buf, this.offset, tmpBytes, 0, paramLength);
            IsmIntegerFactory factory = IsmIntegerFactory.getInstance();
            value = factory.newIsmInteger(paramType, tmpBytes, paramLength);
        }
        this.offset += paramLength;
        record.setParamValue(index, value);
        int result = readBytes + 2 + 2 + paramLength;
        if (4095 == index && value instanceof String) {
            long errorCode = 0L;
            try {
                errorCode = Long.parseLong(value.toString().replaceAll("\n", ""));
            }
            catch (NumberFormatException e) {
                throw new MessageDecodeException(value.toString(), e);
            }
            IsmException ismException = new IsmException(errorCode, null, null);
            throw ismException;
        }
        return result;
    }

    private void checkMessageLength(int receivedMsgLength, List<Param> params) throws MessageDecodeException {
        int paramNum = params.size();
        int stringParamNum = 0;
        int bigStringParamNum = 0;
        int longParamNum = 0;
        for (Param param : params) {
            if (param.getType() == ParamType.U64LONG_TYPE) {
                ++longParamNum;
                continue;
            }
            if (param.getType() == ParamType.STRING_TYPE) {
                ++stringParamNum;
                continue;
            }
            if (param.getType() != ParamType.BIG_STRING_TYPE) continue;
            ++bigStringParamNum;
        }
        int intBytes = 4;
        int longBytes = 8;
        int specifyMsgLength = paramNum * intBytes + stringParamNum * 256 + bigStringParamNum * 1024 + longParamNum * longBytes;
        if (receivedMsgLength % specifyMsgLength != 0) {
            String msg = "received message length is not equal to specify message length.";
            throw new MessageDecodeException(msg + "received message length is " + receivedMsgLength + " and specify message length is " + specifyMsgLength);
        }
    }
}

