/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;

public class PCIePortMO
extends HardwareInfoAdapter
implements IPortInfo {
    private final MO mo;

    public PCIePortMO(MO mo) {
        this.mo = mo;
    }

    public boolean isNormal() {
        return true;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        Object moObject = this.mo.getProperty(TLV.PCIE_PORT.TYPE);
        if (null == moObject) {
            return null;
        }
        int value = Integer.parseInt(moObject.toString());
        return MOType.getType(value);
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.PCIE_PORT.TYPE, type.getValue());
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.PCIE_PORT.ID, id);
    }

    public String getID() {
        return this.mo.getStrProperty(TLV.PCIE_PORT.ID);
    }

    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.PCIE_PORT.PARENTTYPE).toString());
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.PCIE_PORT.PARENTTYPE, parentType.getValue());
    }

    public String getParentID() {
        return this.mo.getStrProperty(TLV.PCIE_PORT.PARENTID);
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.PCIE_PORT.PARENTID, parentID);
    }

    public String getLocation() {
        return this.mo.getStrProperty(TLV.PCIE_PORT.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.PCIE_PORT.LOCATION, location);
    }

    public int getHealthStatus() {
        Object moObject = this.mo.getProperty(TLV.PCIE_PORT.HEALTHSTATUS);
        if (null == moObject) {
            return -1;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return value;
    }

    public void setHealthStatus(EnumDefine.HEALTH_STATUS_E healthStatus) {
        this.mo.setProperty(TLV.PCIE_PORT.HEALTHSTATUS, healthStatus.getValue());
    }

    public int getRunningStatus() {
        Object moObject = this.mo.getProperty(TLV.PCIE_PORT.RUNNINGSTATUS);
        if (null == moObject) {
            return -1;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return value;
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E runningStatus) {
        this.mo.setProperty(TLV.PCIE_PORT.RUNNINGSTATUS, runningStatus.getValue());
    }

    public void setCurrentPeerID(String currentPeerID) {
        this.mo.setProperty(TLV.PCIE_PORT.CURRENT_PEER_ID, currentPeerID);
    }

    public String getCurrentPeerID() {
        return this.mo.getStrProperty(TLV.PCIE_PORT.CURRENT_PEER_ID);
    }

    public void setSuggestPeerID(String suggestPeerID) {
        this.mo.setProperty(TLV.PCIE_PORT.SUGGEST_PEER_ID, suggestPeerID);
    }

    public String getSuggestPeerID() {
        return this.mo.getStrProperty(TLV.PCIE_PORT.SUGGEST_PEER_ID);
    }
}

