/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.lockui;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui2.mainframe.device.DeviceApplet;
import com.huawei.ism.ui2.perfstat.util.ObjectKeeper;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshUIThread
extends Thread
implements AWTEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshUIThread.class);
    private static final int DEFAULT_INTERVAL_TIME_MINUTE = 60;
    private static final int MINUTE_TO_MILLIS = 60000;
    private int intervalTime;
    private InformationDialog infoDialog;
    private String message = null;
    private DeviceApplet japplet = null;
    private long time = System.currentTimeMillis();
    private Runnable showInfoDialog = new Runnable(){

        @Override
        public void run() {
            if (null != RefreshUIThread.this.infoDialog) {
                return;
            }
            RefreshUIThread.this.infoDialog = new InformationDialog(Framework.getInstance().getMainFrame(), RefreshUIThread.this.message);
            RefreshUIThread.this.infoDialog.getCancelButton().setVisible(false);
            RefreshUIThread.this.infoDialog.getConfirmButton().setVisible(false);
            RefreshUIThread.this.infoDialog.toFront();
            RefreshUIThread.this.infoDialog.setVisible(!Utils.isJunitTest());
        }
    };

    public RefreshUIThread(DeviceApplet japplet) {
        this.japplet = japplet;
        String configTime = CustomResourceManager.getInstance().getString("custom.logouttime");
        this.intervalTime = configTime != null ? Integer.valueOf(configTime) / 60000 : 60;
        this.setName("Logout UI Processor");
        this.setDaemon(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    @Override
    public void run() {
        try {
            long currentTime = 0L;
            long interval = 0L;
            this.message = this.intervalTime < 5 ? ResourceManager.getStringWithParams("logout.real.time.monitor.info", this.intervalTime) : ResourceManager.getString("logout.real.time.monitor.info");
            while (true) {
                Thread.sleep(5000L);
                currentTime = System.currentTimeMillis();
                interval = (currentTime - this.time) / 60000L;
                if (!ObjectKeeper.isDataObjectEmpty() && (long)this.intervalTime - interval <= 5L) {
                    SwingUtil.runInEventDispatchThread(this.showInfoDialog);
                }
                if (interval < (long)this.intervalTime) continue;
                if (this.infoDialog != null) {
                    this.infoDialog.dispose();
                    this.infoDialog = null;
                }
                String url = Framework.getInstance().getStrProperty("CURRENT_URL");
                this.japplet.getAppletContext().showDocument(new URL(url));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("", t);
        }
    }

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.time = System.currentTimeMillis();
        if (null != this.infoDialog) {
            this.infoDialog.dispose();
            this.infoDialog = null;
        }
    }
}

