/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.FontMetrics;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class IsmToolTip
extends JToolTip {
    private static final long serialVersionUID = 1L;
    private int fixedwidth = 300;

    public void setFixedWidth(int width) {
        this.fixedwidth = width;
    }

    @Override
    public void setTipText(String tipText) {
        if (null == tipText) {
            return;
        }
        String html = tipText;
        String htmlHeader = "<html>";
        String htmlHeaderPair = "</html>";
        String htmlWrapText = "<br>";
        if (html.indexOf("<html>") < 0) {
            if (html.indexOf("\n\r") >= 0) {
                html = html.replaceAll("\n\r", "<br>");
            } else if (this.fixedwidth != 0) {
                html = this.getToolTipText(tipText, "<br>");
            }
        }
        html = "<html>" + html;
        html = html + "</html>";
        super.setTipText(html);
    }

    private String getToolTipText(String tipText, String htmlWrap) {
        FontMetrics fm = IsmPlafUtils.getFontMetrics(this, null, IsmFontFactory.getDialogPlain());
        StringBuffer sb = new StringBuffer();
        String tailText = tipText;
        int i = 0;
        String subString = null;
        while (tailText.length() > 0) {
            subString = null;
            for (i = 0; i < tailText.length() && this.isValidEndChar(fm, subString = tailText.substring(0, i)); ++i) {
            }
            sb.append(tailText.substring(0, i));
            sb.append(htmlWrap);
            tailText = tailText.substring(i);
        }
        String html = sb.toString();
        return html;
    }

    private boolean isValidEndChar(FontMetrics fm, String subString) {
        char endChar;
        return SwingUtilities.computeStringWidth(fm, subString) < this.fixedwidth || (endChar = subString.charAt(subString.length() - 1)) <= '\u00ff' && endChar != ' ';
    }

    public int getFixedWidth() {
        return this.fixedwidth;
    }
}

