/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.choose;

import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PushPullPane {
    public static final int SRCTODESVALUE = 0;
    public static final int DESTOSRCVALUE = 1;
    private static final long serialVersionUID = 1L;
    private Window parent;
    private String errorDescription;
    private int desTableMaxSize = -1;
    private IsmTable srcTable = null;
    private IsmTable desTable = null;
    private DefaultTableModel srcTableModel = null;
    private DefaultTableModel desTableModel = null;
    private TableScrollPane rightDownScrollPane;
    private TableScrollPane leftUpScrollPane;
    private JButton toRightOrDownBtn;
    private JButton toLeftOrUpBtn;
    private boolean chooseEnable = true;
    private String leftTitle = null;
    private String rightTitle = null;
    private List<TableRow<?, ?>> srcToDesRows = new ArrayList(0);
    private List<TableRow<?, ?>> desToSrcRows = new ArrayList(0);
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(0);
    private LayoutStyle layoutStyle = LayoutStyle.LEFT_RIGHT;

    public PushPullPane(LayoutStyle style, String leftTitle, String rightTitle, String[] leftTableHeaders, String[] rightTableHeaders) {
        this(style, leftTitle, rightTitle, leftTableHeaders, rightTableHeaders, true);
    }

    public PushPullPane(LayoutStyle style, String leftTitle, String rightTitle, String[] leftTableHeaders, String[] rightTableHeaders, boolean multSelection) {
        this.layoutStyle = style;
        this.leftTitle = leftTitle;
        this.rightTitle = rightTitle;
        this.srcTableModel = new DefaultTableModel(leftTableHeaders, new int[0]);
        this.desTableModel = new DefaultTableModel(rightTableHeaders, new int[0]);
        this.srcTable = new IsmTable(this.srcTableModel);
        this.desTable = new IsmTable(this.desTableModel);
        this.leftUpScrollPane = TableScrollPane.createTablePane(this.srcTable, multSelection);
        this.rightDownScrollPane = TableScrollPane.createTablePane(this.desTable, multSelection);
        if (this.layoutStyle == LayoutStyle.LEFT_RIGHT) {
            this.toRightOrDownBtn = new ArrowButton("rightArrow_normal.png", "rightArrow_disabled.png");
            this.toLeftOrUpBtn = new ArrowButton("leftArrow_normal.png", "leftArrow_disabled.png");
        } else {
            this.toRightOrDownBtn = new ArrowButton("downArrow_normal.png", "downArrow_disabled.png");
            this.toLeftOrUpBtn = new ArrowButton("upArrow_normal.png", "upArrow_disabled.png");
        }
    }

    public JPanel getContentPanel() {
        JPanel contentPane = this.getContentPane();
        this.addHandler();
        this.updateButtonStatus();
        return contentPane;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeDesTableRow(Object rowIdentifier) {
        TableRow<?, ?> tableRow = this.desTableModel.getTableRowBy(rowIdentifier);
        this.desTableModel.removeRow(tableRow);
    }

    private void addHandler() {
        this.tableListener();
        this.toRightOrDownBtnListener();
        this.toLeftOrUpBtnListener();
    }

    private void toLeftOrUpBtnListener() {
        this.toLeftOrUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PushPullPane.this.isRemoveConfirm()) {
                    return;
                }
                List<TableRow> rows = PushPullPane.this.desTable.getMarkedRows();
                PushPullPane.this.srcTableModel.addRow(rows.toArray(new TableRow[rows.size()]));
                PushPullPane.this.desTableModel.removeRow(rows.toArray(new TableRow[rows.size()]));
                PushPullPane.this.desTable.requestFocus();
                for (TableRow tableRow : rows) {
                    if (PushPullPane.this.srcToDesRows.contains(tableRow)) {
                        PushPullPane.this.srcToDesRows.remove(tableRow);
                        continue;
                    }
                    PushPullPane.this.desToSrcRows.add(tableRow);
                }
                PushPullPane.this.updateButtonStatus();
                PushPullPane.this.fireChangedListener();
            }
        });
    }

    private void toRightOrDownBtnListener() {
        this.toRightOrDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PushPullPane.this.isAddConfirm()) {
                    return;
                }
                List<TableRow> rows = PushPullPane.this.srcTable.getMarkedRows();
                if (rows.size() > PushPullPane.this.desTableMaxSize && -1 != PushPullPane.this.desTableMaxSize) {
                    DialogUtils.showErrorDialog(PushPullPane.this.parent, PushPullPane.this.errorDescription);
                    return;
                }
                PushPullPane.this.desTableModel.addRow(rows.toArray(new TableRow[rows.size()]));
                PushPullPane.this.srcTableModel.removeRow(rows.toArray(new TableRow[rows.size()]));
                PushPullPane.this.srcTable.requestFocus();
                for (TableRow tableRow : rows) {
                    if (PushPullPane.this.desToSrcRows.contains(tableRow)) {
                        PushPullPane.this.desToSrcRows.remove(tableRow);
                        continue;
                    }
                    PushPullPane.this.srcToDesRows.add(tableRow);
                }
                PushPullPane.this.updateButtonStatus();
                PushPullPane.this.fireChangedListener();
            }
        });
    }

    private void tableListener() {
        this.srcTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PushPullPane.this.updateButtonStatus();
            }
        });
        this.desTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PushPullPane.this.updateButtonStatus();
            }
        });
        this.srcTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PushPullPane.this.updateButtonStatus();
            }
        });
        this.desTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PushPullPane.this.updateButtonStatus();
            }
        });
    }

    protected boolean isRemoveConfirm() {
        return true;
    }

    protected boolean isAddConfirm() {
        return true;
    }

    public void setChooseEnable(boolean chooseEnable) {
        this.chooseEnable = chooseEnable;
    }

    public void setLeftDatas(List<TableRow<?, ?>> leftDatas) {
        TableRow[] leftRows = leftDatas.toArray(new TableRow[leftDatas.size()]);
        this.srcTableModel.removeAll();
        this.srcTableModel.addRow(leftRows);
    }

    public void setRightDatas(List<TableRow<?, ?>> rightDatas) {
        TableRow[] leftRows = rightDatas.toArray(new TableRow[rightDatas.size()]);
        this.desTableModel.removeAll();
        this.desTableModel.addRow(leftRows);
    }

    public void addSrcTableRow(TableRow ... tableRows) {
        Assert.notNullArray(tableRows);
        this.srcTableModel.addRow(tableRows);
    }

    public void addDesTableRow(TableRow ... tableRows) {
        Assert.notNullArray(tableRows);
        this.desTableModel.addRow(tableRows);
    }

    public void markSrcTableRows(TableRow ... tableRows) {
        this.srcTable.markTableRow(tableRows);
    }

    public void markSrcTableRows(Object ... rowIdentifiers) {
        this.srcTable.markTableRows(rowIdentifiers);
    }

    public void reset() {
        this.srcToDesRows.clear();
        this.desToSrcRows.clear();
    }

    public void clearTableRow(TableRow<?, ?> row, int i) {
        if (i == 0) {
            this.srcToDesRows.remove(row);
        } else {
            this.desToSrcRows.remove(row);
        }
    }

    public List<Object> getSrcToDesDatas() {
        ArrayList<Object> result = new ArrayList<Object>(0);
        for (TableRow<?, ?> tableRow : this.srcToDesRows) {
            result.add(tableRow.getUserObject());
        }
        return result;
    }

    public List<Object> getDesToSrcDatas() {
        ArrayList<Object> result = new ArrayList<Object>(0);
        for (TableRow<?, ?> tableRow : this.desToSrcRows) {
            result.add(tableRow.getUserObject());
        }
        return result;
    }

    public List<TableRow<?, ?>> getSrcToDesTableRows() {
        ArrayList result = new ArrayList(0);
        result.addAll(this.srcToDesRows);
        return result;
    }

    public List<TableRow<?, ?>> getDesToSrcTableRows() {
        ArrayList result = new ArrayList(0);
        result.addAll(this.desToSrcRows);
        return result;
    }

    public void setDesTableSize(Dimension size) {
        this.rightDownScrollPane.setPreferredSize(size);
        this.rightDownScrollPane.setMinimumSize(size);
    }

    public void setSrcTableSize(Dimension size) {
        this.leftUpScrollPane.setPreferredSize(size);
        this.leftUpScrollPane.setMinimumSize(size);
    }

    public void setULTableVisibleColumns(int[] columns) {
        Assert.notNullArray(columns);
        this.srcTableModel.setVisibleColumns(columns);
    }

    public void setDRTableVisibleColumns(int[] columns) {
        Assert.notNullArray(columns);
        this.desTableModel.setVisibleColumns(columns);
    }

    private void updateButtonStatus() {
        if (!this.chooseEnable) {
            this.toRightOrDownBtn.setEnabled(this.chooseEnable);
            this.toLeftOrUpBtn.setEnabled(this.chooseEnable);
        } else {
            this.toRightOrDownBtn.setEnabled(this.srcTable.getSelectedRowCount() > 0);
            this.toLeftOrUpBtn.setEnabled(this.desTable.getSelectedRowCount() > 0);
        }
        if (-1 != this.desTableMaxSize && this.desTable.getRowCount() == this.desTableMaxSize) {
            this.toRightOrDownBtn.setEnabled(false);
        }
    }

    private JPanel getContentPane() {
        TablePane leftUpTablePane = new TablePane(this.leftTitle, this.leftUpScrollPane, this.getBottomComponent());
        TablePane rightDownTablePane = new TablePane(this.rightTitle, this.rightDownScrollPane);
        JPanel contentPanel = null;
        Box buttonPane = null;
        if (this.layoutStyle == LayoutStyle.LEFT_RIGHT) {
            contentPanel = UCD.createBoxLayoutPane(0);
            buttonPane = Box.createVerticalBox();
            buttonPane.add(Box.createVerticalGlue());
            buttonPane.add(this.toRightOrDownBtn);
            buttonPane.add(Box.createVerticalStrut(15));
            buttonPane.add(this.toLeftOrUpBtn);
            buttonPane.add(Box.createVerticalGlue());
            contentPanel.add(leftUpTablePane);
            contentPanel.add(buttonPane);
            contentPanel.add(rightDownTablePane);
        } else if (this.layoutStyle == LayoutStyle.UP_DOWN) {
            contentPanel = UCD.createBoxLayoutPane(1);
            buttonPane = UCD.buildHBoxCentert(15, this.toRightOrDownBtn, this.toLeftOrUpBtn);
            contentPanel.add(leftUpTablePane);
            contentPanel.add(buttonPane);
            contentPanel.add(rightDownTablePane);
        }
        if (null != buttonPane) {
            buttonPane.setBorder(new ButtonAreaBorder(this.layoutStyle));
        }
        if (null != contentPanel) {
            contentPanel.setBorder(new ContentPaneBorder());
        }
        return contentPanel;
    }

    private void fireChangedListener() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(event);
        }
    }

    protected JComponent getBottomComponent() {
        return null;
    }

    public IsmTable getSrcTable() {
        return this.srcTable;
    }

    public IsmTable getDesTable() {
        return this.desTable;
    }

    public void setDesTableMaxSize(int desTableMaxSizeTemp, Window parentWindow, String errorDescriptionTemp) {
        this.desTableMaxSize = desTableMaxSizeTemp;
        this.parent = parentWindow;
        this.errorDescription = errorDescriptionTemp;
    }

    public static enum LayoutStyle {
        LEFT_RIGHT,
        UP_DOWN;

    }

    private static final class ButtonAreaBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -209420288843026653L;
        private final Insets insets = new Insets(5, 5, 5, 5);
        private LayoutStyle style = LayoutStyle.LEFT_RIGHT;

        public ButtonAreaBorder(LayoutStyle style) {
            Assert.notNull((Object)style);
            this.style = style;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            graphics.translate(xx, yy);
            Color innerColor = UIManager.getColor("Control.borderColor");
            graphics.setColor(innerColor);
            if (this.style == LayoutStyle.LEFT_RIGHT) {
                graphics.drawLine(0, 0, 0, height);
                graphics.drawLine(width - 1, 0, width - 1, height);
            } else {
                graphics.drawLine(0, 0, width, 0);
                graphics.drawLine(0, height - 1, width, height - 1);
            }
            graphics.translate(-xx, -yy);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets inset) {
            Insets borderInsets = this.getBorderInsets(component);
            inset.top = borderInsets.top;
            inset.left = borderInsets.left;
            inset.bottom = borderInsets.bottom;
            inset.right = borderInsets.right;
            return inset;
        }
    }

    private static final class ContentPaneBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -209420288843026653L;
        private final Insets tableInsets = new Insets(2, 2, 2, 2);

        private ContentPaneBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            Color innerColor = UIManager.getColor("Control.borderColor");
            graphics.setColor(innerColor);
            graphics.drawRoundRect(xx + 1, yy + 1, width - 3, height - 3, 5, 5);
            Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
            graphics.setColor(outterColor);
            graphics.drawRoundRect(xx, yy, width, height, 5, 5);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.tableInsets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets borderInsets = this.getBorderInsets(component);
            insets.top = borderInsets.top;
            insets.left = borderInsets.left;
            insets.bottom = borderInsets.bottom;
            insets.right = borderInsets.right;
            return insets;
        }
    }

    private static class ArrowButton
    extends JButton {
        private static final int BUTTON_WIDTH = 33;
        private static final int BUTTON_HEIGHT = 28;
        private static final long serialVersionUID = -7034835879929108783L;

        public ArrowButton(String normalIconName, String disableIconName) {
            URL normalIconURL = ArrowButton.class.getResource("images/" + normalIconName);
            URL disabledIconURL = ArrowButton.class.getResource("images/" + disableIconName);
            this.setIcon(new ImageIcon(normalIconURL));
            this.setDisabledIcon(new ImageIcon(disabledIconURL));
            UCD.setJComponentSize(this, new Dimension(33, 28));
            this.setBorder(UnifyBorders.getButtonBorder(true));
        }
    }

    private static class TablePane
    extends JPanel {
        private static final long serialVersionUID = 5219106410846091054L;
        private static final Color TOP_GRADIENT = new Color(15198441);
        private static final int GRADIENT_HEIGHT = 15;

        public TablePane(String title, TableScrollPane scrollPane) {
            this(title, scrollPane, null);
        }

        public TablePane(String title, TableScrollPane scrollPane, JComponent bottomComponent) {
            ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("TitleBorder.centerBG");
            ImageIcon leftIcon = (ImageIcon)UIManager.getIcon("TitleBorder.leftBG");
            ImageIcon rightIcon = (ImageIcon)UIManager.getIcon("TitleBorder.rightBG");
            ImgsAssembledPane.HorizonalSeparator titlePane = new ImgsAssembledPane.HorizonalSeparator(leftIcon, centerIcon, rightIcon);
            titlePane.setOpaque(false);
            JLabel titleLabel = new JLabel(title);
            titleLabel.setBorder(new EmptyBorder(4, 13, 8, 15));
            titleLabel.setFont(IsmFontFactory.getBold12Font());
            titlePane.setLayout(new BorderLayout());
            titlePane.add((Component)titleLabel, "Center");
            JPanel northPane = UCD.createTransparentPane(new BorderLayout());
            northPane.add((Component)titlePane, "West");
            scrollPane.setBorder(new EmptyBorder(0, 5, 5, 5));
            this.setLayout(new BorderLayout());
            this.add((Component)northPane, "North");
            this.add((Component)scrollPane, "Center");
            if (null != bottomComponent) {
                bottomComponent.setBorder(new EmptyBorder(0, 5, 5, 5));
                this.add((Component)UCD.buildHBoxRight(bottomComponent), "South");
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Rectangle bounds = this.getVisibleRect();
            graphics.translate((int)bounds.getX(), (int)bounds.getY());
            graphics.setColor(Color.WHITE);
            graphics.drawLine(1, 1, bounds.width, 1);
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, TOP_GRADIENT, 0.0f, 15.0f, Color.WHITE, false);
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setPaint(gradientPaint);
            g2d.fillRect(1, 1, bounds.width, 15);
            graphics.translate(-((int)bounds.getX()), -((int)bounds.getY()));
        }
    }
}

