/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InputConfirmPanel;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.StyledTextPane;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfirmDialog
extends IsmDialog
implements IAutoProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfirmDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int MAX_PARAM_LENGTH = 30;
    private static final int MAX_WIDTH_LENGTH = 368;
    private Font font = new Font("Dialog", 3, 14);
    private StyleContext styleContext = new StyleContext();
    private Layout layout;
    private JButton confirmButton;
    private JButton cancelButton;
    private boolean isConfirmPerformed;
    private int maxWidth = 368;
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    private ConfirmDialog(Window parent, Level level, String description, String result, String suggestion, String ... params) {
        super(parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(null, false, level, description, result, false, suggestion, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private ConfirmDialog(Window parent, Level level, String confirmMsg, String description, String result, String suggestion, String ... params) {
        super(parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(confirmMsg, false, level, description, result, false, suggestion, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private ConfirmDialog(Frame parent, Level level, String description, String result, String suggestion, int layoutWidth, int layoutHeight, String ... params) {
        super((Window)parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(null, false, level, description, result, suggestion, layoutWidth, layoutHeight, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private ConfirmDialog(Frame parent, Level level, String description, String result, boolean bool, String suggestion, String ... params) {
        super((Window)parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(null, false, level, description, result, bool, suggestion, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private ConfirmDialog(Window parent, String confirmMes, boolean defaultSelect, Level level, String description, String result, String suggestion, String ... params) {
        super(parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(confirmMes, defaultSelect, level, description, result, false, suggestion, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private ConfirmDialog(Window parent, Level level, String confirmMes, boolean defaultSelect, String description, String result, String suggestion, String ... params) {
        super(parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(confirmMes, defaultSelect, level, description, result, false, suggestion, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private ConfirmDialog(Dialog parent, Level level, String description, String result, String suggestion, String ... params) {
        this(parent, level, null, description, result, suggestion, false, params);
    }

    private ConfirmDialog(Dialog parent, Level level, String confirmMsg, String description, String result, String suggestion, boolean showLabel, String ... params) {
        super((Window)parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModal(true);
        this.init(confirmMsg, false, level, description, result, false, suggestion, showLabel, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    public static ConfirmDialog getConfirmDialog(Window parent, Level level, String description, String result, String suggestion, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog(parent, level, description, result, suggestion, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        return dialog;
    }

    public static boolean showDialog(Window parent, Level level, String description, String result, String suggestion, String ... params) {
        ConfirmDialog cDialog = new ConfirmDialog(parent, level, description, result, suggestion, params);
        cDialog.setResizable(false);
        cDialog.setDefaultCloseOperation(2);
        cDialog.pack();
        cDialog.toFront();
        SwingUtil.putParentCenter(cDialog, parent);
        cDialog.setVisible(true);
        return cDialog.isConfirmPerformed;
    }

    public static boolean showSpecifiedConfirmMsgDialog(Window parent, Level level, String description, String confirmMsg, String result, String suggestion, String ... params) {
        ConfirmDialog cDialog = new ConfirmDialog(parent, level, confirmMsg, description, result, suggestion, params);
        ConfirmDialog.showConfirmDialog(parent, cDialog);
        return cDialog.isConfirmPerformed;
    }

    private static void showConfirmDialog(Window parent, ConfirmDialog cDialog) {
        cDialog.setResizable(false);
        cDialog.setDefaultCloseOperation(2);
        cDialog.pack();
        cDialog.toFront();
        SwingUtil.putParentCenter(cDialog, parent);
        cDialog.setVisible(true);
    }

    public static boolean showDialog(Frame parent, Level level, String description, String result, String suggestion, int layoutWidth, int layoutHeight, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog(parent, level, description, result, suggestion, layoutWidth, layoutHeight, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    public static boolean showDialog(Dialog parent, Level level, String description, String result, String suggestion, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog(parent, level, description, result, suggestion, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    public static boolean showLabelDialog(Dialog parent, Level level, String confirmMsg, String description, String result, String suggestion, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog(parent, level, confirmMsg, description, result, suggestion, true, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    private void init(String confirmMes, boolean defaultSelect, Level level, String description, String result, boolean bool, String suggestion, String ... params) {
        this.init(confirmMes, defaultSelect, level, description, result, bool, suggestion, false, params);
    }

    private void init(String confirmMes, boolean defaultSelect, Level level, String description, String result, boolean bool, String suggestion, boolean showLabel, String ... params) {
        if (null == level) {
            throw new IllegalArgumentException("Level can not be null");
        }
        String confirm = ResourceManager.getString("COMMON.TXT.CONFIRM");
        this.confirmButton = UCD.createButton(confirm, 'O');
        this.layout = new Layout(level, confirmMes, defaultSelect, showLabel);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.layout.setBackground(Color.WHITE);
        }
        this.getDialogContentPane().add(this.layout);
        String cancel = ResourceManager.getString("COMMON.TXT.CANCEL");
        this.cancelButton = UCD.createButton(cancel, 'C');
        Box box = UCD.buildButtonBoxRight(new JButton[][]{{this.confirmButton, this.cancelButton}});
        this.getSouthBox().add(box);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.getRootPane().setFocusable(true);
        if (null == confirmMes) {
            this.confirmButton.setEnabled(level != Level.DANGER && level != Level.WARNING && level != Level.INPUT_DANGER);
        }
        if (null != confirmMes) {
            this.confirmButton.setEnabled(false);
        }
        this.initStyles();
        ArrayList<StyledTextPane.Paragraph> para = new ArrayList<StyledTextPane.Paragraph>(0);
        String[] newParams = this.change(params);
        if (null != description && description.length() > 0) {
            para.add(this.createParagraph(description, false, params, newParams));
        }
        if (null != result && result.length() > 0) {
            para.add(this.createParagraph(result, bool, params, newParams));
        }
        if (null != suggestion && suggestion.length() > 0) {
            para.add(this.createParagraph(suggestion, false, params, newParams));
        }
        if (this.layout.showLabel) {
            this.layout.textLabel.setText(description);
        } else {
            this.layout.textArea.setParagraph(para.toArray(new StyledTextPane.Paragraph[para.size()]));
        }
        this.initListeners(level, confirmMes);
    }

    private void init(String confirmMes, boolean defaultSelect, Level level, String description, String result, String suggestion, int layoutWidth, int layoutHeight, String ... params) {
        this.maxWidth = layoutWidth;
        if (null == level) {
            throw new IllegalArgumentException("Level can not be null");
        }
        this.layout = new Layout(level, confirmMes, defaultSelect, layoutWidth, layoutHeight);
        this.getDialogContentPane().add(this.layout);
        String confirm = ResourceManager.getString("COMMON.TXT.CONFIRM");
        this.confirmButton = UCD.createButton(confirm, 'O');
        String cancel = ResourceManager.getString("COMMON.TXT.CANCEL");
        this.cancelButton = UCD.createButton(cancel, 'C');
        Box box = UCD.buildButtonBoxRight(new JButton[][]{{this.confirmButton, this.cancelButton}});
        this.getSouthBox().add(box);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.getRootPane().setFocusable(true);
        if (null == confirmMes) {
            this.confirmButton.setEnabled(level != Level.DANGER && level != Level.WARNING && level != Level.INPUT_DANGER);
        }
        this.initStyles();
        ArrayList<StyledTextPane.Paragraph> paragraphs = new ArrayList<StyledTextPane.Paragraph>();
        String[] newParams = this.change(params);
        if (null != description && description.length() > 0) {
            paragraphs.add(this.createParagraph(description, false, params, newParams));
        }
        if (null != result && result.length() > 0) {
            paragraphs.add(this.createParagraph(result, false, params, newParams));
        }
        if (null != suggestion && suggestion.length() > 0) {
            paragraphs.add(this.createParagraph(suggestion, false, params, newParams));
        }
        this.layout.textArea.setParagraph(paragraphs.toArray(new StyledTextPane.Paragraph[paragraphs.size()]));
        this.initListeners(level, confirmMes);
    }

    private void initListeners(Level level, String confirmMes) {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmDialog.this.isConfirmPerformed = false;
                ConfirmDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfirmDialog.this.isConfirmPerformed = false;
                ConfirmDialog.this.dispose();
            }
        });
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmDialog.this.isConfirmPerformed = true;
                ConfirmDialog.this.dispose();
            }
        });
        if (null == confirmMes && (level == Level.DANGER || level == Level.WARNING) || null != confirmMes) {
            this.layout.confirmCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean isEnabled = ConfirmDialog.this.layout.confirmCheckBox.isSelected();
                    ConfirmDialog.this.confirmButton.setEnabled(isEnabled);
                }
            });
        }
        this.addComponentListener(new AutoProcessListener(this));
        new AutoProcessObserver(this);
    }

    private void initStyles() {
        Style def = this.styleContext.getStyle("default");
        Style paramStyle = this.styleContext.addStyle("param", def);
        StyleConstants.setItalic(paramStyle, true);
        StyleConstants.setAlignment(paramStyle, 1);
        StyleConstants.setSpaceAbove(paramStyle, 10.0f);
        StyleConstants.setSpaceBelow(paramStyle, 10.0f);
        StyleConstants.setFontSize(paramStyle, 14);
        StyleConstants.setBold(paramStyle, true);
        Style normalStyle = this.styleContext.addStyle("normal", def);
        StyleConstants.setFontSize(normalStyle, 12);
        StyleConstants.setSpaceAbove(normalStyle, 4.0f);
        StyleConstants.setSpaceBelow(normalStyle, 4.0f);
        StyleConstants.setFontFamily(normalStyle, "dialog");
    }

    private StyledTextPane.Paragraph createParagraph(String content, boolean bool, String[] params, String[] newParams) {
        ArrayList<StyledTextPane.Segment> segments = new ArrayList<StyledTextPane.Segment>(0);
        Style paramStyle = this.styleContext.getStyle("param");
        Style normalStyle = this.styleContext.getStyle("normal");
        if (null == params || 0 == params.length) {
            if (bool) {
                return new StyledTextPane.Paragraph(normalStyle, new StyledTextPane.Segment(paramStyle, content));
            }
            return new StyledTextPane.Paragraph(normalStyle, new StyledTextPane.Segment(normalStyle, content));
        }
        String collapsedIconPath = "/com/huawei/ism/ui/swing/plaf/icons/norm/tree_collapsed.png";
        String expandedIconPath = "/com/huawei/ism/ui/swing/plaf/icons/norm/tree_expanded.png";
        ImageIcon collapsed = new ImageIcon(this.getClass().getResource(collapsedIconPath));
        ImageIcon expanded = new ImageIcon(this.getClass().getResource(expandedIconPath));
        HashMap<String, StyledTextPane.Segment> paramSegments = new HashMap<String, StyledTextPane.Segment>(0);
        HashMap<String, StyledTextPane.Segment> iconSegments = new HashMap<String, StyledTextPane.Segment>(0);
        String key = null;
        Style iconStyle = null;
        JLabel label = null;
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            String newParam = newParams[i];
            key = "##" + (i <= 9 ? "0" : "") + i;
            paramSegments.put(key, new StyledTextPane.Segment(paramStyle, param));
            if (param.length() <= 30) continue;
            String shortParam = param.substring(0, 30) + "...";
            iconStyle = this.styleContext.addStyle(null, null);
            label = new JLabel(collapsed);
            label.setBorder(new EmptyBorder(0, 2, 6, 2));
            label.addMouseListener(new MyMouseAdapter(collapsed, expanded, newParam, shortParam, paramStyle, this.layout.textArea));
            StyleConstants.setComponent(iconStyle, label);
            StyledTextPane.Segment iconSegment = new StyledTextPane.Segment(iconStyle, " ");
            StyledTextPane.Segment paramSegment = new StyledTextPane.Segment(paramStyle, param.substring(0, 30) + "...");
            iconSegments.put(key, iconSegment);
            paramSegments.put(key, paramSegment);
        }
        List<String> segmentSeq = this.parseSegment(content);
        this.createParagraphDegread(segments, normalStyle, paramSegments, iconSegments, segmentSeq);
        if (bool) {
            return new StyledTextPane.Paragraph(paramStyle, segments.toArray(new StyledTextPane.Segment[segments.size()]));
        }
        return new StyledTextPane.Paragraph(normalStyle, segments.toArray(new StyledTextPane.Segment[segments.size()]));
    }

    private String[] change(String[] params) {
        if (params == null) {
            return new String[0];
        }
        String[] result = new String[params.length];
        int width = this.maxWidth - 30;
        int firstLineWidth = width - 24;
        for (int i = 0; i < params.length; ++i) {
            String s = params[i];
            StringBuffer temp = new StringBuffer();
            String[] results = this.getString(s, firstLineWidth);
            temp.append(results[0]);
            s = results[1];
            while (s != null) {
                results = this.getString(s, width);
                temp.append('\r').append(results[0]);
                s = results[1];
            }
            result[i] = temp.toString();
        }
        return result;
    }

    private String[] getString(String str, int width) {
        int stringWidth = this.stringWidth(str);
        if (stringWidth <= width) {
            return new String[]{str, null};
        }
        int size = str.length();
        int cutSize = size * width / stringWidth;
        String temp = str.substring(0, cutSize);
        int currentWidth = this.stringWidth(temp);
        boolean lastOperIsAdd = false;
        while (!lastOperIsAdd || currentWidth <= width) {
            if (currentWidth <= width) {
                temp = str.substring(0, ++cutSize);
                currentWidth = this.stringWidth(temp);
                lastOperIsAdd = true;
                continue;
            }
            temp = temp.substring(0, --cutSize);
            currentWidth = this.stringWidth(temp);
            lastOperIsAdd = false;
        }
        temp = temp.substring(0, temp.length() - 1);
        return new String[]{temp, str.substring(temp.length())};
    }

    private int stringWidth(String str) {
        return this.layout.textArea.getFontMetrics(this.font).stringWidth(str);
    }

    private void createParagraphDegread(List<StyledTextPane.Segment> segments, Style normalStyle, Map<String, StyledTextPane.Segment> paramSegments, Map<String, StyledTextPane.Segment> iconSegments, List<String> segmentSeq) {
        for (String segStr : segmentSeq) {
            if (iconSegments.containsKey(segStr)) {
                segments.add(iconSegments.get(segStr));
                segments.add(paramSegments.get(segStr));
                continue;
            }
            StyledTextPane.Segment segment = paramSegments.get(segStr);
            if (null == segment) {
                segments.add(new StyledTextPane.Segment(normalStyle, segStr));
                continue;
            }
            segments.add(segment);
        }
    }

    private List<String> parseSegment(String content) {
        ArrayList<String> segmentSeq = new ArrayList<String>(0);
        int index = -1;
        String actualContent = content;
        while ((index = actualContent.indexOf("##")) >= 0) {
            if (index > 0) {
                segmentSeq.add(actualContent.substring(0, index));
            }
            segmentSeq.add(actualContent.substring(index, index + 4));
            actualContent = actualContent.substring(index + 4);
        }
        segmentSeq.add(actualContent);
        return segmentSeq;
    }

    public boolean getIsConfirmPerformed() {
        return this.isConfirmPerformed;
    }

    public boolean getIsSelectedLinkage() {
        return this.layout.confirmCheckBox.isSelected();
    }

    public static ConfirmDialog showDialog(Frame parent, Level level, String confirmMes, boolean defaultSelect, String description, String result, String suggestion, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog((Window)parent, confirmMes, defaultSelect, level, description, result, suggestion, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        dialog.setVisible(true);
        return dialog;
    }

    public static ConfirmDialog showDialog(Dialog parent, Level level, String confirmMes, boolean defaultSelect, String description, String result, String suggestion, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog((Window)parent, level, confirmMes, defaultSelect, description, result, suggestion, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        dialog.setVisible(true);
        return dialog;
    }

    public static boolean showDialog(Frame parent, Level level, String description, String result, boolean bool, String suggestion, String ... params) {
        ConfirmDialog dialog = new ConfirmDialog(parent, level, description, result, bool, suggestion, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter(dialog, parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    @Override
    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.confirmButton.setEnabled(true);
        this.confirmButton.doClick();
    }

    private static class MyMouseAdapter
    extends MouseAdapter {
        private Icon expanded;
        private Icon collapsed;
        private String param;
        private String shortParam;
        private Style paramStyle;
        private StyledTextPane styledTextPane;

        public MyMouseAdapter(Icon collapsed, Icon expanded, String param, String shortParam, Style paramStyle, StyledTextPane styledTextPane) {
            this.expanded = expanded;
            this.collapsed = collapsed;
            this.param = param;
            this.shortParam = shortParam;
            this.paramStyle = paramStyle;
            this.styledTextPane = styledTextPane;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Point mousePosition = this.styledTextPane.getMousePosition();
                if (null == mousePosition) {
                    throw new NullPointerException();
                }
                Point point = new Point(mousePosition);
                point.setLocation((int)point.getX() + 6 - mouseEvent.getX(), (int)point.getY());
                int pos = this.styledTextPane.viewToModel(point);
                Document doc = this.styledTextPane.getDocument();
                JLabel source = (JLabel)mouseEvent.getSource();
                try {
                    if (source.getIcon() == this.collapsed) {
                        source.setIcon(this.expanded);
                        doc.remove(pos, 33);
                        doc.insertString(pos, this.param, this.paramStyle);
                    } else {
                        source.setIcon(this.collapsed);
                        doc.remove(pos, this.param.length());
                        doc.insertString(pos, this.shortParam, this.paramStyle);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("", (Throwable)ex);
                }
            }
        }
    }

    private class Layout
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int layoutWidth = 368;
        private int layoutHeight = 170;
        private StyledTextPane textArea;
        private boolean showLabel;
        private JEditorPane textLabel;
        private JScrollPane scrollPane;
        private JCheckBox confirmCheckBox;

        public Layout(Level level) {
            this.setLayout(new BoxLayout(this, 0));
            this.init(level, null, false);
        }

        public Layout(Level level, String confirmMes, boolean defaultSelect, boolean showLabel) {
            this.setLayout(new BoxLayout(this, 0));
            this.showLabel = showLabel;
            this.init(level, confirmMes, defaultSelect);
        }

        public Layout(Level level, String confirmMes, boolean defaultSelect, int layoutWidth, int layoutHeight) {
            this.setLayout(new BoxLayout(this, 0));
            this.layoutWidth = layoutWidth;
            this.layoutHeight = layoutHeight;
            this.init(level, confirmMes, defaultSelect);
        }

        private void init(Level level, String confirmMes, boolean defaultSelect) {
            Box leftBox = Box.createVerticalBox();
            ImageIcon icon = ResourceManager.getImage("comfirmdialog_question.png");
            switch (level) {
                case DANGER: 
                case INPUT_DANGER: {
                    icon = ResourceManager.getImage("comfirmdialog_danger.png");
                    break;
                }
                case WARNING: {
                    icon = ResourceManager.getImage("comfirmdialog_warn.png");
                    break;
                }
                case INFO: {
                    icon = ResourceManager.getImage("comfirmdialog_question.png");
                    break;
                }
            }
            leftBox.add(Box.createVerticalStrut(15));
            leftBox.add(new JLabel(icon));
            leftBox.add(Box.createVerticalGlue());
            Box rightBox = Box.createVerticalBox();
            rightBox.add(Box.createVerticalStrut(15));
            this.setTextArea(level, rightBox);
            if (level == Level.DANGER || level == Level.WARNING || null != confirmMes || level == Level.INPUT_DANGER) {
                rightBox.add(Box.createVerticalStrut(5));
                Box confirmBox = Box.createHorizontalBox();
                if (level == Level.INPUT_DANGER) {
                    InputConfirmPanel confirm = new InputConfirmPanel(confirmMes == null ? ResourceManager.getString("COMMON.TXT.CONFIRM_DIALOG_CONFIRM") : confirmMes, "Yes", Collections.singletonList(ConfirmDialog.this.confirmButton));
                    confirmBox.add(confirm);
                    this.confirmCheckBox = new JCheckBox();
                } else {
                    this.confirmCheckBox = new JCheckBox(null == confirmMes ? ResourceManager.getString("COMMON.TXT.CONFIRM_DIALOG_CONFIRM") : confirmMes);
                    this.confirmCheckBox.setSelected(null != confirmMes ? defaultSelect : false);
                    confirmBox.add(this.confirmCheckBox);
                }
                confirmBox.add(Box.createGlue());
                rightBox.add(confirmBox);
            }
            rightBox.add(Box.createVerticalStrut(15));
            this.add(Box.createHorizontalStrut(30));
            this.add(leftBox);
            this.add(Box.createHorizontalStrut(10));
            this.add(rightBox);
            this.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
            this.add(Box.createHorizontalGlue());
            this.add(Box.createHorizontalStrut(30));
        }

        private void setTextArea(Level level, Box rightBox) {
            Box levelDesc = Box.createHorizontalBox();
            levelDesc.add(this.createLevelLabel(level));
            levelDesc.add(Box.createGlue());
            rightBox.add(this.createText());
        }

        @NotNull
        private JComponent createText() {
            if (this.showLabel) {
                this.textLabel = new JEditorPane();
                this.textLabel.setContentType("text/html");
                this.textLabel.setEditable(false);
                this.textLabel.addHyperlinkListener(this::openBrowser);
                this.textLabel.setBackground(ConfirmDialog.this.getBackground());
                this.textLabel.setBorder(BorderFactory.createEmptyBorder());
                this.scrollPane = new JScrollPane(this.textLabel);
                Dimension size = new Dimension(this.layoutWidth, this.layoutHeight);
                this.scrollPane.setPreferredSize(size);
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
                return this.scrollPane;
            }
            this.textArea = new MystyledTextPane();
            this.textArea.setEditable(false);
            this.textArea.setBorder(new EmptyBorder(8, 8, 0, 0));
            this.textArea.setFocusable(true);
            JScrollPane newScrollPane = new JScrollPane(this.textArea);
            Dimension size = new Dimension(this.layoutWidth, this.layoutHeight);
            newScrollPane.setPreferredSize(size);
            newScrollPane.setVerticalScrollBarPolicy(20);
            newScrollPane.setHorizontalScrollBarPolicy(31);
            return newScrollPane;
        }

        private void openBrowser(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (IOException | URISyntaxException ex) {
                    LOGGER.error("open url failed", (Throwable)ex);
                    DialogUtils.showInfoDialog(ConfirmDialog.this, ResourceUtil.getString((String)"open.url.failed"));
                }
            }
        }

        private JLabel createLevelLabel(Level level) {
            JLabel label = new JLabel();
            if (level == Level.DANGER || level == Level.INPUT_DANGER) {
                label.setForeground(Color.RED);
            }
            label.setFont(new FontUIResource("Dialog", 1, 24));
            label.setText(level.toString());
            return label;
        }

        private final class MystyledTextPane
        extends StyledTextPane {
            private static final long serialVersionUID = -4736790349519271643L;

            private MystyledTextPane() {
                super(new StyledTextPane.Paragraph[0]);
            }

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
            }
        }
    }

    public static enum Level {
        DANGER("Danger"),
        INPUT_DANGER("Danger"),
        WARNING("Warning"),
        INFO("Info");

        private String name;
        private String strKey;

        private Level(String name) {
            this.name = name;
            this.strKey = "COMMON.ENUM.CONFIRM_DIALOG_LEVEL." + name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return ResourceManager.getString(this.strKey, this.getName());
        }
    }
}

