/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.UIManager;

public class WarningDialog
extends JDialog
implements DialogsConstants,
IAutoProcess {
    protected static final int DISPLAY_PROMPT_DEFAULT_COLUMN = 31;
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int GRIDY_1 = 1;
    private static final int INSETS_EMPTY = 0;
    private static final long serialVersionUID = -7858562840591485694L;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    protected JCheckBox check;
    protected IsmTextArea displayPrompt;
    protected JPanel displayPanel;
    protected int textColumn = 0;
    private boolean focusYes = false;
    private int dialogValue = -1;
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();
    private Box buttonPanel;
    private JButton cannelButton;
    private JButton confirmButton;
    private JButton customButton;
    private JLabel imageLabel;
    private JPanel wholePanel;
    private IsmTextArea checkMessage;

    public WarningDialog(Window parent, String title, String newMessage, String newImageIcon) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public WarningDialog(Window parent, String title, String newMessage, String newImageIcon, int timeout) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon, timeout);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public WarningDialog(Window parent, String title, String newMessage, String ensureInfo, String newImageIcon) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        this.changePanelLayout(ensureInfo);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.initCheckBoxListener();
    }

    public WarningDialog(Frame parent, String title, String newMessage, String newImageIcon) {
        super(parent, true);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public WarningDialog(Window parent, String title, String newMessage, String newImageIcon, boolean focusYes) {
        this(parent, title, newMessage, newImageIcon);
        this.focusYes = focusYes;
    }

    public WarningDialog(Window parent, String title, String newMessage, boolean focusYes, boolean isOnTop) {
        this(parent, title, newMessage, null);
        this.focusYes = focusYes;
        this.setAlwaysOnTop(isOnTop);
    }

    public WarningDialog(Window parent, String title, String newMessage, String newImageIcon, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.layoutUI(title, newMessage, newImageIcon, okInfo, cancelInfo, okWidth, cancelWidth);
    }

    public WarningDialog(Window parent, String title, String newMessage, String newImageIcon, String okInfo, String cancelInfo, int okWidth, int cancelWidth, boolean focusYes) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.focusYes = focusYes;
        this.layoutUI(title, newMessage, newImageIcon, okInfo, cancelInfo, okWidth, cancelWidth);
    }

    public WarningDialog(Window parent, String title, String newMessage, String newImageIcon, String okInfo, String cancelInfo, int okWidth, int cancelWidth, int textColumnz) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.textColumn = textColumnz;
        this.layoutUI(title, newMessage, newImageIcon, okInfo, cancelInfo, okWidth, cancelWidth);
    }

    public WarningDialog(Frame parent, String title, String newMessage, String newImageIcon, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        super(parent, true);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.layoutUI(title, newMessage, newImageIcon, okInfo, cancelInfo, okWidth, cancelWidth);
    }

    public WarningDialog(JDialog parent, String title, String newMessage) {
        this((Window)parent, title, newMessage, "comfirmdialog_warn.png");
    }

    public WarningDialog(Frame parent, String title, String newMessage) {
        this(parent, title, newMessage, "comfirmdialog_warn.png");
    }

    public WarningDialog(JDialog parent, String newMessage) {
        this(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), newMessage);
    }

    public WarningDialog(Frame parent, String newMessage) {
        this(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), newMessage);
    }

    private void layoutUI(String title, String newMessage, String newImageIcon, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        this.confirmButton.setText(okInfo);
        this.confirmButton.setToolTipText(okInfo);
        this.cannelButton.setText(cancelInfo);
        this.cannelButton.setToolTipText(cancelInfo);
        this.confirmButton.setPreferredSize(new Dimension(okWidth, BUTTON_HTGHT));
        this.confirmButton.setMaximumSize(new Dimension(okWidth, BUTTON_HTGHT));
        this.confirmButton.setMinimumSize(new Dimension(okWidth, BUTTON_HTGHT));
        this.cannelButton.setPreferredSize(new Dimension(cancelWidth, BUTTON_HTGHT));
        this.cannelButton.setMaximumSize(new Dimension(cancelWidth, BUTTON_HTGHT));
        this.cannelButton.setMinimumSize(new Dimension(cancelWidth, BUTTON_HTGHT));
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    private void layoutUI(String title, String newImageIcon, DialogUtils.DialogConstructorData dialogConstructorData) {
        this.toFront();
        this.initTripleButtonDialog(title, dialogConstructorData.getNewMessage(), newImageIcon);
        this.confirmButton.setText(dialogConstructorData.getOkInfo());
        this.confirmButton.setToolTipText(dialogConstructorData.getOkInfo());
        this.customButton.setText(dialogConstructorData.getCustomInfo());
        this.customButton.setToolTipText(dialogConstructorData.getCustomInfo());
        this.cannelButton.setText(dialogConstructorData.getCancelInfo());
        this.cannelButton.setToolTipText(dialogConstructorData.getCancelInfo());
        this.confirmButton.setPreferredSize(new Dimension(dialogConstructorData.getOkWidth(), BUTTON_HTGHT));
        this.confirmButton.setMaximumSize(new Dimension(dialogConstructorData.getOkWidth(), BUTTON_HTGHT));
        this.confirmButton.setMinimumSize(new Dimension(dialogConstructorData.getOkWidth(), BUTTON_HTGHT));
        this.customButton.setPreferredSize(new Dimension(dialogConstructorData.getCustomWidth(), BUTTON_HTGHT));
        this.customButton.setMaximumSize(new Dimension(dialogConstructorData.getCustomWidth(), BUTTON_HTGHT));
        this.customButton.setMinimumSize(new Dimension(dialogConstructorData.getCustomWidth(), BUTTON_HTGHT));
        this.cannelButton.setPreferredSize(new Dimension(dialogConstructorData.getCancelWidth(), BUTTON_HTGHT));
        this.cannelButton.setMaximumSize(new Dimension(dialogConstructorData.getCancelWidth(), BUTTON_HTGHT));
        this.cannelButton.setMinimumSize(new Dimension(dialogConstructorData.getCancelWidth(), BUTTON_HTGHT));
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public WarningDialog(Window parent, String warningInfo, String ensureInfo) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(ResourceManager.getString("WARNING_DIALOG_TITLE"), warningInfo, "comfirmdialog_warn.png");
        this.changePanelLayout(ensureInfo);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.initCheckBoxListener();
    }

    public WarningDialog(String title, String newImageIcon, DialogUtils.DialogConstructorData dialogConstructorData) {
        super(dialogConstructorData.getParent());
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.layoutUI(title, newImageIcon, dialogConstructorData);
    }

    public int getValue() {
        return this.dialogValue;
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                if (this.focusYes) {
                    this.confirmButton.requestFocus();
                    break;
                }
                if (this.customButton != null) {
                    this.customButton.requestFocus();
                    break;
                }
                this.cannelButton.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    private void changePanelLayout(String ensureInfo) {
        GridBagConstraints checkBoxConstraints = new GridBagConstraints();
        checkBoxConstraints.gridx = 1;
        checkBoxConstraints.gridy = 1;
        checkBoxConstraints.anchor = 17;
        checkBoxConstraints.insets = new Insets(0, 12, 0, 0);
        Box hBox = this.buildBox();
        this.checkMessage = new IsmTextArea();
        this.checkMessage.setEditable(false);
        this.checkMessage.setColumns(31);
        this.checkMessage.setName("ISMV1R2_framework_WarningDialog_checkLabel");
        this.checkMessage.setText(ensureInfo);
        this.checkMessage.setLineWrap(true);
        hBox.add(this.checkMessage);
        hBox.setBorder(UCD.createEmptyBorder());
        this.displayPanel.add((Component)hBox, checkBoxConstraints);
        this.pack();
        this.confirmButton.setEnabled(false);
    }

    protected Box buildBox() {
        Box hBox = Box.createHorizontalBox();
        this.check = new JCheckBox();
        hBox.add(this.check);
        return hBox;
    }

    protected void initComponent() {
        int margin = 8;
        this.displayPanel();
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new ArmorSeparator();
        }
        this.innerPanel(margin, separator);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.panelBackground(gridBagConstraints);
        this.manageLayer();
    }

    private void manageLayer() {
        this.displayPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.imageLabel, gridBagConstraints);
        this.displayPrompt.setBorder(UCD.createEmptyBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.displayPrompt, gridBagConstraints);
        this.displayPrompt.setMargin(new Insets(0, 0, 0, 0));
    }

    private void panelBackground(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        this.buttonPanel = UCD.buildHBoxCentert(this.confirmButton, this.cannelButton);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        this.wholePanel.add((Component)bottomPanel, gridBagConstraints);
    }

    private void innerPanel(int margin, JSeparator separator) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(margin);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        this.wholePanel.add((Component)innerBox, gridBagConstraints);
    }

    private void displayPanel() {
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 9, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
    }

    protected void initTripleButtonPanelComponent() {
        int margin = 8;
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 9, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new ArmorSeparator();
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(margin);
        this.paintPanel(gridBagConstraints, innerBox, boxStruts);
        this.buttonLayout();
    }

    private void buttonLayout() {
        this.displayPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.imageLabel, gridBagConstraints);
        this.displayPrompt.setBorder(UCD.createEmptyBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.displayPrompt, gridBagConstraints);
        this.displayPrompt.setMargin(new Insets(0, 0, 0, 0));
    }

    private void paintPanel(GridBagConstraints gridBagConstraints, Box innerBox, JComponent boxStruts) {
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        this.wholePanel.add((Component)innerBox, gridBagConstraints);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.anchor = 11;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.1;
        this.buttonPanel = UCD.buildHBoxCentert(this.confirmButton, this.customButton, this.cannelButton);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        this.wholePanel.add((Component)bottomPanel, constraints);
    }

    private void init(String title, String newMessage, String newImageIcon) {
        String actualTitle = title == null ? ResourceManager.getString("WARNING_DIALOG_TITLE") : title;
        String actualNewImageIcon = newImageIcon == null ? "comfirmdialog_warn.png" : newImageIcon;
        this.cannelButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CANCEL"), 'C');
        this.confirmButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CONFIRM"), 'O');
        this.displayPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_framework_WarningDialog_imageLabel");
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setEditable(false);
        this.displayPrompt.setColumns(this.textColumn == 0 ? 31 : this.textColumn);
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.wholePanel = new JPanel();
        this.initComponent();
        this.initButtonEvent();
        super.setTitle(actualTitle);
        ImageIcon imageIcon = ResourceManager.getImage(actualNewImageIcon);
        this.imageLabel.setIcon(imageIcon);
        this.pack();
        this.displayPrompt.setText(newMessage);
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter(this, this.getOwner());
        SwingUtil.setName(this);
        this.setCompName();
        this.getRootPane().setDefaultButton(this.focusYes ? this.cannelButton : this.confirmButton);
    }

    private void init(String title, String newMessage, String newImageIcon, int timeout) {
        this.init(title, newMessage, newImageIcon);
        Timer timer = new Timer(timeout * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WarningDialog.this.dialogValue == -1) {
                    WarningDialog.this.dialogValue = 1;
                    WarningDialog.this.dispose();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void initTripleButtonDialog(String title, String newMessage, String newImageIcon) {
        String actualTitle = title == null ? ResourceManager.getString("WARNING_DIALOG_TITLE") : title;
        String actualNewImageIcon = newImageIcon == null ? "comfirmdialog_warn.png" : newImageIcon;
        this.cannelButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CANCEL"), 'C');
        this.confirmButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CONFIRM"), 'O');
        this.customButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.DETAIL"), 'U');
        this.displayPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_framework_WarningDialog_imageLabel");
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setEditable(false);
        this.displayPrompt.setColumns(this.textColumn == 0 ? 31 : this.textColumn);
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.wholePanel = new JPanel();
        this.initTripleButtonPanelComponent();
        this.initTripleButtonEvent();
        super.setTitle(actualTitle);
        ImageIcon imageIcon = ResourceManager.getImage(actualNewImageIcon);
        this.imageLabel.setIcon(imageIcon);
        this.pack();
        this.displayPrompt.setText(newMessage);
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter(this, this.getOwner());
        SwingUtil.setName(this);
        this.setTripleButtonPanelCompName();
        this.getRootPane().setDefaultButton(this.focusYes ? this.cannelButton : this.confirmButton);
    }

    private void cannelButtonAction(ActionEvent e) {
        this.dialogValue = 1;
        this.dispose();
    }

    private void confimButtonAction(ActionEvent e) {
        this.dialogValue = 0;
        this.dispose();
    }

    private void customButtonAction(ActionEvent e) {
        this.dialogValue = 5;
        this.dispose();
    }

    public void setValue(int value) {
        if (Utils.isJunitTest()) {
            this.dialogValue = value;
        }
    }

    @Override
    public final void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent(window);
    }

    private void initButtonEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.cannelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningDialog.this.cannelButtonAction(actionEvent);
            }
        });
        new AutoProcessObserver(this);
        this.addComponentListener(new AutoProcessListener(this));
    }

    private void initTripleButtonEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.cannelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningDialog.this.cannelButtonAction(actionEvent);
            }
        });
        this.customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningDialog.this.customButtonAction(actionEvent);
            }
        });
    }

    private void initCheckBoxListener() {
        this.check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selectedStatus = WarningDialog.this.check.isSelected();
                WarningDialog.this.check.setSelected(selectedStatus);
                WarningDialog.this.confirmButton.setEnabled(selectedStatus);
            }
        });
        this.checkMessage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean selectedStatus = WarningDialog.this.check.isSelected();
                WarningDialog.this.check.setSelected(!selectedStatus);
                WarningDialog.this.confirmButton.setEnabled(!selectedStatus);
            }
        });
    }

    public JButton getCannelButton() {
        return this.cannelButton;
    }

    public void setCannelButton(JButton cannelButton) {
        this.cannelButton = cannelButton;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public void setConfirmButton(JButton confirmButton) {
        this.confirmButton = confirmButton;
    }

    public void setButtonSize(int okWidth, int cancelWidth, int okMneonic, int cancelMneonic) {
        this.cannelButton.setMnemonic('C');
        this.confirmButton.setMnemonic('O');
        UCD.setJComponentSize(this.cannelButton, new Dimension(okWidth, BUTTON_HTGHT));
        UCD.setJComponentSize(this.confirmButton, new Dimension(cancelWidth, BUTTON_HTGHT));
    }

    private void setCompName() {
        this.cannelButton.setName("_Button_cancelButton");
        this.confirmButton.setName("_Button_confirmButton");
        this.displayPrompt.setName("_TextArea_displayPrompt");
    }

    private void setTripleButtonPanelCompName() {
        this.cannelButton.setName("_Button_cancelButton");
        this.confirmButton.setName("_Button_confirmButton");
        this.customButton.setName("_Button_customButton");
        this.displayPrompt.setName("_TextArea_displayPrompt");
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.confirmButton.doClick();
    }

    @Override
    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    public boolean isConfirmClick() {
        return this.getValue() == 0;
    }

    protected static final class ArmorSeparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        protected ArmorSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

