/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class IsmFileChooserUI
extends MetalFileChooserUI {
    private BasicFileChooserUI.ApproveSelectionAction approveAction = new IsmApproveSelectionAction();

    public IsmFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
        filechooser.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                IsmFileChooserUI.this.setDefaultButton();
                IsmFileChooserUI.this.setButtonMnemonic();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new IsmFileChooserUI(CommonUtil.convertObject(jComponent, JFileChooser.class));
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.directoryOpenButtonText = ResourceManager.getString("ALARM_BUZZER_BUTTON_OPEN");
        }
        super.setDirectorySelected(directorySelected);
        this.updateApproveButton(directorySelected);
    }

    protected void updateApproveButton(boolean directorySelected) {
        JFileChooser chooser = this.getFileChooser();
        JButton approveButton = this.getApproveButton(chooser);
        if (directorySelected) {
            if (null != approveButton) {
                approveButton.setText(this.directoryOpenButtonText);
                approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
                approveButton.setMnemonic(this.directoryOpenButtonMnemonic);
            }
        } else if (null != approveButton) {
            approveButton.setText(this.getApproveButtonText(chooser));
            approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
            approveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        }
        this.setDefaultButton();
        if (null != approveButton && null != approveButton.getText()) {
            UCD.formatMnemonicDisplay(approveButton);
        }
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveAction;
    }

    @Override
    protected MetalFileChooserUI.FilterComboBoxModel createFilterComboBoxModel() {
        return new MetalFileChooserUI.FilterComboBoxModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedItem(Object filter) {
                if (filter != null) {
                    IsmFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                    this.fireContentsChanged(this, -1, -1);
                }
            }
        };
    }

    private static List<JButton> getButtons(JComponent component, JComponent exclude) {
        ArrayList<JButton> buttons = new ArrayList<JButton>(0);
        if (component.getComponentCount() <= 0) {
            if ((null == exclude || !component.equals(exclude)) && component instanceof JButton) {
                buttons.add((JButton)component);
            }
        } else {
            Component[] components;
            for (Component com : components = component.getComponents()) {
                if (null != exclude && com.equals(exclude) || !(com instanceof JComponent)) continue;
                buttons.addAll(IsmFileChooserUI.getButtons((JComponent)com, exclude));
            }
        }
        return buttons;
    }

    protected void setButtonMnemonic() {
        JButton button = null;
        String buttonText = null;
        for (Component component : IsmFileChooserUI.getButtons(this.getButtonPanel(), null)) {
            if (!(component instanceof JButton) || null == (buttonText = (button = (JButton)component).getText())) continue;
            if (buttonText.equals(this.saveButtonText)) {
                button.setMnemonic(this.saveButtonMnemonic);
            } else if (buttonText.equals(this.openButtonText)) {
                button.setMnemonic(this.openButtonMnemonic);
            } else if (buttonText.equals(this.cancelButtonText)) {
                button.setMnemonic(this.cancelButtonMnemonic);
            } else if (buttonText.equals(this.updateButtonText)) {
                button.setMnemonic(this.updateButtonMnemonic);
            } else if (buttonText.equals(this.helpButtonText)) {
                button.setMnemonic(this.helpButtonMnemonic);
            } else if (buttonText.equals(this.directoryOpenButtonText)) {
                button.setMnemonic(this.directoryOpenButtonMnemonic);
            }
            UCD.formatMnemonicDisplay(button);
        }
    }

    protected void setDefaultButton() {
        JDialog dialog;
        JButton approveButton = this.getApproveButton(this.getFileChooser());
        if (null != approveButton && null != (dialog = (JDialog)SwingUtilities.getWindowAncestor(this.getFileChooser()))) {
            dialog.getRootPane().setDefaultButton(approveButton);
        }
    }

    @Override
    public JButton getApproveButton(JFileChooser fc) {
        return super.getApproveButton(fc);
    }

    @Override
    public boolean isDirectorySelected() {
        return super.isDirectorySelected();
    }

    protected class IsmApproveSelectionAction
    extends BasicFileChooserUI.ApproveSelectionAction {
        private static final long serialVersionUID = 5288109023785936152L;

        protected IsmApproveSelectionAction() {
            super(IsmFileChooserUI.this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            JFileChooser chooser = IsmFileChooserUI.this.getFileChooser();
            if (chooser.getDialogType() == 1) {
                IsmFileChooserUI.this.updateApproveButton(false);
            }
        }
    }
}

