/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class IsmProgressBarUI
extends MetalProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new IsmProgressBarUI();
    }

    @Override
    public void paintDeterminate(Graphics graphics, JComponent jComponent) {
        Graphics2D g2D = null;
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        g2D = (Graphics2D)graphics;
        Insets insets = this.progressBar.getInsets();
        int largo = this.progressBar.getWidth() - (insets.left + insets.right);
        int alto = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int len = this.getAmountFull(insets, largo, alto);
        int barRectWidth = this.progressBar.getWidth() - (insets.right + insets.left);
        int barRectHeight = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int amountFull = this.getAmountFull(insets, barRectWidth, barRectHeight);
        int xi = insets.left;
        int yi = insets.top;
        int xf = xi + largo;
        int yf = yi + alto;
        int xm = xi + len - 1;
        int ym = yf - len;
        if (this.progressBar.isEnabled()) {
            if (this.progressBar.getOrientation() == 0) {
                IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.selectionGradient", new Rectangle(xi, yi, xm, yf), true);
                IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.backgroundGradient", new Rectangle(xm + 1, yi, xf, yf), true);
            } else {
                IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.selectionGradient", new Rectangle(xi, ym, xf, yf), false);
                IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.backgroundGradient", new Rectangle(xi, yi, xf, ym), false);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g2D, insets.left, insets.top, barRectWidth, barRectHeight, amountFull, insets);
            }
        }
    }

    @Override
    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        Graphics2D g2D = CommonUtil.convertObject(graphics, Graphics2D.class);
        Rectangle rec = new Rectangle();
        rec = this.getBox(rec);
        Insets insets = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (insets.right + insets.left);
        int barRectHeight = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int amountFull = this.getAmountFull(insets, barRectWidth, barRectHeight);
        int xi = insets.left;
        int yi = insets.top;
        int xf = jComponent.getWidth() - insets.right;
        int yf = jComponent.getHeight() - insets.bottom;
        if (this.progressBar.getOrientation() == 0) {
            IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.backgroundGradient", new Rectangle(xi, yi, xf, yf), true);
            IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.selectionGradient", rec, true);
        } else {
            IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.backgroundGradient", new Rectangle(xi, yi, xf, yf), false);
            IsmPlafUtils.drawGradient((Component)jComponent, (Graphics)g2D, "ProgressBar.selectionGradient", rec, false);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2D, insets.left, insets.top, barRectWidth, barRectHeight, amountFull, insets);
        }
    }
}

