/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.control.RefreshButton;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorTitleBarPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;

public class UnifyButtonUI
extends BasicButtonUI {
    private static final UnifyButtonUI UNIFY_BUTTONUI_INSTANCE = new UnifyButtonUI();

    public static ComponentUI createUI(JComponent x) {
        return UNIFY_BUTTONUI_INSTANCE;
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (!(jComponent instanceof AbstractButton)) {
            super.update(graphics, jComponent);
            return;
        }
        AbstractButton button = (AbstractButton)jComponent;
        if (jComponent.getBackground() instanceof UIResource && button.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!model.isPressed() && model.isRollover()) {
                this.paintButtonRollover(graphics, button);
            } else if (!model.isArmed() && !model.isPressed()) {
                this.paintButtonNormal(graphics, button);
            }
            this.paint(graphics, jComponent);
            return;
        }
        if (!jComponent.isEnabled()) {
            this.paintDiabledButton(graphics, button);
        }
        super.update(graphics, jComponent);
    }

    protected void paintButtonNormal(Graphics graphics, AbstractButton button) {
        this.paintContentArea(graphics, button, "IsmButton.gradientNormal");
    }

    protected void paintButtonRollover(Graphics graphics, AbstractButton button) {
        this.paintContentArea(graphics, button, "IsmButton.gradientRollover");
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton button) {
        this.setTextShiftOffset();
        if (button.getParent() instanceof ArmorTitleBarPane || button.getParent() instanceof JScrollPane || button instanceof RefreshButton) {
            return;
        }
        this.paintContentArea(graphics, button, "IsmButton.gradientPress");
    }

    protected void paintDiabledButton(Graphics graphics, AbstractButton button) {
        this.paintContentArea(graphics, button, "IsmButton.gradientDisabled");
    }

    protected Rectangle getContentBounds(AbstractButton button) {
        Rectangle size = button.getBounds();
        Insets insets = button.getInsets();
        Insets margin = button.getMargin();
        int xAxis = insets.left - margin.left;
        int yAxis = insets.top - margin.top;
        int wAxis = size.width - insets.left - insets.right + margin.left + margin.right;
        int hAxis = size.height - insets.top - insets.bottom + margin.top + margin.bottom;
        Rectangle contentBounds = new Rectangle(xAxis, yAxis, wAxis, hAxis);
        return contentBounds;
    }

    protected void paintContentArea(Graphics graphics, AbstractButton button, String gradientKey) {
        int xAxis = 0;
        int yAxis = 0;
        int width = button.getWidth();
        int height = button.getHeight();
        IsmPlafUtils.drawGradient((Component)button, graphics, gradientKey, new Rectangle(xAxis + 3, yAxis + 3, width - 6, height - 6), true);
        Color color = UIManager.getColor("IsmButton.Highlight");
        IsmPlafUtils.drawBorderStyle(graphics, color, color, new Rectangle(xAxis + 2, yAxis + 2, width - 2 - 2, height - 2 - 2), true);
        graphics.setColor(UIManager.getColor("IsmButton.BottomHighlight"));
        graphics.fillRect(xAxis + 2, yAxis + height - 3, width - 2 - 2, 1);
    }

    @Override
    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle iconRect) {
        if (jComponent.getParent() instanceof ArmorTitleBarPane) {
            iconRect.setLocation(0, (int)iconRect.getY());
        }
        super.paintIcon(graphics, jComponent, iconRect);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton button, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }
}

