/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class UnifyPopupMenuUI
extends BasicPopupMenuUI {
    public static ComponentUI createUI(JComponent c) {
        return new UnifyPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.FALSE);
    }

    @Override
    protected void uninstallDefaults() {
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.TRUE);
        super.uninstallDefaults();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Rectangle bounds = jComponent.getBounds();
        Insets insets = UIManager.getInsets("IsmPopMenuItem.inserts");
        int xx = (int)bounds.getX() + insets.left;
        int yy = (int)bounds.getY() + insets.top;
        int ww = bounds.width - (insets.left + insets.right);
        int hh = bounds.height - (insets.top + insets.bottom);
        Color background = UIManager.getColor("PopupMenu.background");
        int alpha = UIManager.getInt("PopupMenu.alpha");
        graphics.setColor(IsmPlafUtils.mixAlpha(background, alpha));
        graphics.fillRect(xx, yy, ww, hh);
    }
}

