/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexDocument
extends PlainDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexDocument.class);
    private static final long serialVersionUID = 6399790018053633024L;
    private Pattern pattern;
    private transient Matcher matcher;

    public RegexDocument() {
    }

    public RegexDocument(String regex) {
        this.initial(regex);
    }

    public static RegexDocument createNumberDocument(String regex, long min, long max, int length) {
        return new NumberDocument(regex, min, max, length);
    }

    public static RegexDocument createNumberDocument(String regex, long min, long max, int length, boolean isStartWith0) {
        return new NumberDocument(regex, min, max, length, isStartWith0);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (offs == 0 && this.getLength() > len) {
            String proposedInsert;
            try {
                proposedInsert = this.getText(len, this.getLength() - len);
            }
            catch (BadLocationException e) {
                LOGGER.error("bad location exception:", (Throwable)e);
                return;
            }
            if (null != this.matcher) {
                this.matcher.reset(proposedInsert);
                if (!this.matcher.matches()) {
                    return;
                }
            }
        }
        super.remove(offs, len);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        if (chng.getOffset() == 0) {
            String proposedInsert;
            try {
                proposedInsert = this.getText(chng.getLength(), chng.getDocument().getLength() - chng.getLength());
            }
            catch (BadLocationException e) {
                LOGGER.error("bad location exception:", (Throwable)e);
                return;
            }
            if (null != this.matcher && !proposedInsert.equals("")) {
                this.matcher.reset(proposedInsert);
                if (!this.matcher.matches()) {
                    return;
                }
            }
        }
        super.removeUpdate(chng);
    }

    @Override
    public void insertString(int offs, String newContent, AttributeSet attr) {
        if (attr == null || !attr.isDefined(StyleConstants.ComposedTextAttribute)) {
            String proposedInsert;
            try {
                proposedInsert = this.getText(0, offs) + newContent + this.getText(offs, this.getLength() - offs);
            }
            catch (BadLocationException e) {
                LOGGER.error("bad location exception:", (Throwable)e);
                return;
            }
            if (null != this.matcher) {
                this.matcher.reset(proposedInsert);
                if (!this.matcher.matches()) {
                    return;
                }
            }
        }
        try {
            super.insertString(offs, newContent, attr);
        }
        catch (BadLocationException e) {
            LOGGER.error("bad location exception:", (Throwable)e);
            return;
        }
    }

    private void initial(String regex) {
        this.pattern = Pattern.compile(regex);
        try {
            this.matcher = this.pattern.matcher(this.getText(0, this.getLength()));
            if (!this.matcher.matches()) {
                this.remove(0, this.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.error("", (Throwable)badLocationException);
        }
    }

    private static class NumberDocument
    extends RegexDocument {
        private static final Logger LOGGER = LoggerFactory.getLogger(NumberDocument.class);
        private static final long serialVersionUID = 5072806302623093760L;
        private long max;
        private long min;
        private int length;
        private boolean isStartsWith0 = false;

        public NumberDocument(String regex, long min, long max, int length) {
            super(regex);
            this.min = min;
            this.max = max;
            this.length = length;
        }

        public NumberDocument(String regex, long min, long max, int length, boolean isStartsWith0) {
            this(regex, min, max, length);
            this.isStartsWith0 = isStartsWith0;
        }

        @Override
        public void insertString(int offs, String newContent, AttributeSet attr) {
            try {
                String proposedInsert = this.getText(0, offs) + newContent + this.getText(offs, this.getLength() - offs);
                if (this.length < proposedInsert.length()) {
                    Long proposedValue = this.getTargetValue(proposedInsert);
                    if (proposedValue > this.max) {
                        this.remove(0, this.getLength());
                        super.insertString(0, String.valueOf(this.max), attr);
                    }
                    return;
                }
                if (this.length == proposedInsert.length()) {
                    Long proposedValue = this.getTargetValue(proposedInsert);
                    if (proposedInsert.startsWith("0") && !this.isStartsWith0) {
                        this.remove(0, this.getLength());
                        super.insertString(0, proposedValue.toString(), attr);
                        return;
                    }
                    if (this.max < proposedValue) {
                        proposedValue = this.max;
                        this.remove(0, this.getLength());
                        super.insertString(0, proposedValue.toString(), attr);
                        return;
                    }
                    if (this.min > proposedValue) {
                        proposedValue = this.min;
                        this.remove(0, this.getLength());
                        super.insertString(0, proposedValue.toString(), attr);
                        return;
                    }
                    super.insertString(offs, newContent, attr);
                } else {
                    Long proposedValue = this.getTargetValue(proposedInsert);
                    if (proposedInsert.startsWith("0") && !this.isStartsWith0) {
                        this.remove(0, this.getLength());
                        super.insertString(0, proposedValue.toString(), attr);
                        return;
                    }
                    super.insertString(offs, newContent, attr);
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }

        private Long getTargetValue(String proposedInsert) {
            Long proposedValue;
            try {
                proposedValue = Long.parseLong(proposedInsert);
            }
            catch (Exception e) {
                try {
                    proposedValue = Long.parseLong(this.getText(0, this.getLength()));
                }
                catch (RuntimeException ex) {
                    proposedValue = 0L;
                }
                catch (Exception ex) {
                    proposedValue = 0L;
                }
            }
            return proposedValue;
        }
    }
}

