/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text.validator;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HexInputValidator
implements InputValidator {
    private static final long serialVersionUID = 6532475855461590721L;
    private static String hexRegex = "[0-9a-fA-F]*";
    private int length = 0;

    public HexInputValidator(int length) {
        this.length = length;
    }

    @Override
    public String getToolTip() {
        return MessageFormat.format(ResourceManager.getString("textfield.value.hex.lenght.tooltip"), this.length);
    }

    @Override
    public String validateInput(String input, String inputValueName) {
        if (StringUtils.isNULLStr((String)input)) {
            return null;
        }
        if (input.trim().length() != this.length) {
            return MessageFormat.format(ResourceManager.getString("textfield.value.hex.lenght.validatetip"), inputValueName, this.length);
        }
        Pattern pattern = Pattern.compile(hexRegex);
        Matcher matcher = pattern.matcher(Normalizer.normalize(input, Normalizer.Form.NFKC));
        if (!matcher.matches()) {
            return MessageFormat.format(ResourceManager.getString("textfield.value.hex.lenght.validatetip"), inputValueName, this.length);
        }
        return null;
    }
}

