/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.action;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.widgets.action.ActionElement;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.ui.widgets.action.CfgElement;
import com.huawei.ism.util.parser.PropertiesFileParser;
import com.huawei.ism.util.parser.XmlParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ActionCfgFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionCfgFile.class);
    private ClassLoader classLoader = null;
    private ResourceBundle resource = null;
    private String fileName = null;

    protected ActionCfgFile(String fileName, ClassLoader classLoader) {
        this.fileName = fileName;
        this.classLoader = classLoader;
    }

    protected ActionCfgFile(String fileName) {
        this(fileName, ActionCfgFile.class.getClassLoader());
    }

    public List<BaseAction> getActions() {
        ArrayList<BaseAction> actions = new ArrayList<BaseAction>(0);
        XmlParser parser = XmlParser.getXmlDomParser(this.fileName, this.classLoader);
        if (null == parser) {
            throw new NullPointerException();
        }
        Element rootNode = parser.treeWalkOfOneElementNode("root");
        if (null == rootNode) {
            throw new NullPointerException();
        }
        this.loadResource(rootNode);
        Collection<Element> actionElements = parser.getChildren(rootNode, "action");
        ActionElement actionElement = null;
        BaseAction action = null;
        for (Element element : actionElements) {
            actionElement = new ActionElement(element);
            if (!actionElement.isNeedLoad()) continue;
            action = this.createAction(actionElement);
            actions.add(action);
        }
        return actions;
    }

    private BaseAction createAction(ActionElement actionElement) {
        User.Level userType;
        KeyStroke keyStroke;
        String className = actionElement.getClassName();
        BaseAction action = this.instanceAction(className);
        String actionID = actionElement.getActionID();
        action.putValue("action-id", actionID);
        String key = actionElement.getKey();
        key = key.toUpperCase(Locale.ENGLISH);
        ResourceBundle actionResource = null;
        String propertyfile = actionElement.getPropertyFile();
        if (!CfgElement.isNull(propertyfile)) {
            actionResource = new PropertiesFileParser(ResourceBundle.getBundle(propertyfile, ResourceManager.getLocale(), this.classLoader));
        }
        if (null == actionResource) {
            actionResource = this.resource;
        }
        String name = actionResource.getString(key + "_TEXT");
        action.setName(name);
        String description = actionResource.getString(key + "_DESCRIPTION");
        action.putValue("ShortDescription", description);
        try {
            ImageIcon disabledIcon;
            ImageIcon imageIcon = this.getIcon(actionResource, key + "_ICON");
            if (null != imageIcon) {
                action.putValue("SmallIcon", imageIcon);
            }
            if (null != (disabledIcon = this.getIcon(actionResource, key + "_DISABLED_ICON"))) {
                action.putValue("DisabledIcon", disabledIcon);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        int mnemonic = actionElement.getMnemonic();
        if (-1 != mnemonic) {
            action.putValue("MnemonicKey", mnemonic);
        }
        if (null != (keyStroke = actionElement.getKeyStore())) {
            action.putValue("AcceleratorKey", keyStroke);
        }
        if (null != (userType = actionElement.getUserType())) {
            action.setUserType(userType);
        }
        return action;
    }

    public ImageIcon getIcon(ResourceBundle resourceBundle, String key) {
        return ResourceManager.getImage(key);
    }

    private BaseAction instanceAction(String className) {
        try {
            Class<?> actionClass = this.classLoader.loadClass(className);
            BaseAction action = (BaseAction)actionClass.newInstance();
            return action;
        }
        catch (InstantiationException e) {
            IllegalArgumentException ex = new IllegalArgumentException("The constructor of class \"" + className + "\" is wrong!", e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException ex = new IllegalArgumentException("The class \"" + className + "\" cann't be instance!", e);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("The class \"" + className + "\" cann't be instance!", (Throwable)e);
            return new BaseAction.DisabledAction();
        }
    }

    private void loadResource(Element rootNode) {
        String propertyFile = rootNode.getAttribute("property-file");
        this.resource = new PropertiesFileParser(ResourceBundle.getBundle(propertyFile, ResourceManager.getLocale(), this.classLoader));
    }

    static class ActionCfgFileID {
        private ClassLoader classLoader = null;
        private String fileName = null;

        public ActionCfgFileID(ClassLoader classLoader, String fileName) {
            this.classLoader = classLoader;
            this.fileName = fileName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ActionCfgFileID)) {
                return false;
            }
            ActionCfgFileID other = (ActionCfgFileID)obj;
            return other.getClassLoader() == this.getClassLoader() && other.getFileName().equals(this.getFileName());
        }

        public int hashCode() {
            ClassLoader classLoaderTemp = this.getClassLoader();
            String fileNameTemp = this.getFileName();
            int hashCode = 0;
            if (null != classLoaderTemp) {
                hashCode = classLoaderTemp.hashCode();
            }
            if (null != fileNameTemp) {
                hashCode += fileNameTemp.hashCode();
            }
            return hashCode;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

