/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.propertypane;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.message.IMsgCallback;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.ui.templets.DefaultPropertyPane;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.ui.templets.TabPane;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.ui.widgets.propertypane.SingelDevicePropertyPaneAction;
import com.huawei.ism.ui.widgets.propertypane.SyncPerformanceAction;
import com.huawei.ism.ui.widgets.tree.DevicesTreeNode;
import com.huawei.ism.util.CommonUtil;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;

public class DevicesPropertyPane
extends DefaultPropertyPane {
    private static final long serialVersionUID = 3380751088045252612L;
    private static final String[] COLUMN_NAMES = new String[]{ResourceManager.getString("ALL_ARRAYS_TYPE"), ResourceManager.getString("ALL_ARRAYS_NAME"), ResourceManager.getString("ALL_ARRAYS_STATUS"), ResourceManager.getString("IP_ADDRESS"), ResourceManager.getString("ALL_ARRAYS_LOCATION"), ResourceManager.getString("COMMON.TXT.LOGIN_USER"), ResourceManager.getString("COMMON.TXT.USER_TYPE")};
    private DevicesTreeNode devicesTreeNode = null;

    public DevicesPropertyPane(DevicesTreeNode node) {
        super((String)null, COLUMN_NAMES, new int[0]);
        this.addFunctionBtns();
        this.devicesTreeNode = node;
    }

    private void addFunctionBtns() {
        StopMonitorAction stopMonitor = new StopMonitorAction();
        stopMonitor.putValue("Name", ResourceManager.getString("SYSTEM_DELETE_ARRAY_DESCRIPTION"));
        this.addButton(stopMonitor);
        stopMonitor.update();
        SyncPerformanceAction configSyn = new SyncPerformanceAction();
        configSyn.putValue("Name", ResourceManager.getString("COMMON_TXT_SYNC_CONFIG_DATA"));
        configSyn.putValue("ShortDescription", ResourceManager.getString("COMMON_TXT_SYNC_CONFIG_DATA_DETAIL"));
        this.addButton(configSyn);
        configSyn.update();
        SingelDevicePropertyPaneAction modifyDeviceAction = new SingelDevicePropertyPaneAction(ResourceManager.getString("PROPERTY"), "deviceProperty");
        this.addButton(modifyDeviceAction);
        modifyDeviceAction.update();
        SingelDevicePropertyPaneAction resetDeviceAction = new SingelDevicePropertyPaneAction(ResourceManager.getString("SYSTEM_RESET_ARRAY_DESCRIPTION"), "resetDevice");
        this.addButton(resetDeviceAction);
        resetDeviceAction.update();
        SingelDevicePropertyPaneAction poweroffDeviceAction = new SingelDevicePropertyPaneAction(ResourceManager.getString("SET_SYSTEM_POWER_OFF_DESCRIPTION"), "poweroffDevice");
        this.addButton(poweroffDeviceAction);
        poweroffDeviceAction.update();
    }

    @Override
    protected List<TableRow> getTopTableRows() {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(0);
        int deviceCount = this.devicesTreeNode.getChildCount();
        LauncherManager launcherManager = LauncherManager.getInstance();
        IsmTreeNode deviceNode = null;
        String deviceId = null;
        Launcher launcher = null;
        DefaultTableRow<String, String> rowData = null;
        DeviceContext context = null;
        String currentIp = null;
        String connIP = null;
        for (int i = 0; i < deviceCount; ++i) {
            deviceNode = (IsmTreeNode)this.devicesTreeNode.getChildAt(i);
            deviceId = deviceNode.getDeviceID();
            launcher = launcherManager.getLauncher(deviceId);
            if (launcher == null) continue;
            rowData = new DefaultTableRow<String, String>(COLUMN_NAMES.length, deviceId, deviceId);
            context = launcher.getDeviceContext();
            currentIp = context.getPreferedIP();
            connIP = context.getConnectionIP();
            if (null != connIP) {
                currentIp = connIP;
            }
            if (ProductModelType.N8000 == context.getDeviceModelType() || ProductModelType.N8300 == context.getDeviceModelType() || ProductModelType.N8500 == context.getDeviceModelType()) {
                rowData.setValueAt(0, "8350");
            } else {
                rowData.setValueAt(0, (Object)context.getDeviceModelType());
            }
            rowData.setValueAt(1, context.getDeviceName());
            rowData.setValueAt(2, context.getDeviceStatus());
            rowData.setValueAt(3, currentIp);
            rowData.setValueAt(4, context.getDeviceAddress());
            rowData.setValueAt(5, context.getCurrentUser().getUserName());
            rowData.setValueAt(6, context.getCurrentUser().getLevelDescriptor());
            tableRows.add(rowData);
        }
        return tableRows;
    }

    @Override
    protected int getTabCount(TableRow source) {
        return 0;
    }

    @Override
    protected String getTabNameAt(int tabIndex, TableRow source) {
        return null;
    }

    @Override
    protected TabPane.TabType getTabTypeAt(int tabIndex, TableRow source) {
        return null;
    }

    private final class StopMonitorCallback
    implements IMsgCallback {
        private StopMonitorCallback() {
        }

        @Override
        public void processMsgEnd(IsmMsg ismMsg) {
            Frame parent = Framework.getInstance().getMainFrame();
            Object re = ismMsg.getProperty("PROPERTY_EXCEPTION");
            if (null == re) {
                DevicesPropertyPane.this.autoUpdate();
                DialogUtils.showInfoDialog(parent);
            } else if (re instanceof Throwable) {
                DialogUtils.showErrorDialog(parent, (Throwable)re);
            }
        }
    }

    private final class StopMonitorAction
    extends PropertyPaneAction {
        private static final long serialVersionUID = 3675609245102621304L;

        private StopMonitorAction() {
        }

        @Override
        public void actionPerformed(List<Object> rowUserObject) {
            CommonUtil.stopMonitorDevice(rowUserObject.toArray(new String[rowUserObject.size()]), new StopMonitorCallback());
        }

        @Override
        protected boolean isAvailable() {
            return this.getUserObject() != null && ((List)this.getUserObject()).size() > 0;
        }

        @Override
        protected PropertyPaneAction.MenuInfo getMenuInfo() {
            return new PropertyPaneAction.MenuInfo(null, "device");
        }

        @Override
        public String getReason(List<Object> rowUserObject) {
            String reason = super.getReason(rowUserObject);
            if (reason != null) {
                return reason;
            }
            if (null == rowUserObject || rowUserObject.isEmpty()) {
                return ResourceManager.getString("NO_SELECT_OBJECT");
            }
            return null;
        }
    }

    private static final class ViewDevicePropertyAction
    extends PropertyPaneAction {
        private static final long serialVersionUID = -7044312314877141115L;

        public ViewDevicePropertyAction() {
            this.setName(ResourceManager.getString("PROPERTY"));
        }

        @Override
        public void actionPerformed(List<Object> rowUserObject) {
            if (rowUserObject.size() < 1) {
                return;
            }
            String deviceID = (String)rowUserObject.get(0);
            Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
            BaseAction<?> modifyDeviceAction = launcher.getAction("deviceProperty");
            modifyDeviceAction.actionPerformed(null);
        }

        @Override
        protected boolean isAvailable() {
            List rowUserObject = (List)this.getUserObject();
            if (rowUserObject != null && rowUserObject.size() == 1) {
                String deviceID = (String)rowUserObject.get(0);
                Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
                if (null != launcher && null != launcher.getAction("deviceProperty")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected PropertyPaneAction.MenuInfo getMenuInfo() {
            return new PropertyPaneAction.MenuInfo(true);
        }

        @Override
        public String getReason(List<Object> obj) {
            String reason = super.getReason(obj);
            if (reason != null) {
                return reason;
            }
            if (null == obj || obj.isEmpty()) {
                return ResourceManager.getString("NO_SELECT_OBJECT");
            }
            if (obj.size() > 1) {
                return ResourceManager.getString("SELECT_ONE_OBJECT_AT_MOST");
            }
            return null;
        }
    }
}

