/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.devices;

import com.huawei.ism.common.IDataChangeListener;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.UIController;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.IsmGradientPanel;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.util.SwingUIUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;

public class DevicesPane
extends ImagePanel
implements IDataChangeListener {
    private static final long serialVersionUID = 2102897110525259467L;
    private TitleBar titleBar = null;
    private StatusBar statusBar = null;
    private MainPane mainPane = null;

    public DevicesPane() {
        super(ResourceManager.getImage("mainframe_background.png"), ImagePanel.ExtendOrient.HORIZONAL_AND_VETICAL);
        this.doLayoutUI();
        UIController.getInstance().addDataChangeListener(this);
    }

    private void doLayoutUI() {
        this.titleBar = new TitleBar();
        this.statusBar = new StatusBar();
        this.mainPane = new MainPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleBar, "North");
        this.add((Component)this.mainPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    void addModule(FeatureItem featureItem) {
        this.mainPane.addModule(featureItem);
    }

    void showModule(final FeatureItem featureItem) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DevicesPane.this.mainPane.showModule(featureItem);
            }
        };
        SwingUtil.runInEventDispatchThread(runnable);
    }

    void updateModule() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DevicesPane.this.mainPane.updateModule();
                DevicesPane.this.statusBar.setDeviceAmout();
            }
        };
        SwingUtil.runInEventDispatchThread(runnable);
    }

    @Override
    public void dataChanged(IDataChangeListener.DataChangeEvent dataChangeEvent) {
        this.updateModule();
    }

    private static class ModuleGroup {
        private Map<String, ModuleComponent> moduleGroups = new HashMap<String, ModuleComponent>(0);
        private FeatureItem selection = null;

        private ModuleGroup() {
        }

        public void add(ModuleComponent moduleComponent) {
            if (null == moduleComponent) {
                return;
            }
            if (this.selection == null) {
                this.selection = moduleComponent.getFeatureItem();
                moduleComponent.setSelected(true);
            } else {
                moduleComponent.setSelected(false);
            }
            this.moduleGroups.put(moduleComponent.getFeatureItem().getName(), moduleComponent);
            moduleComponent.setModuleGroup(this);
        }

        public void setSelected(FeatureItem featureItem, boolean selected) {
            if (selected && featureItem != null && featureItem != this.selection) {
                FeatureItem oldSelection = this.selection;
                this.selection = featureItem;
                if (oldSelection != null) {
                    ModuleComponent oldModuleComponent = this.moduleGroups.get(oldSelection.getName());
                    oldModuleComponent.setSelected(false);
                }
                ModuleComponent newModuleComponent = this.moduleGroups.get(this.selection.getName());
                newModuleComponent.setSelected(true);
            }
        }

        public boolean isSelected(FeatureItem featureItem) {
            return this.selection == featureItem;
        }
    }

    private static class ModuleHandler
    extends MouseAdapter {
        private ModuleHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ModuleComponent module = (ModuleComponent)mouseEvent.getSource();
            if (module.isSelected()) {
                return;
            }
            module.getModuleGroup().setSelected(module.getFeatureItem(), true);
            Container container = SwingUtilities.getAncestorOfClass(DevicesPane.class, module);
            if (container instanceof DevicesPane) {
                DevicesPane multiDevicesPane = (DevicesPane)container;
                multiDevicesPane.showModule(module.getFeatureItem());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ModuleComponent module = (ModuleComponent)mouseEvent.getSource();
            if (!module.isSelected()) {
                module.setRollover(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ModuleComponent module = (ModuleComponent)mouseEvent.getSource();
            module.setRollover(false);
        }
    }

    private static class ModuleComponent
    extends JComponent
    implements ActionListener {
        private static final long serialVersionUID = 1992889660800024568L;
        private static final FontUIResource FONT = new FontUIResource("Dialog", 0, 14);
        private static final Color FRONT_COLOR = new Color(0x262626);
        private transient FeatureItem featureItem = null;
        private transient ModuleGroup moduleGroup = null;
        private boolean selected;
        private boolean isRollover;

        public ModuleComponent(FeatureItem featureItem) {
            this.featureItem = featureItem;
            this.setFont(FONT);
            this.setForeground(FRONT_COLOR);
            this.addMouseListener(new ModuleHandler());
            ImageIcon normalIcon = this.featureItem.getNormalIcon();
            if (normalIcon == null) {
                throw new NullPointerException("normalIcon is null.");
            }
            Dimension size = new Dimension(normalIcon.getIconWidth(), normalIcon.getIconHeight());
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FeatureItem featureItemTemp = this.getFeatureItem();
            DevicesPane devicePane = (DevicesPane)SwingUtilities.getAncestorOfClass(DevicesPane.class, this);
            devicePane.showModule(featureItemTemp);
        }

        public FeatureItem getFeatureItem() {
            return this.featureItem;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            ImageIcon icon = null;
            icon = this.selected ? this.featureItem.getSelectedIcon() : (this.isRollover ? this.featureItem.getRolloverIcon() : this.featureItem.getNormalIcon());
            if (icon != null) {
                graphics.drawImage(icon.getImage(), 0, 0, this);
            }
            FontMetrics fontMetrics = IsmPlafUtils.getFontMetrics(this, graphics);
            String name = this.featureItem.getName();
            int charWidth = fontMetrics.stringWidth(name);
            SwingUIUtil.drawString(this, graphics, name, (this.getWidth() - charWidth) / 2, this.getHeight() * 4 / 5);
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean selected) {
            this.selected = selected;
            this.repaint();
        }

        void setRollover(boolean rollover) {
            this.isRollover = rollover;
            this.repaint();
        }

        void setModuleGroup(ModuleGroup moduleGroup) {
            this.moduleGroup = moduleGroup;
        }

        ModuleGroup getModuleGroup() {
            return this.moduleGroup;
        }
    }

    private static class MainPane
    extends JPanel {
        private static final long serialVersionUID = -437294399821951155L;
        private JPanel contentPane = null;
        private JPanel navigationBar = null;
        private transient ModuleGroup moduleGroup = new ModuleGroup();
        private PropertyPane currentModulePane = null;

        public MainPane() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            ImagePanel leftEdgePane = new ImagePanel(ResourceManager.getImage("toolBar_left_background.png"));
            ImagePanel rightEdgePane = new ImagePanel(ResourceManager.getImage("toolBar_right_background.png"));
            this.navigationBar = new ImagePanel(ResourceManager.getImage("toolBar_center_background.png"), ImagePanel.ExtendOrient.HORIZONAL);
            this.navigationBar.setLayout(new BoxLayout(this.navigationBar, 0));
            this.navigationBar.setOpaque(false);
            this.navigationBar.setBorder(new EmptyBorder(0, 30, 0, 30));
            JPanel toolBar = UCD.createTransparentPane(new BorderLayout());
            toolBar.add((Component)leftEdgePane, "West");
            toolBar.add((Component)this.navigationBar, "Center");
            toolBar.add((Component)rightEdgePane, "East");
            toolBar.setPreferredSize(new Dimension(0, 80));
            this.contentPane = new JPanel(new BorderLayout());
            this.setLayout(new BorderLayout());
            this.add((Component)toolBar, "North");
            this.add((Component)this.contentPane, "Center");
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(0, 0, 1, 0));
        }

        void addModule(FeatureItem featureItem) {
            ModuleComponent moduleComponent = new ModuleComponent(featureItem);
            this.moduleGroup.add(moduleComponent);
            this.navigationBar.add(moduleComponent);
        }

        void showModule(FeatureItem featureItem) {
            this.contentPane.removeAll();
            PropertyPane oldCurrentPane = this.currentModulePane;
            this.currentModulePane = featureItem.getPropertyPane();
            this.contentPane.add((Component)this.currentModulePane, "Center");
            this.contentPane.revalidate();
            this.contentPane.repaint();
            if (null != oldCurrentPane) {
                oldCurrentPane.stopDisplay();
            }
            this.currentModulePane.clickToUpdate();
        }

        void updateModule() {
            this.currentModulePane.autoUpdate();
        }
    }

    private static class StatusBar
    extends IsmGradientPanel {
        private static final long serialVersionUID = -5305951094985875188L;
        private JLabel deviceAmoutJLabel = new JLabel();

        public StatusBar() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            JLabel deviceAmoutKeyLabel = new JLabel(ResourceManager.getStringWithColon("DEVICESPANE.SYSTEM.AMOUNT"));
            this.setLayout(new BoxLayout(this, 0));
            this.add(deviceAmoutKeyLabel);
            this.add(Box.createHorizontalStrut(4));
            this.add(this.deviceAmoutJLabel);
            this.add(Box.createHorizontalGlue());
            this.setPreferredSize(new Dimension(0, 30));
            this.setBorder(new EmptyBorder(0, 15, 0, 15));
        }

        @Override
        public Image getBackgroudImage() {
            return ResourceManager.getImage("statusBar_background.png").getImage();
        }

        void setDeviceAmout() {
            int amout = LauncherManager.getInstance().getAllLauncher().size();
            this.deviceAmoutJLabel.setText("" + amout);
        }
    }

    private static class TitleBar
    extends JPanel {
        private static final long serialVersionUID = -6171094787467302588L;

        public TitleBar() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            JLabel titleLabel = new JLabel("OceanSpance ISM");
            titleLabel.setForeground(Color.WHITE);
            titleLabel.setFont(new Font("Dialog", 1, 14));
            this.setLayout(new BoxLayout(this, 0));
            this.add(titleLabel);
            this.add(Box.createHorizontalGlue());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(0, 30));
            this.setBorder(new EmptyBorder(0, 15, 0, 15));
        }
    }
}

