/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.BatchExecutionException;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.excel.CsvUtils;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.event.EventManagerListener;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.ui2.mainframe.device.FeatureModulePane;
import com.huawei.ism.ui2.module.event.EventDetail;
import com.huawei.ism.ui2.module.event.EventManagerLayout;
import com.huawei.ism.ui2.module.event.EventTabLayout;
import com.huawei.ism.ui2.module.event.EventTablePopupMenuGenerator;
import com.huawei.ism.ui2.module.event.FaultTabLayout;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerPanel
extends FeatureModulePane
implements EventManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManagerPanel.class);
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_LEVEL = new Pair<String, String>("COMBOBOX_ITEM_ALL_LEVEL", ResourceManager.getString("EVENT_ALL_LEVEL"));
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_SOURCE = new Pair<String, String>("COMBOBOX_ITEM_ALL_SOURCE", ResourceManager.getString("EVENT_ALL_SOURCE"));
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_DEVICE = new Pair<String, String>("COMBOBOX_ITEM_ALL_DEVICE", ResourceManager.getString("EVENT_ALL_DEVICE"));
    static final Pair<?, ?> COMBOBOX_ITEM_SELECT_SOURCE = new Pair<String, String>("COMBOBOX_ITEM_SELECT_SOURCE", ResourceManager.getString("EVENT_SELECT_SOURCE"));
    static final Pair<?, ?> COMBOBOX_ITEM_SELECT_DEVICE = new Pair<String, String>("COMBOBOX_ITEM_SELECT_DEVICE", ResourceManager.getString("EVENT_SELECT_DEVICE"));
    private static final long serialVersionUID = 1L;
    private final String deviceID;
    private Window parent = null;
    private EventManagerLayout layout;
    private Map<String, Set<String>> deviceIDMap = new HashMap<String, Set<String>>(0);
    private Map<String, String> deviceNameMap = new HashMap<String, String>(0);

    public EventManagerPanel(String deviceID) {
        super(deviceID);
        this.deviceID = deviceID;
        this.parent = Framework.getInstance().getMainFrame();
        this.layout = new EventManagerLayout();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.setBorder(null);
        this.setOpaque(false);
        this.initFilterComponents();
        this.initListeners();
        this.updateButtonState();
        this.sortTime();
    }

    @Override
    public String getHelpKey() {
        return "event_manage";
    }

    public void setFilter(Event.Level level) {
        JComboBox levelComboBox = this.layout.getFaultLayout().getLevelComboBox();
        if (null == level || !level.isFault()) {
            levelComboBox.setSelectedIndex(0);
        } else {
            int size = levelComboBox.getItemCount();
            Pair item = null;
            for (int i = 0; i < size; ++i) {
                item = (Pair)levelComboBox.getItemAt(i);
                if (!level.equals(item.getKey())) continue;
                levelComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.updateButtonState();
    }

    public void remvoeAllTableEvent() {
        if (null != this.layout.getFaultTableModel()) {
            this.layout.getFaultTableModel().removeAll();
        }
        if (null != this.layout.getEventTableModel()) {
            this.layout.getEventTableModel().removeAll();
        }
    }

    public void synWithEventCache() {
        this.layout.getFaultTableModel().removeAll();
        this.fireFaultEventsAdded(EventManager.getInstance().getAllEvents());
        List<String> sourceIDs = EventManager.getInstance().getSourceIDs();
        this.deviceIDMap.clear();
        this.fireSourceAdded(sourceIDs.toArray(new String[sourceIDs.size()]));
    }

    private void initListeners() {
        ListenerProxy allEventproxy = new ListenerProxy(this.layout.getEventTable(), this.layout.getAllEventDetail());
        ListenerProxy currentEventproxy = new ListenerProxy(this.layout.getFaultTable(), this.layout.getCurrentEventDetail());
        allEventproxy.showEventDetail();
        currentEventproxy.showEventDetail();
        this.layout.getEventTable().addListSelectionListener(allEventproxy);
        this.layout.getFaultTable().addListSelectionListener(currentEventproxy);
        EventTablePopupMenuGenerator.EventTablePopupMenus allEventPopupMenuAdapter = new EventTablePopupMenuGenerator.EventTablePopupMenus(this.deviceID, this.getSaveMarkedAlarmActionListener());
        EventTablePopupMenuGenerator.FaultTablePopupMenus currentEventPopupMenuAdapter = new EventTablePopupMenuGenerator.FaultTablePopupMenus(this.deviceID, this.getSaveMarkedAlarmActionListener(), this.getClearActionListener());
        this.layout.getEventTable().addMouseListener(allEventPopupMenuAdapter.createEventPopupMenuAdapter());
        this.layout.getFaultTable().addMouseListener(currentEventPopupMenuAdapter.createEventPopupMenuAdapter());
        this.layout.getFaultLayout().getRefreshButton().addActionListener(this.getRefreshActionListener());
        this.layout.getEventLayout().getRefreshButton().addActionListener(this.getAllEventRefreshActionListener());
        this.layout.getFaultLayout().getClearButton().addActionListener(this.getClearActionListener());
        this.layout.getFaultLayout().getSaveButton().addActionListener(this.getSaveMarkedAlarmActionListener());
        this.layout.getEventLayout().getSaveButton().addActionListener(this.getSaveMarkedAlarmActionListener());
        this.layout.getEventTabbedPane().addChangeListener(this.getEventTabbedListener());
        this.initFilterActions();
    }

    private void initFilterComponents() {
        this.layout.getFaultLayout().getLevelComboBox().addItem(COMBOBOX_ITEM_ALL_LEVEL);
        this.layout.getEventLayout().getLevelComboBox().addItem(COMBOBOX_ITEM_ALL_LEVEL);
        this.layout.getFaultLayout().getDeviceComboBox().addItem(COMBOBOX_ITEM_ALL_DEVICE);
        this.layout.getEventLayout().getDeviceComboBox().addItem(COMBOBOX_ITEM_ALL_DEVICE);
        Pair<Event.Level, Event.Level> levelItem = null;
        for (Event.Level level : Event.Level.values()) {
            levelItem = new Pair<Event.Level, Event.Level>(level, level);
            if (level.isFault()) {
                this.layout.getFaultLayout().getLevelComboBox().addItem(levelItem);
            }
            this.layout.getEventLayout().getLevelComboBox().addItem(levelItem);
        }
        this.firreArrayAdded(this.deviceID);
    }

    public void firreArrayAdded(String deviceIdentifer) {
        Launcher launcher;
        String arrayName = EventManagerPanel.getDeviceName(deviceIdentifer);
        if (!this.isDeviceExist(deviceIdentifer) || !this.deviceNameMap.get(deviceIdentifer).equals(arrayName)) {
            Pair<String, String> arrayItem = new Pair<String, String>(deviceIdentifer, arrayName);
            Pair<String, String> oldarrayItem = new Pair<String, String>(deviceIdentifer, this.deviceNameMap.get(deviceIdentifer));
            this.layout.getEventLayout().getDeviceComboBox().removeItem(oldarrayItem);
            this.layout.getFaultLayout().getDeviceComboBox().removeItem(oldarrayItem);
            this.layout.getEventLayout().getDeviceComboBox().addItem(arrayItem);
            this.layout.getFaultLayout().getDeviceComboBox().addItem(arrayItem);
        }
        if (null != (launcher = CommonUtil.getLauncher(deviceIdentifer))) {
            List<String> subDeviceIDs = this.getSubDeviceIDs(launcher);
            String subDeviceName = null;
            Pair<String, String> subDeviceItem = null;
            int eventLayoutIndex = 0;
            int faultLayoutIndex = 0;
            for (String subDeviceID : subDeviceIDs) {
                subDeviceName = EventManagerPanel.getDeviceName(subDeviceID);
                subDeviceItem = new Pair<String, String>(subDeviceID, subDeviceName);
                if (this.isDeviceExist(subDeviceID)) {
                    eventLayoutIndex = this.layout.getEventLayout().getDeviceComboBox().getSelectedIndex();
                    faultLayoutIndex = this.layout.getFaultLayout().getDeviceComboBox().getSelectedIndex();
                    this.layout.getEventLayout().getDeviceComboBox().removeItem(subDeviceItem);
                    this.layout.getFaultLayout().getDeviceComboBox().removeItem(subDeviceItem);
                    this.layout.getEventLayout().getDeviceComboBox().addItem(subDeviceItem);
                    this.layout.getFaultLayout().getDeviceComboBox().addItem(subDeviceItem);
                    this.layout.getFaultLayout().getDeviceComboBox().setSelectedIndex(faultLayoutIndex);
                    this.layout.getEventLayout().getDeviceComboBox().setSelectedIndex(eventLayoutIndex);
                    continue;
                }
                this.layout.getEventLayout().getDeviceComboBox().addItem(subDeviceItem);
                this.layout.getFaultLayout().getDeviceComboBox().addItem(subDeviceItem);
            }
        }
    }

    private List<String> getSubDeviceIDs(Launcher launcher) {
        List<String> subDeviceIDs = launcher.getSubDeviceIDs();
        if (CommonUtil.isNullList(subDeviceIDs)) {
            ArrayList<String> returnSubDeviceIDs = new ArrayList<String>(0);
            Collection<Launcher> subLaunchers = launcher.getSubLaunchers();
            if (null != subLaunchers) {
                for (Launcher subLauncher : subLaunchers) {
                    returnSubDeviceIDs.add(subLauncher.getDeviceID());
                }
            }
            return returnSubDeviceIDs;
        }
        return subDeviceIDs;
    }

    private boolean isDeviceExist(String deviceIdentifer) {
        boolean hasDevice = true;
        if (!this.deviceIDMap.containsKey(deviceIdentifer)) {
            String arrayName = EventManagerPanel.getDeviceName(deviceIdentifer);
            this.deviceIDMap.put(deviceIdentifer, new HashSet(0));
            this.deviceNameMap.put(deviceIdentifer, arrayName);
            hasDevice = false;
        }
        return hasDevice;
    }

    private ActionListener getClearFaultFilterAction(FaultTabLayout faultTab) {
        MyClearFaultListner listener = new MyClearFaultListner(faultTab);
        return listener;
    }

    private ActionListener getClearEventFilterAction(EventTabLayout eventTab) {
        MyCustClearEventListner listener = new MyCustClearEventListner(eventTab);
        return listener;
    }

    private ChangeListener getKeywordFilterChangeListener() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EventManagerPanel.this.updateClearFilterButtonState();
            }
        };
        return listener;
    }

    private ItemListener getEventLevelListener(final EventTabLayout eventTab) {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    eventTab.getKeywordFilter().updateFilter();
                }
            }
        };
        return listener;
    }

    private ItemListener getFaultLevelListener(final FaultTabLayout faultTab) {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    faultTab.getKeywordFilter().updateFilter();
                }
            }
        };
        return listener;
    }

    private ItemListener getFaultDeviceItemListener(final FaultTabLayout faultTab) {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    faultTab.getKeywordFilter().updateFilter();
                }
            }
        };
        return listener;
    }

    private ItemListener getEventDeviceItemListener(final EventTabLayout eventTab) {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EventManagerPanel.this.updateClearFilterButtonState();
                    eventTab.getKeywordFilter().updateFilter();
                }
            }
        };
        return listener;
    }

    private void initFilterActions() {
        FaultTabLayout faultTab = this.layout.getFaultLayout();
        EventTabLayout eventTab = this.layout.getEventLayout();
        faultTab.getClearFilterButton().addActionListener(this.getClearFaultFilterAction(faultTab));
        eventTab.getClearFilterButton().addActionListener(this.getClearEventFilterAction(eventTab));
        faultTab.getKeywordFilter().addChangeListener(this.getKeywordFilterChangeListener());
        eventTab.getKeywordFilter().addChangeListener(this.getKeywordFilterChangeListener());
        eventTab.getLevelComboBox().addItemListener(this.getEventLevelListener(eventTab));
        faultTab.getLevelComboBox().addItemListener(this.getFaultLevelListener(faultTab));
        faultTab.getDeviceComboBox().addItemListener(this.getFaultDeviceItemListener(faultTab));
        eventTab.getDeviceComboBox().addItemListener(this.getEventDeviceItemListener(eventTab));
        ComboBoxModel faultDeviceModel = faultTab.getDeviceComboBox().getModel();
        ComboBoxModel faultLevelModel = faultTab.getLevelComboBox().getModel();
        faultTab.getKeywordFilter().setExtFilter(new DeviceAndLevelFilter(faultDeviceModel, faultLevelModel));
        ComboBoxModel eventLevelModel = eventTab.getLevelComboBox().getModel();
        ComboBoxModel eventDeviceModel = eventTab.getDeviceComboBox().getModel();
        eventTab.getKeywordFilter().setExtFilter(new DeviceAndLevelFilter(eventDeviceModel, eventLevelModel));
    }

    private void updateClearFilterButtonState() {
        FaultTabLayout faultTab = this.layout.getFaultLayout();
        EventTabLayout eventTab = this.layout.getEventLayout();
        boolean isEnabled = false;
        isEnabled |= faultTab.getKeywordFilter().getKeyword().length() > 0;
        isEnabled |= faultTab.getLevelComboBox().getSelectedIndex() > 0;
        faultTab.getClearFilterButton().setEnabled(isEnabled |= faultTab.getDeviceComboBox().getSelectedIndex() > 0);
        isEnabled = false;
        isEnabled |= eventTab.getKeywordFilter().getKeyword().length() > 0;
        isEnabled |= eventTab.getLevelComboBox().getSelectedIndex() > 0;
        eventTab.getClearFilterButton().setEnabled(isEnabled |= eventTab.getDeviceComboBox().getSelectedIndex() > 0);
    }

    private ActionListener getRefreshActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventManagerPanel.this.firreArrayAdded(EventManagerPanel.this.getDeviceID());
                EventTaskRequester.doRefreshFaultEventsTask(EventManagerPanel.this.parent, EventManagerPanel.this.getSelectedSourceID());
                String dateNowStr = TimeUtil.gmtToString(new Date().getTime(), LauncherManager.getInstance().getLauncher(EventManagerPanel.this.getDeviceID()).getDeviceTimeZone());
                String head = ResourceManager.getStringWithColon("LAST_REFRESH_TIME") + ' ';
                EventManagerPanel.this.layout.getFaultLayout().getRefreshButton().setToolTipText(head + dateNowStr);
            }
        };
    }

    private ActionListener getAllEventRefreshActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventManagerPanel.this.firreArrayAdded(EventManagerPanel.this.getDeviceID());
                EventTaskRequester.doRefreshAllDevicesEventsTask(EventManagerPanel.this.parent, EventManagerPanel.this.getSelectedSourceID());
                EventManagerPanel.this.sortTime();
                String dateNowStr = TimeUtil.gmtToString(new Date().getTime(), LauncherManager.getInstance().getLauncher(EventManagerPanel.this.getDeviceID()).getDeviceTimeZone());
                String head = ResourceManager.getStringWithColon("LAST_REFRESH_TIME") + ' ';
                EventManagerPanel.this.layout.getEventLayout().getRefreshButton().setToolTipText(head + dateNowStr);
            }
        };
    }

    private PropertyPaneAction getClearActionListener() {
        return new PropertyPaneAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(List<Object> rowUserObject) {
                String desc = ResourceManager.getString("ALARM_CLEAR_DESC");
                String result = ResourceManager.getString("ALARM_CLEAR_SUGGESTION");
                if (ConfirmDialog.showDialog(EventManagerPanel.this.parent, ConfirmDialog.Level.INFO, desc, result, "", "")) {
                    List toBeClearedEvents = EventManagerPanel.this.getMarkedEvent();
                    EventTaskRequester.doClearFaultTask(EventManagerPanel.this.parent, toBeClearedEvents);
                    EventTaskRequester.doRefreshFaultEventsTask(EventManagerPanel.this.parent, EventManagerPanel.this.getSelectedSourceID());
                }
            }

            @Override
            protected PropertyPaneAction.MenuInfo getMenuInfo() {
                return new PropertyPaneAction.MenuInfo(null, "clearCurrentEvent");
            }

            @Override
            protected boolean isAvailable() {
                List rowUserObject = (List)this.getUserObject();
                if (EventManagerPanel.this.isReadonlyUser()) {
                    return false;
                }
                if (null == rowUserObject || rowUserObject.isEmpty()) {
                    return false;
                }
                return super.isAvailable();
            }
        };
    }

    private PropertyPaneAction getSaveMarkedAlarmActionListener() {
        PropertyPaneAction saveMarkedAlarmAction = new PropertyPaneAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(List<Object> rowUserObject) {
                List markedEvents = EventManagerPanel.this.getMarkedEvent();
                EventTaskRequester.doSaveMarkedEventTask(EventManagerPanel.this.parent, markedEvents, EventManagerPanel.this.isFaultTabSelected());
            }

            @Override
            protected PropertyPaneAction.MenuInfo getMenuInfo() {
                return new PropertyPaneAction.MenuInfo(null, "sava");
            }

            @Override
            protected boolean isAvailable() {
                List rowUserObject = (List)this.getUserObject();
                if (null == rowUserObject || rowUserObject.isEmpty()) {
                    return false;
                }
                return super.isAvailable();
            }

            @Override
            public String getReason(List<Object> rowUserObject) {
                return null;
            }
        };
        saveMarkedAlarmAction.setDeviceID(this.deviceID);
        return saveMarkedAlarmAction;
    }

    private ChangeListener getEventTabbedListener() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EventManagerPanel.this.firreArrayAdded(EventManagerPanel.this.deviceID);
                if (EventManagerPanel.this.isFaultTabSelected()) {
                    EventTaskRequester.doRefreshAllDevicesEventsTask(EventManagerPanel.this.parent, EventManagerPanel.this.getSelectedSourceID());
                }
                EventManagerPanel.this.updateButtonState();
            }
        };
        return listener;
    }

    @Override
    public void fireFaultCleared(Collection<Event> events, Map<Event.Identifier, Long> failedMap) {
        ArrayList<TableRow<Event, Event.Identifier>> tableRows = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        TimeZone zone = null;
        TableRow<Event, Event.Identifier> tableRow = null;
        for (Event event : events) {
            if (failedMap.containsKey(event.getIdentifier())) continue;
            zone = Framework.getDeviceTimeZone(event.getIdentifier().getDeviceID());
            tableRow = this.convertFaultRow(event, zone);
            tableRows.add(tableRow);
        }
        this.handlerDetailPane(this.layout.getFaultTable(), this.layout.getCurrentEventDetail());
    }

    public void fireClearAllEvents() {
        this.layout.getEventTableModel().removeAll();
        this.handlerDetailPane(this.layout.getEventTable(), this.layout.getAllEventDetail());
    }

    @Override
    public void fireFaultEventsAdded(Collection<Event> events) {
        ArrayList<TableRow<Event, Event.Identifier>> faultToBeAdded = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        TimeZone zone = null;
        for (Event event : events) {
            if (!event.getLevel().isFault() || event.isRecovered()) continue;
            zone = Framework.getDeviceTimeZone(event.getIdentifier().getDeviceID());
            faultToBeAdded.add(this.convertFaultRow(event, zone));
        }
        this.layout.getFaultTableModel().addRow(faultToBeAdded.toArray(new TableRow[faultToBeAdded.size()]));
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
        this.handlerDetailPane(this.layout.getFaultTable(), this.layout.getCurrentEventDetail());
    }

    private void handlerDetailPane(IsmTable eventTable, EventDetail eventDetailPane) {
        if (Utils.isNullList(eventTable.getAllRows())) {
            eventDetailPane.showMainPanel(false, ResourceManager.getString("event.no.data.detail.info.desc"));
            return;
        }
        if (Utils.isNullList(eventTable.getMarkedRows())) {
            eventDetailPane.showMainPanel(false, ResourceManager.getString("event.more.data.detail.info.desc"));
            return;
        }
    }

    @Override
    public void fireEventsAdded(List<Event> events) {
        this.fireClearAllEvents();
        TimeZone zone = null;
        ArrayList<TableRow<Event, Event.Identifier>> rowList = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        for (Event event : events) {
            zone = Framework.getDeviceTimeZone(event.getIdentifier().getDeviceID());
            rowList.add(this.convertEventRow(event, zone));
        }
        this.layout.getEventTableModel().addRow(rowList.toArray(new TableRow[rowList.size()]));
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
        this.handlerDetailPane(this.layout.getEventTable(), this.layout.getAllEventDetail());
    }

    private void setFilter(JComboBox levelbox) {
        Pair levelFilter = (Pair)levelbox.getModel().getSelectedItem();
        if (null != levelFilter && levelFilter != COMBOBOX_ITEM_ALL_LEVEL) {
            Event.Level eventLevel = (Event.Level)((Object)levelFilter.getKey());
            this.setFilter(eventLevel);
        }
    }

    @Override
    public void fireFaultEventUpdated(Collection<Event> events) {
        TimeZone zon = null;
        for (Event event : events) {
            if (!event.getLevel().isFault()) continue;
            zon = Framework.getDeviceTimeZone(event.getIdentifier().getDeviceID());
            if (!event.isRecovered()) {
                this.layout.getFaultTableModel().updateRow(this.convertFaultRow(event, zon));
                continue;
            }
            this.layout.getFaultTableModel().removeRow(this.convertFaultRow(event, zon));
        }
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
    }

    @Override
    public void fireFaultEventRemoved(Collection<Event> events) {
        ArrayList<DefaultTableRow<Event, Event.Identifier>> faultToBeRemoved = new ArrayList<DefaultTableRow<Event, Event.Identifier>>(0);
        DefaultTableRow<Event, Event.Identifier> row = null;
        for (Event event : events) {
            row = new DefaultTableRow<Event, Event.Identifier>(1, event, event.getIdentifier());
            if (!event.getLevel().isFault() || event.isRecovered()) continue;
            faultToBeRemoved.add(row);
        }
        this.layout.getFaultTableModel().removeRow(faultToBeRemoved.toArray(new TableRow[faultToBeRemoved.size()]));
        this.setFilter(this.layout.getFaultLayout().getLevelComboBox());
    }

    private boolean isReadonlyUser() {
        Launcher launcher = LauncherManager.getInstance().getLauncher(this.deviceID);
        if (null == launcher) {
            return false;
        }
        User user = launcher.getDeviceContext().getCurrentUser();
        User.Level currentlevel = user.getLevel();
        return null != User.Level.Admin && null != currentlevel && currentlevel.getValue() > User.Level.Admin.getValue();
    }

    private void updateButtonState() {
        int markedFaultCount = this.layout.getFaultTable().getSelectedRowCount();
        this.layout.getFaultLayout().getClearButton().setEnabled(markedFaultCount > 0);
        if (this.isReadonlyUser()) {
            this.layout.getFaultLayout().getClearButton().setEnabled(false);
        }
        this.layout.getFaultLayout().getSaveButton().setEnabled(markedFaultCount > 0);
        int markedEventCount = this.layout.getEventTable().getSelectedRowCount();
        this.layout.getEventLayout().getSaveButton().setEnabled(markedEventCount > 0);
    }

    private TableRow<Event, Event.Identifier> convertFaultRow(Event event, TimeZone zone) {
        if (null == event) {
            return null;
        }
        int columnCount = EventManagerLayout.getFaultColumnName().length;
        TableRow<Event, Event.Identifier> row = this.getTableRow(event, zone, columnCount);
        return row;
    }

    private TableRow<Event, Event.Identifier> convertEventRow(Event event, TimeZone zone) {
        if (null == event) {
            return null;
        }
        int columnCount = EventManagerLayout.getEventColumnName().length;
        TableRow<Event, Event.Identifier> row = this.getTableRow(event, zone, columnCount);
        String recoverTime = event.isRecovered() ? TimeUtil.gmtToString(EventManager.getInstance().getEventTime(event, false), zone) : "";
        row.setValueAt(5, recoverTime);
        return row;
    }

    private TableRow<Event, Event.Identifier> getTableRow(Event event, TimeZone zone, int columnCount) {
        DefaultTableRow<Event, Event.Identifier> row = new DefaultTableRow<Event, Event.Identifier>(columnCount, event, event.getIdentifier());
        row.setValueAt(0, SwingUtil.getLevelCell(event.getLevel()));
        row.setValueAt(1, CommonUtil.getDeviceName(event.getIdentifier().getDeviceID()));
        row.setValueAt(2, "0x" + Long.toHexString(event.getEventID()).toUpperCase(ResourceManager.getLocale()));
        row.setValueAt(3, event.getDescription());
        row.setValueAt(4, new IsmTableCell.EventTimeCell(event, zone));
        return row;
    }

    private static String getDeviceName(String deviceID) {
        return CommonUtil.getDeviceName(deviceID);
    }

    private List<Event> getMarkedEvent() {
        ArrayList<Event> events = new ArrayList<Event>(0);
        IsmTable model = null;
        model = this.isFaultTabSelected() ? this.layout.getFaultTable() : this.layout.getEventTable();
        List<TableRow> rows = model.getMarkedRows();
        for (TableRow row : rows) {
            events.add((Event)row.getUserObject());
        }
        return events;
    }

    private List<String> getSelectedSourceID() {
        ArrayList<String> deviceIDs = new ArrayList<String>(0);
        deviceIDs.add(this.getDeviceID());
        deviceIDs.addAll(this.getArraySubDeviceIDs(this.getDeviceID()));
        return deviceIDs;
    }

    private boolean isFaultTabSelected() {
        return this.layout.getEventTabbedPane().getSelectedIndex() == 0;
    }

    public void sortTime() {
        this.layout.getFaultTable().getRowSorter().toggleSortOrder(3);
        this.layout.getEventTable().getRowSorter().toggleSortOrder(3);
        this.layout.getFaultTable().getRowSorter().toggleSortOrder(3);
        this.layout.getEventTable().getRowSorter().toggleSortOrder(3);
    }

    private List<String> getArraySubDeviceIDs(String deviceIdentifer) {
        ArrayList<String> subDeviceIDs = new ArrayList<String>(0);
        Launcher launcher = CommonUtil.getLauncher(deviceIdentifer);
        if (null != launcher) {
            subDeviceIDs.addAll(this.getSubDeviceIDs(launcher));
        }
        return subDeviceIDs;
    }

    public void clickEventIcon(Event.Level level) {
        this.setFilter(level);
        if (this.layout.getEventTabbedPane().getSelectedIndex() == 1) {
            this.layout.getEventTabbedPane().setSelectedIndex(0);
        }
        this.filterUpdateBy(level);
    }

    public void filterUpdateBy(Event.Level level) {
        EventManager.getInstance().addEventManagerListenerWithCheckDup(this);
        EventTaskRequester.doRefreshFaultEventsTask(this.parent, this.getSelectedSourceID());
        this.setFilter(level);
        this.firreArrayAdded(this.deviceID);
    }

    @Override
    public void clickToUpdate() {
        this.filterUpdateBy(null);
    }

    @Override
    public void fireSourceAdded(String ... sourceIDs) {
    }

    @Override
    public void fireSourceRemoved(String ... deviceIDs) {
    }

    private static class DeviceAndLevelFilter
    extends RowFilter<TableModel, Integer> {
        private ComboBoxModel sourceComboBoxModel;
        private ComboBoxModel levelComboBoxModel;

        public DeviceAndLevelFilter(ComboBoxModel sourceModel, ComboBoxModel levelModel) {
            this.sourceComboBoxModel = sourceModel;
            this.levelComboBoxModel = levelModel;
        }

        public DeviceAndLevelFilter(ComboBoxModel levelModel) {
            this.levelComboBoxModel = levelModel;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> value) {
            Pair sourceFilter;
            DefaultTableModel model = (DefaultTableModel)value.getModel();
            int rowIndex = value.getIdentifier();
            TableRow row = model.getRow(rowIndex);
            Event event = (Event)row.getUserObject();
            if (null != this.sourceComboBoxModel && null != (sourceFilter = (Pair)this.sourceComboBoxModel.getSelectedItem()) && !this.filter(event, sourceFilter)) {
                return false;
            }
            Pair levelFilter = (Pair)this.levelComboBoxModel.getSelectedItem();
            if (null != levelFilter && levelFilter != COMBOBOX_ITEM_ALL_LEVEL) {
                Event.Level eventLevel = (Event.Level)((Object)levelFilter.getKey());
                if (event.getLevel() != eventLevel) {
                    return false;
                }
            }
            return true;
        }

        private boolean filter(Event event, Pair<?, ?> sourceFilter) {
            if (sourceFilter != COMBOBOX_ITEM_ALL_DEVICE) {
                String sourceID = sourceFilter.getKey().toString();
                if (!event.getIdentifier().getDeviceID().equals(sourceID)) {
                    return false;
                }
            } else {
                int len = this.sourceComboBoxModel.getSize();
                boolean isInclude = this.isInclude(event, len);
                if (!isInclude) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInclude(Event event, int len) {
            String sourceID = null;
            boolean isInclude = false;
            Pair sf = null;
            for (int i = 1; i < len; ++i) {
                sf = (Pair)this.sourceComboBoxModel.getElementAt(i);
                sourceID = sf.getKey().toString();
                if (!event.getIdentifier().getDeviceID().equals(sourceID)) continue;
                isInclude = true;
                break;
            }
            return isInclude;
        }
    }

    private static abstract class EventTaskRequester {
        private EventTaskRequester() {
        }

        public static void doClearFaultTask(Window eventManageDialog, List<Event> toBeClearedEvents) {
            List<?> failedMapList = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createClearFaultTask(toBeClearedEvents));
            EventTaskRequester.handleClearFaultResult(eventManageDialog, toBeClearedEvents, failedMapList);
        }

        public static void doRefreshFaultEventsTask(Window eventManageDialog, List<String> deviceIDs) {
            List<?> results = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createRefreshFaultEventsTask(deviceIDs));
            EventTaskRequester.handleExcuteResult(eventManageDialog, results);
        }

        public static void doRefreshAllEventsTask(Window eventManageDialog, String deviceID) {
            List<?> results = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createRefreshAllEventsTask(deviceID));
            EventTaskRequester.handleExcuteResult(eventManageDialog, results);
        }

        public static void doRefreshAllDevicesEventsTask(Window eventManageDialog, List<String> deviceIDs) {
            List<?> results = AsyncExcutor.execute(eventManageDialog, EventTaskRequester.createRefreshAllDevicesEventsTask(deviceIDs));
            EventTaskRequester.handleExcuteResult(eventManageDialog, results);
        }

        private static Callable createRefreshAllEventsTask(final String deviceID) {
            return new Callable(){

                public Object call() {
                    Thread.currentThread().setName("Refresh all faults");
                    try {
                        EventManager.getInstance().refreshAllEvents(deviceID);
                    }
                    catch (Exception e) {
                        return e;
                    }
                    return "";
                }
            };
        }

        private static Callable createRefreshAllDevicesEventsTask(final List<String> deviceIDs) {
            return new Callable(){

                public Object call() {
                    Thread.currentThread().setName("Refresh all devices faults");
                    try {
                        EventManager.getInstance().refreshAllDevicesEvents(deviceIDs);
                    }
                    catch (Exception e) {
                        return e;
                    }
                    return "";
                }
            };
        }

        public static void doSaveAllEventTask(JDialog eventManageDialog, List<Event> events) {
            EventTaskRequester.doSaveMarkedEventTask(eventManageDialog, events, false);
        }

        public static void doSaveMarkedEventTask(Window eventManageDialog, List<Event> markedEvents, boolean saveFualt) {
            int option;
            if (null == markedEvents || markedEvents.isEmpty()) {
                return;
            }
            IsmFileChooser chooser = new IsmFileChooser(ResourceManager.getString("ALARM_SAVE_TITLE"));
            if (!saveFualt) {
                chooser.setDialogTitle(ResourceManager.getString("EVENT_SAVE_TITLE"));
            }
            chooser.setName("ISMV1R2_platform_AlarmInterfaceImpl_chooser");
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addFileFilter(new String[]{ResourceManager.getString("ALARM_EXPORT_TYPE_CSV")}, ResourceManager.getString("ALARM_EXPORT_CSV"));
            SimpleDateFormat date = new SimpleDateFormat("yyyyMMddHHmmss");
            String time = date.format(new Date());
            chooser.setSelectedFile(new File(ResourceManager.getString("CONFIG.ALARM.RESTORE.EVENT.MESSAGE") + time));
            String charSet = "UTF-8";
            if (ResourceManager.getLocale().getLanguage().contains("zh")) {
                charSet = "GBK";
            }
            if ((option = chooser.showSaveDialog(eventManageDialog)) == 0) {
                File aFile = chooser.getSelectedFile();
                String name = aFile.getName();
                String tmp = EventTaskRequester.getFilePath(aFile);
                String dir = tmp.substring(0, tmp.lastIndexOf(name));
                String filetype = '.' + ResourceManager.getString("ALARM_EXPORT_TYPE_CSV");
                if (-1 == name.toLowerCase(Locale.ENGLISH).indexOf(filetype)) {
                    name = name + filetype;
                }
                String filename = dir + File.separator + name;
                EventTaskRequester.saveEventToFile(eventManageDialog, markedEvents, filename, saveFualt, charSet);
            }
        }

        private static String getFilePath(File aFile) {
            try {
                return aFile.getCanonicalPath();
            }
            catch (IOException e) {
                return aFile.toPath().toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private static void saveEventToFile(Window eventManageDialog, List<Event> markedEvents, String fileName, boolean saveFualt, String charSet) {
            BufferedWriter bufferedWriter = null;
            OutputStreamWriter osw = null;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(fileName);
                osw = "GBK".equals(charSet) ? new OutputStreamWriter((OutputStream)outputStream, "GBK") : new OutputStreamWriter((OutputStream)outputStream, Charset.defaultCharset());
                bufferedWriter = new BufferedWriter(osw);
                EventTaskRequester.saveEvents(markedEvents, bufferedWriter, saveFualt);
                DialogUtils.showInfoDialog(eventManageDialog);
            }
            catch (RuntimeException e) {
                LOGGER.error("save marked ss alarm error :" + e);
                DialogUtils.showErrorDialog(eventManageDialog, (Throwable)new IsmException(-11L));
                EventTaskRequester.closeStream(bufferedWriter, osw, outputStream);
            }
            catch (Exception e2) {
                LOGGER.error("save marked alarm error :" + e2);
                DialogUtils.showErrorDialog(eventManageDialog, (Throwable)new IsmException(-11L));
                {
                    catch (Throwable throwable) {
                        EventTaskRequester.closeStream(bufferedWriter, osw, outputStream);
                        throw throwable;
                    }
                }
                EventTaskRequester.closeStream(bufferedWriter, osw, outputStream);
            }
            EventTaskRequester.closeStream(bufferedWriter, osw, outputStream);
        }

        public static void closeStream(Closeable ... cs) {
            if (cs != null) {
                for (Closeable closeable : cs) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("close stream error!" + e);
                    }
                }
            }
        }

        private static void saveEvents(List<Event> markedEvents, BufferedWriter bufferdWriter, boolean saveFualt) throws IOException {
            Boolean flag = true;
            String tableHead = null;
            String alarmStr = null;
            for (Event event : markedEvents) {
                tableHead = "";
                if (flag.booleanValue()) {
                    if (!saveFualt) {
                        tableHead = ResourceManager.getString("ALARM_EXPORT_TABLE_HISTROY_HEAD");
                        bufferdWriter.write(tableHead);
                        bufferdWriter.newLine();
                    } else {
                        tableHead = ResourceManager.getString("ALARM_EXPORT_TABLE_CURRENT_HEAD");
                        bufferdWriter.write(tableHead);
                        bufferdWriter.newLine();
                    }
                }
                alarmStr = EventTaskRequester.convertEventToStr(event, saveFualt);
                bufferdWriter.write(alarmStr);
                bufferdWriter.newLine();
                flag = false;
            }
        }

        private static String convertEventToStr(Event event, boolean isFault) {
            if (null == event) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            EventTaskRequester.createCSVCell(builder, event.getLevel().toString());
            String deviceID = event.getIdentifier().getDeviceID();
            Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
            EventTaskRequester.createCSVCell(builder, null == launcher ? "" : launcher.getDeviceName());
            EventTaskRequester.createCSVCell(builder, "0x" + Long.toHexString(event.getEventID()));
            TimeZone timeZone = TimeZone.getDefault();
            if (null != launcher) {
                timeZone = launcher.getDeviceTimeZone();
            }
            EventTaskRequester.createCSVCell(builder, TimeUtil.gmtToString(EventManager.getInstance().getEventTime(event, true), timeZone));
            if (!isFault) {
                String ret = "";
                if (event.getRecoverTime() > 0L) {
                    ret = TimeUtil.gmtToString(EventManager.getInstance().getEventTime(event, false), timeZone);
                }
                EventTaskRequester.createCSVCell(builder, ret);
            }
            EventTaskRequester.createCSVCell(builder, event.getDescription());
            EventTaskRequester.createCSVCell(builder, event.getDetail());
            EventTaskRequester.createCSVCell(builder, event.getSuggestion());
            return builder.toString();
        }

        private static void createCSVCell(StringBuilder out, String content) {
            out.append('\"');
            if (CsvUtils.isStartswithInvalidChar((String)content)) {
                out.append('\t');
            }
            out.append(content);
            out.append('\"');
            out.append(',');
        }

        private static Callable createClearFaultTask(final List<Event> toBeClearedEvents) {
            return new Callable(){

                public Map<Event.Identifier, Long> call() {
                    Thread.currentThread().setName("Clear fault");
                    HashMap<Event.Identifier, Long> failedMap = new HashMap<Event.Identifier, Long>(0);
                    EventManager.getInstance().manualRecover(toBeClearedEvents, failedMap);
                    return failedMap;
                }
            };
        }

        private static Callable createRefreshFaultEventsTask(final List<String> deviceIDs) {
            return new Callable(){

                public Object call() {
                    Thread.currentThread().setName("Refresh all faults");
                    try {
                        EventManager.getInstance().refreshFaultEvents(deviceIDs.toArray(new String[deviceIDs.size()]));
                    }
                    catch (Exception e) {
                        return e;
                    }
                    return "";
                }
            };
        }

        static Callable createSaveAllEventsTask(final String deviceID, final String filePath) {
            return new Callable(){

                public Object call() {
                    Thread.currentThread().setName("Save all events");
                    EventManager.getInstance().saveAllEvents(deviceID, filePath);
                    return "";
                }
            };
        }

        private static void handleClearFaultResult(Window eventManageDialog, List<Event> toBeClearedEvents, List<?> failedMapList) {
            if (failedMapList.isEmpty()) {
                return;
            }
            Object obj = failedMapList.get(0);
            if (null == obj) {
                return;
            }
            if (obj instanceof Map) {
                Map errorMap = (Map)obj;
                int failsize = errorMap.size();
                if (failsize > 0) {
                    EventTaskRequester.showErrorDialog(eventManageDialog, toBeClearedEvents, errorMap);
                    return;
                }
            } else if (obj instanceof Throwable) {
                DialogUtils.showErrorDialog(eventManageDialog, (Throwable)obj);
            }
        }

        private static void showErrorDialog(Window eventManageDialog, List<Event> toBeClearedEvents, Map<Event.Identifier, Long> errorMsg) {
            String source = ResourceManager.getString("ALARM_TABLE_MODEL_SOURCE");
            String sequenceId = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_NO");
            String description = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_DESC");
            String[] colNames = new String[]{source, sequenceId, description};
            String errinfo = ResourceManager.getString("ALARM_BLOCK_SELECT_CLEAR_SUCCESS") + ' ' + (toBeClearedEvents.size() - errorMsg.size()) + ' ' + ResourceManager.getString("ALARM_COUNT_SURFIX_TITLE") + ' ' + ResourceManager.getString("ALARM_BLOCK_SELECT_CLEAR_FAIL") + ' ' + errorMsg.size() + ' ' + ResourceManager.getString("ALARM_BLOCK_SELECT_BI");
            MultiErrorDialog meDialog = new MultiErrorDialog(eventManageDialog, errinfo, colNames);
            ArrayList<DefaultTableRow<Event.Identifier, Event.Identifier>> tableRows = new ArrayList<DefaultTableRow<Event.Identifier, Event.Identifier>>(0);
            DefaultTableRow<Event.Identifier, Event.Identifier> tableRow = null;
            String deviceID = null;
            IsmException exception = null;
            for (Map.Entry<Event.Identifier, Long> entry : errorMsg.entrySet()) {
                tableRow = new DefaultTableRow<Event.Identifier, Event.Identifier>(colNames.length, entry.getKey(), entry.getKey());
                deviceID = entry.getKey().getDeviceID();
                tableRow.setValueAt(0, EventManagerPanel.getDeviceName(deviceID));
                tableRow.setValueAt(1, entry.getKey().getEventSN());
                exception = new IsmException(entry.getValue());
                tableRow.setValueAt(2, exception.getErrorMessage());
                tableRows.add(tableRow);
            }
            meDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
            meDialog.setVisible(true);
        }

        private static void handleExcuteResult(Window eventManageDialog, List<?> results) {
            if (results.isEmpty()) {
                return;
            }
            Object obj = results.get(0);
            if (obj instanceof BatchExecutionException) {
                DialogUtils.showErrorDialog(eventManageDialog, ((BatchExecutionException)obj).getErrorMessage(0));
            } else if (obj instanceof Throwable) {
                DialogUtils.showErrorDialog(eventManageDialog, (Throwable)obj);
            }
        }
    }

    private class ListenerProxy
    implements ListSelectionListener {
        private final IsmTable table;
        private final EventDetail eventDetail;

        public ListenerProxy(IsmTable table, EventDetail eventDetail) {
            this.table = table;
            this.eventDetail = eventDetail;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (null == e) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            EventManagerPanel.this.updateButtonState();
            this.showEventDetail();
        }

        private void showEventDetail() {
            if (this.table.isStructureChanged()) {
                return;
            }
            this.updateEventDetail();
        }

        public void updateEventDetail() {
            List<TableRow> rows = this.table.getMarkedRows();
            if (Utils.isNullList(this.table.getAllRows())) {
                this.eventDetail.showMainPanel(false, ResourceManager.getString("event.no.data.detail.info.desc"));
                return;
            }
            if (Utils.isNullList(rows)) {
                this.eventDetail.showMainPanel(false, ResourceManager.getString("event.more.data.detail.info.desc"));
                return;
            }
            if (rows.size() == 1) {
                Event event = (Event)rows.get(0).getUserObject();
                this.eventDetail.clearData();
                this.eventDetail.getLblEventLevelValue().setIcon(SwingUtil.getLevelIcon(event.getLevel()));
                this.eventDetail.setData(event);
                this.eventDetail.showMainPanel(true, "");
                return;
            }
            this.eventDetail.showMainPanel(false, ResourceManager.getString("event.more.data.detail.info.desc"));
        }
    }

    private static final class MyCustClearEventListner
    implements ActionListener {
        private final EventTabLayout eventTab;

        private MyCustClearEventListner(EventTabLayout eventTab) {
            this.eventTab = eventTab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.eventTab.getKeywordFilter().setKeyword("");
            this.eventTab.getLevelComboBox().setSelectedIndex(0);
            this.eventTab.getDeviceComboBox().setSelectedIndex(0);
        }
    }

    private static final class MyClearFaultListner
    implements ActionListener {
        private final FaultTabLayout faultTab;

        private MyClearFaultListner(FaultTabLayout faultTab) {
            this.faultTab = faultTab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.faultTab.getKeywordFilter().setKeyword("");
            this.faultTab.getLevelComboBox().setSelectedIndex(0);
            this.faultTab.getDeviceComboBox().setSelectedIndex(0);
        }
    }
}

