/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowable;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowableRule;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.NotBlank;

@Plugin(name="TypeFilterRule", category="Core", elementType="SensitiveThrowableRule", printObject=true)
public class TypeFilterRule
implements SensitiveThrowableRule {
    private final Class<?>[] types;
    private final boolean includeSubTypes;
    private final BiPredicate<Class<?>, Throwable> sensitive;

    @Override
    public boolean isSensitiveThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        for (Class<?> type : this.types) {
            if (!this.sensitive.test(type, throwable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String buildMessage(Throwable throwable) {
        return SensitiveThrowable.buildShieldedMessage(throwable);
    }

    public String toString() {
        return "TypeFilterRule{types=" + Arrays.toString(this.types) + ", includeSubTypes=" + this.includeSubTypes + '}';
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private static boolean isThrowableTypeStrictSame(Class<?> type, Throwable throwable) {
        return type.equals(throwable.getClass());
    }

    private TypeFilterRule(Class<?>[] types, boolean includeSubTypes, BiPredicate<Class<?>, Throwable> sensitive) {
        this.types = types;
        this.includeSubTypes = includeSubTypes;
        this.sensitive = sensitive;
    }

    Class<?>[] getTypes() {
        return this.types;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<TypeFilterRule> {
        @NotBlank
        @PluginBuilderAttribute(value="types")
        private String types;
        @PluginBuilderAttribute(value="includeSubTypes")
        private boolean includeSubTypes = true;

        public TypeFilterRule build() {
            Class[] validTypes = (Class[])Arrays.stream(this.types.split(",")).map(String::trim).filter(type -> !type.isEmpty()).map(this::safeLoad).filter(Objects::nonNull).toArray(Class[]::new);
            return new TypeFilterRule(validTypes, this.includeSubTypes, this.includeSubTypes ? Class::isInstance : (x$0, x$1) -> TypeFilterRule.isThrowableTypeStrictSame(x$0, x$1));
        }

        private Class<?> safeLoad(String type) {
            try {
                return Class.forName(type, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
        }

        public Builder setTypes(String types) {
            this.types = types;
            return this;
        }

        public Builder setIncludeSubTypes(boolean includeSubTypes) {
            this.includeSubTypes = includeSubTypes;
            return this;
        }

        public String getTypes() {
            return this.types;
        }

        public boolean isIncludeSubTypes() {
            return this.includeSubTypes;
        }
    }
}

