/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.PlainFilterRule;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.SensitiveWordsRule;
import java.util.function.Function;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="IncludeDefaultSensitiveWordsRule", category="Core", elementType="SensitiveWordsRule", printObject=true)
public class IncludeDefaultSensitiveWordsRule
implements SensitiveWordsRule {
    public static final String DEFAULT_CONTAINS_SENSITIVE_WORDS = "password,phone,email,e-mail";
    public static final String DEFAULT_MATCHES_SENSITIVE_WORDS = "account,cookie,token,headers,auth,authentication,session,ticket,crypt,psw,pwd,passwd,pawd";
    private final String replacement;
    private final SensitiveWordsRule innerRule;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "IncludeDefaultSensitiveWordsRule{replacement='" + this.replacement + '\'' + '}';
    }

    private IncludeDefaultSensitiveWordsRule(String replacement, SensitiveWordsRule innerRule) {
        this.replacement = replacement;
        this.innerRule = innerRule;
    }

    @Override
    public String filterSensitiveWords(String line) {
        return this.innerRule.filterSensitiveWords(line);
    }

    @Override
    public String apply(String line) {
        return this.innerRule.apply(line);
    }

    @Override
    public <V> Function<V, String> compose(Function<? super V, ? extends String> arg0) {
        return this.innerRule.compose(arg0);
    }

    @Override
    public <V> Function<String, V> andThen(Function<? super String, ? extends V> arg0) {
        return this.innerRule.andThen(arg0);
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<IncludeDefaultSensitiveWordsRule> {
        @PluginBuilderAttribute(value="replacement")
        private String replacement;

        public IncludeDefaultSensitiveWordsRule build() {
            PlainFilterRule contains = PlainFilterRule.newBuilder().setTarget(IncludeDefaultSensitiveWordsRule.DEFAULT_CONTAINS_SENSITIVE_WORDS).setSeparator(",").setCaseSensitive(false).setMatchWords(false).setReplacement(this.replacement).build();
            PlainFilterRule matches = PlainFilterRule.newBuilder().setTarget(IncludeDefaultSensitiveWordsRule.DEFAULT_MATCHES_SENSITIVE_WORDS).setSeparator(",").setCaseSensitive(false).setMatchWords(true).setReplacement(this.replacement).build();
            return new IncludeDefaultSensitiveWordsRule(this.replacement, SensitiveWordsRule.composite(contains, matches));
        }

        public Builder setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }
}

