/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.sdk.context;

import com.huawei.fit.hakuna.system.context.worldwide.ClearRouteContext;
import com.huawei.fit.hakuna.system.context.worldwide.GetAllRouteContext;
import com.huawei.fit.hakuna.system.context.worldwide.GetRouteContext;
import com.huawei.fit.hakuna.system.context.worldwide.PutRouteContext;
import com.huawei.fit.hakuna.system.context.worldwide.RemoveRouteContext;
import com.huawei.fit.sdk.context.ClearGlobalContext;
import com.huawei.fit.sdk.context.GetAllGlobalContext;
import com.huawei.fit.sdk.context.GetGlobalContext;
import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fit.sdk.context.RestoreGlobalContext;
import com.huawei.fit.sdk.context.entity.GlobalContext;
import com.huawei.fit.sdk.context.entity.Pair;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.sdk.context.ThreadLocalUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@FitableSuite
public class FitGlobalContext {
    private static final String ROUTE_CONTEXT_PREFIX = "fit.route.";
    private final ThreadLocal<Map<String, String>> globalContext = ThreadLocal.withInitial(HashMap::new);

    @Fitable(generic=GetGlobalContext.class, id="e816cc15191e48449e2ae0f7285cf3e6")
    public String getGlobalContext(String key) {
        return ThreadLocalUtils.get(this.globalContext, key).orElse(null);
    }

    @Fitable(generic=PutGlobalContext.class, id="943fc545d96c4ca3bcefea5b606de7ce")
    public Boolean putGlobalContext(String key, String value) {
        return ThreadLocalUtils.put(this.globalContext, key, value);
    }

    @Fitable(generic=RemoveGlobalContext.class, id="2f5925f102164629b785771875cff402")
    public Boolean removeGlobalContext(String key) {
        return ThreadLocalUtils.remove(this.globalContext, key);
    }

    @Fitable(generic=GetAllGlobalContext.class, id="7ef02642227648759626c927cbcfcfe1")
    public GlobalContext getAllGlobalContext() {
        return GlobalContext.builder().pair(ThreadLocalUtils.getAll(this.globalContext).entrySet().stream().map(entry -> Pair.builder().key((String)entry.getKey()).value((String)entry.getValue()).build()).collect(Collectors.toList())).build();
    }

    @Fitable(generic=RestoreGlobalContext.class, id="de2cddd470dc46d5aed6332168deb926")
    public Boolean restoreGlobalContext(GlobalContext context) {
        if (context == null || CollectionUtils.isEmpty((Collection)context.getPair())) {
            return true;
        }
        context.getPair().forEach(pair -> ThreadLocalUtils.put(this.globalContext, pair.getKey(), pair.getValue()));
        return true;
    }

    @Fitable(generic=ClearGlobalContext.class, id="140c86b4a7df4447b34462e95fc39c23")
    public Boolean clearGlobalContext() {
        ThreadLocalUtils.clear(this.globalContext);
        return true;
    }

    @Fitable(generic=RemoveRouteContext.class, id="3023d00e060147278a6582e8de661494")
    public Boolean removeRouteContext(String key) {
        return this.removeGlobalContext(this.wrapRouteKey(key));
    }

    @Fitable(generic=ClearRouteContext.class, id="7f913120b8ce4ebdac2078eecaad3bbb")
    public Boolean clearRouteContext() {
        this.getAllGlobalContext().getPair().stream().map(Pair::getKey).filter(Objects::nonNull).filter(key -> key.startsWith(ROUTE_CONTEXT_PREFIX)).forEach(this::removeGlobalContext);
        return true;
    }

    @Fitable(generic=GetRouteContext.class, id="b08da25f32ac40cabda24f43c1c3ff3c")
    public String getRouteContext(String key) {
        return this.getGlobalContext(this.wrapRouteKey(key));
    }

    @Fitable(generic=PutRouteContext.class, id="49a91f9949b3421bbf00148a11f4f990")
    public Boolean putRouteContext(String key, String value) {
        return this.putGlobalContext(this.wrapRouteKey(key), value);
    }

    @Fitable(generic=GetAllRouteContext.class, id="16b7bf3b58b24ac2849cdc8bc0dee256")
    public Map<String, String> getAllRouteContext() {
        return this.getAllGlobalContext().getPair().stream().filter(pair -> pair.getKey() != null).filter(pair -> pair.getKey().startsWith(ROUTE_CONTEXT_PREFIX)).collect(Collectors.toMap(pair -> this.unWrapRouteKey(pair.getKey()), Pair::getValue, (v1, v2) -> v2));
    }

    private String wrapRouteKey(String routeKey) {
        return ROUTE_CONTEXT_PREFIX + routeKey;
    }

    private String unWrapRouteKey(String wrappedRouteKey) {
        if (wrappedRouteKey == null) {
            return null;
        }
        return wrappedRouteKey.replace(ROUTE_CONTEXT_PREFIX, "");
    }
}

